/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.payara.common.parser.TreeParser;
import org.netbeans.modules.payara.common.wizards.ServerWizardIterator;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public enum ServerDetails {
    PAYARA_SERVER_4_1_144(NbBundle.getMessage(ServerDetails.class, (String)"STR_41144_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 41144, "https://github.com/payara/Payara/releases/download/payara-server-4.1.144/payara.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_151(NbBundle.getMessage(ServerDetails.class, (String)"STR_41151_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 41151, "https://github.com/payara/Payara/releases/download/payara-server-4.1.151/payara-4.1.151.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_152(NbBundle.getMessage(ServerDetails.class, (String)"STR_41152_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 41152, "https://github.com/payara/Payara/releases/download/payara-server-4.1.152/payara-4.1.152.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_153(NbBundle.getMessage(ServerDetails.class, (String)"STR_41153_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 41153, "https://github.com/payara/Payara/releases/download/payara-server-4.1.153/payara-4.1.153.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_1_154(NbBundle.getMessage(ServerDetails.class, (String)"STR_411154_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 411154, "hhttps://github.com/payara/Payara/releases/download/payara-server-4.1.1.154/payara-4.1.1.154.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_1_161(NbBundle.getMessage(ServerDetails.class, (String)"STR_411161_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 411161, "https://github.com/payara/Payara/releases/download/payara-server-4.1.1.161/payara-4.1.1.161.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_1_162(NbBundle.getMessage(ServerDetails.class, (String)"STR_411162_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 411162, "https://github.com/payara/Payara/releases/download/payara-server-4.1.1.162/payara-4.1.1.162.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_1_163(NbBundle.getMessage(ServerDetails.class, (String)"STR_411163_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 411163, "https://github.com/payara/Payara/releases/download/4.1.1.163/payara-4.1.1.163.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_1_164(NbBundle.getMessage(ServerDetails.class, (String)"STR_411164_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 411164, "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/4.1.1.164/payara-4.1.1.164.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_1_171(NbBundle.getMessage(ServerDetails.class, (String)"STR_411171_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 411171, "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/4.1.1.171/payara-4.1.1.171.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_2_172(NbBundle.getMessage(ServerDetails.class, (String)"STR_412172_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 412172, "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/4.1.2.172/payara-4.1.2.172.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_2_173(NbBundle.getMessage(ServerDetails.class, (String)"STR_412173_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 412173, "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/4.1.2.173/payara-4.1.2.173.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_2_174(NbBundle.getMessage(ServerDetails.class, (String)"STR_412174_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 412174, "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/4.1.2.174/payara-4.1.2.174.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_4_1_2_181(NbBundle.getMessage(ServerDetails.class, (String)"STR_412181_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv4ee7", 412181, "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/4.1.2.181/payara-4.1.2.181.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_5_181(NbBundle.getMessage(ServerDetails.class, (String)"STR_5181_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv5ee8", 5181, "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/5.181/payara-5.181.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_5_182(NbBundle.getMessage(ServerDetails.class, (String)"STR_5182_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv5ee8", 5182, "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/5.182/payara-5.182.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_5_183(NbBundle.getMessage(ServerDetails.class, (String)"STR_5183_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv5ee8", 5183, "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/5.183/payara-5.183.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_5_184(NbBundle.getMessage(ServerDetails.class, (String)"STR_5184_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv5ee8", 5184, "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/5.184/payara-5.184.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_5_191(NbBundle.getMessage(ServerDetails.class, (String)"STR_5191_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv5ee8", 5191, "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/5.191/payara-5.191.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt"),
    PAYARA_SERVER_5_192(NbBundle.getMessage(ServerDetails.class, (String)"STR_5192_SERVER_NAME", (Object[])new Object[0]), "deployer:pfv5ee8", 5192, "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/5.192/payara-5.192.zip", null, "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt");

    private final String displayName;
    private final String uriFragment;
    private final String indirectUrl;
    private final String directUrl;
    private final String licenseUrl;
    private final int versionInt;

    public static WizardDescriptor.InstantiatingIterator getInstantiatingIterator() {
        return new ServerWizardIterator(new ServerDetails[]{PAYARA_SERVER_5_192, PAYARA_SERVER_5_191, PAYARA_SERVER_5_184, PAYARA_SERVER_5_183, PAYARA_SERVER_5_182, PAYARA_SERVER_5_181, PAYARA_SERVER_4_1_2_181, PAYARA_SERVER_4_1_2_174, PAYARA_SERVER_4_1_2_173, PAYARA_SERVER_4_1_2_172, PAYARA_SERVER_4_1_1_171, PAYARA_SERVER_4_1_1_164, PAYARA_SERVER_4_1_1_163, PAYARA_SERVER_4_1_1_162, PAYARA_SERVER_4_1_1_161, PAYARA_SERVER_4_1_1_154, PAYARA_SERVER_4_1_153, PAYARA_SERVER_4_1_152, PAYARA_SERVER_4_1_151, PAYARA_SERVER_4_1_144}, new ServerDetails[]{PAYARA_SERVER_5_192, PAYARA_SERVER_5_191, PAYARA_SERVER_5_184, PAYARA_SERVER_5_183, PAYARA_SERVER_5_182, PAYARA_SERVER_5_181, PAYARA_SERVER_4_1_2_181, PAYARA_SERVER_4_1_2_174, PAYARA_SERVER_4_1_2_173, PAYARA_SERVER_4_1_2_172, PAYARA_SERVER_4_1_1_171, PAYARA_SERVER_4_1_1_164, PAYARA_SERVER_4_1_1_163, PAYARA_SERVER_4_1_1_162, PAYARA_SERVER_4_1_1_161});
    }

    public static int getVersionFromInstallDirectory(File payaraDir) {
        if (payaraDir == null) {
            return -1;
        }
        PayaraVersion version = ServerUtils.getServerVersion((String)payaraDir.getAbsolutePath());
        ServerDetails sd = null;
        if (version != null) {
            switch (version) {
                case PF_4_1_144: {
                    return PAYARA_SERVER_4_1_144.getVersion();
                }
                case PF_4_1_151: {
                    return PAYARA_SERVER_4_1_151.getVersion();
                }
                case PF_4_1_153: {
                    return PAYARA_SERVER_4_1_153.getVersion();
                }
                case PF_4_1_1_154: {
                    return PAYARA_SERVER_4_1_1_154.getVersion();
                }
                case PF_4_1_1_161: {
                    return PAYARA_SERVER_4_1_1_161.getVersion();
                }
                case PF_4_1_1_162: {
                    return PAYARA_SERVER_4_1_1_162.getVersion();
                }
                case PF_4_1_1_163: {
                    return PAYARA_SERVER_4_1_1_163.getVersion();
                }
                case PF_4_1_1_171: {
                    return PAYARA_SERVER_4_1_1_171.getVersion();
                }
                case PF_4_1_2_172: {
                    return PAYARA_SERVER_4_1_2_172.getVersion();
                }
                case PF_4_1_2_173: {
                    return PAYARA_SERVER_4_1_2_173.getVersion();
                }
                case PF_4_1_2_174: {
                    return PAYARA_SERVER_4_1_2_174.getVersion();
                }
                case PF_4_1_2_181: {
                    return PAYARA_SERVER_4_1_2_181.getVersion();
                }
                case PF_5_181: {
                    return PAYARA_SERVER_5_181.getVersion();
                }
                case PF_5_182: {
                    return PAYARA_SERVER_5_182.getVersion();
                }
                case PF_5_183: {
                    return PAYARA_SERVER_5_183.getVersion();
                }
                case PF_5_184: {
                    return PAYARA_SERVER_5_184.getVersion();
                }
                case PF_5_191: {
                    return PAYARA_SERVER_5_191.getVersion();
                }
                case PF_5_192: {
                    return PAYARA_SERVER_5_192.getVersion();
                }
            }
            return -1;
        }
        return null == sd ? -1 : sd.getVersion();
    }

    @Deprecated
    public static int getVersionFromDomainXml(File domainXml) throws IllegalStateException {
        if (null == domainXml || !domainXml.isFile() || !domainXml.canRead()) {
            return -1;
        }
        return ServerDetails.hasDefaultConfig(domainXml) ? PAYARA_SERVER_5_192.getVersion() : PAYARA_SERVER_5_181.getVersion();
    }

    private static boolean hasDefaultConfig(File domainXml) throws IllegalStateException {
        DomainParser dp = new DomainParser();
        ArrayList<TreeParser.Path> paths = new ArrayList<TreeParser.Path>();
        paths.add(new TreeParser.Path("/domain/configs/config", dp));
        TreeParser.readXml(domainXml, paths);
        return dp.hasDefaultConfig();
    }

    private ServerDetails(String displayName, String uriFragment, int versionInt, String directUrl, String indirectUrl, String licenseUrl) {
        this.displayName = displayName;
        this.uriFragment = uriFragment;
        this.indirectUrl = indirectUrl;
        this.directUrl = directUrl;
        this.versionInt = versionInt;
        this.licenseUrl = licenseUrl;
    }

    public String toString() {
        return this.displayName;
    }

    public String getUriFragment() {
        return this.uriFragment;
    }

    public int getVersion() {
        return this.versionInt;
    }

    public boolean isInstalledInDirectory(File payaraDir) {
        return ServerDetails.getVersionFromInstallDirectory(payaraDir) == this.getVersion();
    }

    public String getDirectUrl() {
        return this.directUrl;
    }

    public String getIndirectUrl() {
        return this.indirectUrl;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    static class DomainParser
    extends TreeParser.NodeReader {
        private boolean hasDefaultConfig = false;

        DomainParser() {
        }

        private boolean hasDefaultConfig() {
            return this.hasDefaultConfig;
        }

        @Override
        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            String name = attributes.getValue("name");
            if ("default-config".equals(name)) {
                this.hasDefaultConfig = true;
            }
        }
    }
}

