/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.netbeans.modules.netserver.SocketFramework;

public class SocketClient
extends SocketFramework {
    private SocketChannel socketChannel;
    private Queue<ByteBuffer> writeQueue = new ConcurrentLinkedQueue<ByteBuffer>();

    public SocketClient(SocketAddress address) throws IOException {
        this.socketChannel = SocketChannel.open();
        this.socketChannel.configureBlocking(false);
        this.socketChannel.connect(address);
        this.socketChannel.register(this.getSelector(), 8);
    }

    @Override
    public void run() {
        super.run();
        this.chanelClosed(null);
        try {
            this.socketChannel.close();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, null, e);
        }
    }

    @Override
    protected void chanelClosed(SelectionKey key) {
    }

    @Override
    protected SocketAddress getAddress() {
        return this.socketChannel.socket().getRemoteSocketAddress();
    }

    @Override
    protected void process(SelectionKey key) throws IOException {
        if (key.isConnectable()) {
            this.finishConnect(key);
        }
        super.process(key);
    }

    protected SocketChannel getChannel() {
        return this.socketChannel;
    }

    protected void finishConnect(SelectionKey key) throws IOException {
        if (this.socketChannel.isConnectionPending()) {
            this.socketChannel.finishConnect();
        }
        this.socketChannel.register(this.getSelector(), 1);
    }

    @Override
    protected Queue<ByteBuffer> getWriteQueue(SelectionKey key) {
        return this.writeQueue;
    }
}

