/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeimage.api.debug;

import java.io.File;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.openide.util.Lookup;

public final class StartDebugParameters {
    private final List<String> command;
    private final File workingDirectory;
    private final String debugger;
    private final String displayName;
    private final boolean displayObjects;
    private final Long processId;
    private final ExecutionDescriptor executionDescriptor;
    private final Lookup contextLookup;

    private StartDebugParameters(List<String> command, File workingDirectory, String debugger, String displayName, boolean displayObjects, Long processId, ExecutionDescriptor executionDescriptor, Lookup contextLookup) {
        this.command = command;
        this.workingDirectory = workingDirectory;
        this.debugger = debugger;
        this.displayName = displayName;
        this.displayObjects = displayObjects;
        this.processId = processId;
        this.executionDescriptor = executionDescriptor;
        this.contextLookup = contextLookup;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getDebugger() {
        return this.debugger;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isDebuggerDisplayObjects() {
        return this.displayObjects;
    }

    @CheckForNull
    public Long getProcessId() {
        return this.processId;
    }

    public ExecutionDescriptor getExecutionDescriptor() {
        return this.executionDescriptor;
    }

    public Lookup getContextLookup() {
        return this.contextLookup;
    }

    public static Builder newBuilder(List<String> command) {
        return new Builder(command);
    }

    public static final class Builder {
        private final List<String> command;
        private File workingDirectory;
        private String debugger;
        private String displayName;
        private boolean displayObjects = true;
        private Long processId = null;
        private ExecutionDescriptor executionDescriptor;
        private Lookup contextLookup;

        Builder(List<String> command) {
            this.command = command;
        }

        public Builder workingDirectory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder debugger(String debugger) {
            this.debugger = debugger;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder debuggerDisplayObjects(boolean displayObjects) {
            this.displayObjects = displayObjects;
            return this;
        }

        public Builder processID(@NullAllowed Long processId) {
            this.processId = processId;
            return this;
        }

        public Builder executionDescriptor(ExecutionDescriptor executionDescriptor) {
            this.executionDescriptor = executionDescriptor;
            return this;
        }

        public Builder lookup(Lookup contextLookup) {
            this.contextLookup = contextLookup;
            return this;
        }

        public StartDebugParameters build() {
            return new StartDebugParameters(this.command, this.workingDirectory, this.debugger, this.displayName, this.displayObjects, this.processId, this.executionDescriptor, this.contextLookup);
        }
    }
}

