/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeimage.api;

public final class Symbol {
    private final String name;
    private final String type;
    private final String description;

    private Symbol(String name, String type, String description) {
        this.name = name;
        this.type = type;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "Symbol{name=" + this.name + ", type=" + this.type + ", description=" + this.description + '}';
    }

    public static final class Builder {
        private String name;
        private String type;
        private String description;

        Builder() {
        }

        public void name(String name) {
            this.name = name;
        }

        public void type(String type) {
            this.type = type;
        }

        public void description(String description) {
            this.description = description;
        }

        public Symbol build() {
            if (this.name == null) {
                throw new IllegalArgumentException("Name must be defined.");
            }
            return new Symbol(this.name, this.type, this.description);
        }
    }
}

