/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.hints;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.netbeans.api.lsp.Diagnostic;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.micronaut.MicronautConfigUtilities;
import org.netbeans.modules.micronaut.hints.Bundle;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.ErrorsCache;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.spi.lsp.ErrorProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class MicronautConfigErrorProvider
extends CustomIndexer
implements ErrorProvider {
    private static final MicronautConfigErrorProvider INSTANCE = new MicronautConfigErrorProvider();
    private static final ErrorsCache.Convertor<Diagnostic> ERROR_CONVERTOR = new ErrorConvertorImpl();
    private static final String ERR_CODE_PREFIX = "WARN_PropertyWithoutValue:";

    public static MicronautConfigErrorProvider createProvider() {
        return INSTANCE;
    }

    public List<? extends Diagnostic> computeErrors(ErrorProvider.Context context) {
        FileObject fo;
        if (context.errorKind() == ErrorProvider.Kind.ERRORS && (fo = context.file()) != null && MicronautConfigUtilities.isMicronautConfigFile(fo)) {
            return this.computeErrors(fo);
        }
        return Collections.emptyList();
    }

    protected void index(Iterable<? extends Indexable> files, Context context) {
        FileObject root = context.getRoot();
        for (Indexable indexable : files) {
            FileObject fo = root.getFileObject(indexable.getRelativePath());
            if (fo == null || !MicronautConfigUtilities.isMicronautConfigFile(fo)) continue;
            ErrorsCache.setErrors((URL)context.getRootURI(), (Indexable)indexable, this.computeErrors(fo), ERROR_CONVERTOR);
        }
    }

    private List<? extends Diagnostic> computeErrors(FileObject fo) {
        final ArrayList<Diagnostic> diags = new ArrayList<Diagnostic>();
        if ("text/x-yaml".equals(fo.getMIMEType())) {
            try {
                ParserManager.parse(Collections.singletonList(Source.create((FileObject)fo)), (UserTask)new UserTask(){

                    public void run(ResultIterator it) throws Exception {
                        StructureScanner scanner;
                        Language language;
                        Snapshot snapshot;
                        Parser.Result result = it.getParserResult();
                        Snapshot snapshot2 = snapshot = result != null ? result.getSnapshot() : null;
                        if (snapshot != null && (language = LanguageRegistry.getInstance().getLanguageByMimeType(snapshot.getMimeType())) != null && (scanner = language.getStructure()) != null && result instanceof ParserResult) {
                            String text = snapshot.getText().toString();
                            MicronautConfigErrorProvider.scan(text, scanner.scan((ParserResult)result), structure -> {
                                int start = (int)structure.getPosition();
                                int end = (int)structure.getEndPosition();
                                diags.add(Diagnostic.Builder.create(() -> start, () -> end, (String)Bundle.ERR_PropertyWithoutValue()).setSeverity(Diagnostic.Severity.Warning).setCode(MicronautConfigErrorProvider.ERR_CODE_PREFIX + text.substring(0, start).split("\n").length).build());
                            });
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            int offset = 0;
            String[] lines = Source.create((FileObject)fo).createSnapshot().getText().toString().split("\n");
            for (int i = 0; i < lines.length; ++i) {
                int eqIdx;
                String line = lines[i];
                if (line.length() > 0 && !line.startsWith("#") && !line.startsWith("!") && (eqIdx = line.indexOf(61)) > 0 && line.substring(eqIdx + 1).trim().length() == 0) {
                    int start = offset;
                    int end = offset + line.length();
                    diags.add(Diagnostic.Builder.create(() -> start, () -> end, (String)Bundle.ERR_PropertyWithoutValue()).setSeverity(Diagnostic.Severity.Warning).setCode(ERR_CODE_PREFIX + (i + 1)).build());
                }
                offset += line.length() + 1;
            }
        }
        return diags;
    }

    private static void scan(String sourceText, List<? extends StructureItem> structures, Consumer<StructureItem> callback) {
        if (structures != null) {
            for (StructureItem structureItem : structures) {
                if (structureItem.isLeaf()) {
                    int end;
                    int start = (int)structureItem.getPosition();
                    String text = sourceText.substring(start, end = (int)structureItem.getEndPosition());
                    int idx = text.indexOf(58);
                    if (idx < 0 || text.substring(idx + 1).trim().length() != 0) continue;
                    callback.accept(structureItem);
                    continue;
                }
                MicronautConfigErrorProvider.scan(sourceText, structureItem.getNestedItems(), callback);
            }
        }
    }

    private static final class ErrorConvertorImpl
    implements ErrorsCache.Convertor<Diagnostic> {
        private ErrorConvertorImpl() {
        }

        public ErrorsCache.ErrorKind getKind(Diagnostic t) {
            return t.getSeverity() == Diagnostic.Severity.Error ? ErrorsCache.ErrorKind.ERROR : ErrorsCache.ErrorKind.WARNING;
        }

        public int getLineNumber(Diagnostic t) {
            return Integer.parseInt(t.getCode().substring(MicronautConfigErrorProvider.ERR_CODE_PREFIX.length()));
        }

        public String getMessage(Diagnostic t) {
            return t.getDescription();
        }
    }

    public static final class CIFImpl
    extends CustomIndexerFactory {
        public CustomIndexer createIndexer() {
            return INSTANCE;
        }

        public boolean supportsEmbeddedIndexers() {
            return false;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return "mn";
        }

        public int getIndexVersion() {
            return 1;
        }
    }
}

