/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.hyperlink;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.lsp.HyperlinkLocation;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.micronaut.MicronautConfigUtilities;
import org.netbeans.modules.micronaut.hyperlink.Bundle;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.IndexingAwareParserResultTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.spi.lsp.HyperlinkLocationProvider;
import org.openide.filesystems.FileObject;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataSource;

public class MicronautConfigHyperlinkProvider
implements HyperlinkProviderExt {
    private static final String SPANS_PROPERTY_NAME = "MicronautConfigHyperlinkSpans";

    public static MicronautConfigHyperlinkProvider createYamlProvider() {
        return new MicronautConfigHyperlinkProvider();
    }

    public static MicronautConfigHyperlinkProvider createPropertiesProvider() {
        return new MicronautConfigHyperlinkProvider();
    }

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        String mimeType = DocumentUtilities.getMimeType((Document)doc);
        if ("text/x-yaml".equals(mimeType)) {
            List spans = null;
            Document document = doc;
            synchronized (document) {
                spans = (List)doc.getProperty(SPANS_PROPERTY_NAME);
            }
            if (spans != null) {
                for (int[] span : spans) {
                    if (span.length != 2 || span[0] > offset || offset > span[1]) continue;
                    return span;
                }
            }
            return null;
        }
        int[] span = new int[2];
        ArrayList<ConfigurationMetadataSource> sources = new ArrayList<ConfigurationMetadataSource>();
        ConfigurationMetadataProperty property = MicronautConfigUtilities.resolveProperty(doc, offset, span, sources);
        return (int[])(property != null || !sources.isEmpty() ? span : null);
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        AtomicBoolean cancel = new AtomicBoolean();
        BaseProgressUtils.runOffEventDispatchThread(() -> {
            ArrayList<ConfigurationMetadataSource> sources = new ArrayList<ConfigurationMetadataSource>();
            ConfigurationMetadataProperty property = MicronautConfigUtilities.resolveProperty(doc, offset, null, sources);
            if (!sources.isEmpty()) {
                ClasspathInfo cpInfo = ClasspathInfo.create((Document)doc);
                for (ConfigurationMetadataSource source : sources) {
                    ElementHandle handle;
                    if (property != null && source.getProperties().get(property.getId()) != property || (handle = MicronautConfigUtilities.getElementHandle(cpInfo, source.getType(), property != null ? property.getName() : null, cancel)) == null || !ElementOpen.open((ClasspathInfo)cpInfo, (ElementHandle)handle)) continue;
                    return;
                }
                Toolkit.getDefaultToolkit().beep();
            }
        }, (String)Bundle.LBL_GoToDeclaration(), (AtomicBoolean)cancel, (boolean)false);
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        ConfigurationMetadataProperty property = MicronautConfigUtilities.resolveProperty(doc, offset, null, null);
        if (property != null) {
            StringBuilder sb = new StringBuilder("<html><body>");
            sb.append("<b>").append(property.getId().replace(".", ".&#x200B;")).append("</b>");
            String propertyType = property.getType();
            if (propertyType != null) {
                sb.append("<pre>").append(propertyType).append("</pre>");
            }
            return sb.toString();
        }
        return null;
    }

    public static class LocationProvider
    implements HyperlinkLocationProvider {
        public static LocationProvider createYamlProvider() {
            return new LocationProvider();
        }

        public static LocationProvider createPropertiesProvider() {
            return new LocationProvider();
        }

        public CompletableFuture<HyperlinkLocation> getHyperlinkLocation(Document doc, int offset) {
            AtomicBoolean cancel = new AtomicBoolean();
            ArrayList<ConfigurationMetadataSource> sources = new ArrayList<ConfigurationMetadataSource>();
            ConfigurationMetadataProperty property = MicronautConfigUtilities.resolveProperty(doc, offset, null, sources);
            if (!sources.isEmpty()) {
                ClasspathInfo cpInfo = ClasspathInfo.create((Document)doc);
                for (ConfigurationMetadataSource source : sources) {
                    String typeName;
                    ElementHandle handle;
                    if (property != null && source.getProperties().get(property.getId()) != property || (handle = MicronautConfigUtilities.getElementHandle(cpInfo, typeName = source.getType(), property != null ? property.getName() : null, cancel)) == null) continue;
                    CompletableFuture future = ElementOpen.getLocation((ClasspathInfo)cpInfo, (ElementHandle)handle, (String)(typeName.replace('.', '/') + ".class"));
                    return future.thenApply(location -> location != null ? HyperlinkLocationProvider.createHyperlinkLocation((FileObject)location.getFileObject(), (int)location.getStartOffset(), (int)location.getEndOffset()) : null);
                }
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    public static final class Task
    extends IndexingAwareParserResultTask<Parser.Result> {
        private final AtomicBoolean cancel = new AtomicBoolean();
        private final Project project;

        public Task(Project project) {
            super(TaskIndexingMode.ALLOWED_DURING_SCAN);
            this.project = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Parser.Result result, SchedulerEvent event) {
            if (this.cancel.get()) {
                return;
            }
            Document doc = result.getSnapshot().getSource().getDocument(false);
            if (doc != null) {
                List<int[]> spans = MicronautConfigUtilities.getPropertySpans(this.project, result);
                Document document = doc;
                synchronized (document) {
                    doc.putProperty(MicronautConfigHyperlinkProvider.SPANS_PROPERTY_NAME, spans);
                }
            }
        }

        public int getPriority() {
            return 200;
        }

        public Class<? extends Scheduler> getSchedulerClass() {
            return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
        }

        public void cancel() {
            this.cancel.set(true);
        }

        public static final class Factory
        extends TaskFactory {
            public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
                Project project;
                FileObject fo = snapshot.getSource().getFileObject();
                if (MicronautConfigUtilities.isMicronautConfigFile(fo) && (project = FileOwnerQuery.getOwner((FileObject)fo)) != null && MicronautConfigProperties.hasConfigMetadata(project)) {
                    return Collections.singleton(new Task(project));
                }
                return Collections.emptySet();
            }
        }
    }
}

