/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataGroup;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataSource;

public class MicronautConfigUtilities {
    private static final Pattern REGEXP = Pattern.compile("^(application|bootstrap)(-\\w*)*\\.(yml|properties)$", 2);
    public static final String YAML_MIME = "text/x-yaml";
    public static final String PROPERTIES_MIME = "text/x-properties";

    public static boolean isMicronautConfigFile(FileObject fo) {
        return fo != null && REGEXP.matcher(fo.getNameExt()).matches();
    }

    public static ConfigurationMetadataProperty resolveProperty(Document doc, final int offset, final int[] span, final List<ConfigurationMetadataSource> sources) {
        Project project;
        FileObject fo;
        final LineDocument lineDocument = (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class);
        if (lineDocument != null && MicronautConfigUtilities.isMicronautConfigFile(fo = EditorDocumentUtils.getFileObject((Document)doc)) && (project = FileOwnerQuery.getOwner((FileObject)fo)) != null && MicronautConfigProperties.hasConfigMetadata(project)) {
            try {
                int lineStart = LineDocumentUtils.getLineStart((LineDocument)lineDocument, (int)offset);
                String mimeType = DocumentUtilities.getMimeType((Document)doc);
                if (YAML_MIME.equals(mimeType)) {
                    int idx;
                    String text = lineDocument.getText(lineStart, offset - lineStart);
                    if (!text.startsWith("#") && (idx = text.indexOf(58)) < 0) {
                        final ConfigurationMetadataProperty[] property = new ConfigurationMetadataProperty[]{null};
                        ParserManager.parse(Collections.singleton(Source.create((Document)lineDocument)), (UserTask)new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                List structures;
                                List context;
                                StructureScanner scanner;
                                Language language;
                                Parser.Result r = resultIterator.getParserResult();
                                if (r instanceof ParserResult && (language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType())) != null && (scanner = language.getStructure()) != null && !(context = MicronautConfigUtilities.getContext(structures = scanner.scan((ParserResult)r), offset)).isEmpty()) {
                                    StructureItem item = (StructureItem)context.get(context.size() - 1);
                                    int start = (int)item.getPosition();
                                    int end = (int)item.getPosition() + item.getName().length();
                                    if (span != null && span.length == 2) {
                                        span[0] = start;
                                        span[1] = end;
                                    }
                                    if (start <= offset && offset <= end && item.getName().equals(lineDocument.getText(start, end - start))) {
                                        property[0] = MicronautConfigUtilities.getProperty(MicronautConfigProperties.getGroups(project), MicronautConfigUtilities.getPropertyName(context), sources);
                                    }
                                }
                            }
                        });
                        return property[0];
                    }
                } else {
                    int lineEnd = LineDocumentUtils.getLineEnd((LineDocument)lineDocument, (int)offset);
                    String text = lineDocument.getText(lineStart, lineEnd - lineStart);
                    if (!text.startsWith("#") && !text.startsWith("!")) {
                        int eqIdx;
                        int colIdx = text.indexOf(58);
                        int endIdx = Math.min(colIdx, eqIdx = text.indexOf(61));
                        if (endIdx < 0) {
                            endIdx = Math.max(colIdx, eqIdx);
                        }
                        if (endIdx < 0 || offset < lineStart + endIdx) {
                            if (endIdx > 0) {
                                text = text.substring(0, endIdx);
                            }
                            String propertyName = text.trim();
                            int idx = text.indexOf(propertyName);
                            if (propertyName != null && !propertyName.isEmpty() && lineStart + idx <= offset && lineStart + idx + propertyName.length() >= offset) {
                                for (Map.Entry<String, ConfigurationMetadataGroup> groupEntry : MicronautConfigProperties.getGroups(project).entrySet()) {
                                    String groupKey = groupEntry.getKey();
                                    if (groupKey.endsWith(".*")) {
                                        groupKey = groupKey.substring(0, groupKey.length() - 2);
                                    }
                                    if (!Pattern.matches(groupKey.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\\\w*") + ".*", propertyName)) continue;
                                    ConfigurationMetadataGroup group = groupEntry.getValue();
                                    if (sources != null) {
                                        sources.addAll(group.getSources().values());
                                    }
                                    for (Map.Entry propertyEntry : group.getProperties().entrySet()) {
                                        String propertyKey = (String)propertyEntry.getKey();
                                        if (!Pattern.matches(propertyKey.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\\\w*"), propertyName)) continue;
                                        return (ConfigurationMetadataProperty)propertyEntry.getValue();
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public static void collectUsages(final FileObject fo, final String propertyName, final Consumer<Usage> consumer) {
        try {
            String mimeType = fo.getMIMEType();
            if (YAML_MIME.equals(mimeType)) {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)fo)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        StructureScanner scanner;
                        Language language;
                        Parser.Result r = resultIterator.getParserResult();
                        if (r instanceof ParserResult && (language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType())) != null && (scanner = language.getStructure()) != null) {
                            MicronautConfigUtilities.find(fo, propertyName, scanner.scan((ParserResult)r), r.getSnapshot().getText(), consumer);
                        }
                    }
                });
            } else {
                String[] lines = fo.asText().split("\n");
                Pattern pattern = Pattern.compile("^\\s*(" + propertyName.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\\\w*") + ")\\s*([=:].*)?$");
                int off = 0;
                for (String line : lines) {
                    Matcher matcher = pattern.matcher(line);
                    if (matcher.matches()) {
                        consumer.accept(new Usage(fo, off + matcher.start(1), off + matcher.end(1), line.trim()));
                    }
                    off += line.length() + 1;
                }
            }
        }
        catch (IOException | ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static List<int[]> getPropertySpans(Project project, Parser.Result r) {
        StructureScanner scanner;
        Language language;
        ArrayList<int[]> spans = new ArrayList<int[]>();
        if (r instanceof ParserResult && (language = LanguageRegistry.getInstance().getLanguageByMimeType(r.getSnapshot().getMimeType())) != null && (scanner = language.getStructure()) != null) {
            Map<String, ConfigurationMetadataGroup> groups = MicronautConfigProperties.getGroups(project);
            MicronautConfigUtilities.scan(scanner.scan((ParserResult)r), new Stack<StructureItem>(), context -> {
                ArrayList<ConfigurationMetadataSource> sources;
                String propertyName;
                ConfigurationMetadataProperty property;
                if (!(context.empty() || (property = MicronautConfigUtilities.getProperty(groups, propertyName = MicronautConfigUtilities.getPropertyName(context), sources = new ArrayList<ConfigurationMetadataSource>())) == null && sources.isEmpty())) {
                    StructureItem item = (StructureItem)context.peek();
                    spans.add(new int[]{(int)item.getPosition(), (int)item.getPosition() + item.getName().length()});
                }
                return true;
            });
        }
        return spans;
    }

    private static ConfigurationMetadataProperty getProperty(Map<String, ConfigurationMetadataGroup> groups, String propertyName, List<ConfigurationMetadataSource> sources) {
        for (Map.Entry<String, ConfigurationMetadataGroup> groupEntry : groups.entrySet()) {
            String groupKey = groupEntry.getKey();
            if (groupKey.endsWith(".*")) {
                groupKey = groupKey.substring(0, groupKey.length() - 2);
            }
            if (!Pattern.matches(groupKey.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\\\w*") + ".*", propertyName)) continue;
            ConfigurationMetadataGroup group = groupEntry.getValue();
            if (sources != null) {
                sources.addAll(group.getSources().values());
            }
            for (Map.Entry propertyEntry : group.getProperties().entrySet()) {
                String propertyKey = (String)propertyEntry.getKey();
                if (!Pattern.matches(propertyKey.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\\\w*"), propertyName)) continue;
                return (ConfigurationMetadataProperty)propertyEntry.getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scan(List<? extends StructureItem> structures, Stack<StructureItem> context, Function<Stack<StructureItem>, Boolean> visitor) {
        for (StructureItem structureItem : structures) {
            if (structureItem == null) continue;
            try {
                context.push(structureItem);
                if (!visitor.apply(context).booleanValue()) continue;
                MicronautConfigUtilities.scan(structureItem.getNestedItems(), context, visitor);
            }
            finally {
                context.pop();
            }
        }
    }

    private static void find(FileObject fo, String propertyName, List<? extends StructureItem> structures, CharSequence content, Consumer<Usage> consumer) {
        int idx = propertyName.indexOf(46);
        String name = idx < 0 ? propertyName : propertyName.substring(0, idx);
        for (StructureItem structureItem : structures) {
            if (!"*".equals(name) && !name.equals(structureItem.getName())) continue;
            if (idx < 0) {
                int start = (int)structureItem.getPosition();
                int end = (int)structureItem.getEndPosition();
                String text = content.subSequence(start, end).toString();
                consumer.accept(new Usage(fo, start, end, text));
                continue;
            }
            MicronautConfigUtilities.find(fo, propertyName.substring(idx + 1), structureItem.getNestedItems(), content, consumer);
        }
    }

    private static List<StructureItem> getContext(List<? extends StructureItem> structure, int offset) {
        ArrayList<StructureItem> context = new ArrayList<StructureItem>();
        block0: while (structure != null && !structure.isEmpty()) {
            for (StructureItem item : structure) {
                if (item.getPosition() > (long)offset || (long)offset > item.getEndPosition()) continue;
                context.add(item);
                structure = item.getNestedItems();
                continue block0;
            }
            structure = null;
        }
        return context;
    }

    private static String getPropertyName(List<? extends StructureItem> context) {
        StringBuilder sb = new StringBuilder();
        for (StructureItem structureItem : context) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(structureItem.getName());
        }
        return sb.toString();
    }

    public static final class Usage {
        private final FileObject fileObject;
        private final int startOffset;
        private final int endOffset;
        private final String text;

        public Usage(FileObject fileObject, int startOffset, int endOffset, String text) {
            this.fileObject = fileObject;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.text = text;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String getText() {
            return this.text;
        }
    }
}

