/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.diff.DiffStreamSource;
import org.netbeans.modules.mercurial.ui.diff.Setup;
import org.netbeans.modules.mercurial.ui.log.DiffTreeTable;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.RevisionNode;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

class DiffResultsView
implements AncestorListener,
PropertyChangeListener,
DiffSetupSource {
    protected final SearchHistoryPanel parent;
    protected DiffTreeTable treeView;
    private final JSplitPane diffView;
    protected HgProgressSupport currentTask;
    private RequestProcessor.Task currentShowDiffTask;
    protected DiffController currentDiff;
    private int currentDifferenceIndex;
    protected int currentIndex;
    private boolean dividerSet;
    protected List<RepositoryRevision> results;
    private static final RequestProcessor rp = new RequestProcessor("MercurialDiff", 1, true);
    private final PropertyChangeListener list;
    private Node[] selectedNodes;
    private final Set<RepositoryRevision> revisionsToRefresh = new HashSet<RepositoryRevision>(2);
    private int lastDividerLoc;
    private boolean onSelectionshowLastDifference;

    public DiffResultsView(SearchHistoryPanel parent, List<RepositoryRevision> results) {
        this.parent = parent;
        this.results = results;
        this.treeView = new DiffTreeTable(parent);
        this.treeView.setResults(results);
        this.treeView.addAncestorListener(this);
        this.diffView = new JSplitPane(0);
        this.diffView.setTopComponent((Component)((Object)this.treeView));
        this.setBottomComponent((Component)new NoContentPanel(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions")));
        this.list = WeakListeners.propertyChange((PropertyChangeListener)this, null);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        ExplorerManager em = ExplorerManager.find((Component)((Object)this.treeView));
        em.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.dividerSet) {
            if (this.lastDividerLoc != 0) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DiffResultsView.this.diffView.setDividerLocation(DiffResultsView.this.lastDividerLoc);
                    }
                });
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DiffResultsView.this.dividerSet = true;
                    DiffResultsView.this.diffView.setDividerLocation(0.33);
                }
            });
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        if (this.dividerSet) {
            this.lastDividerLoc = this.diffView.getDividerLocation();
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this.treeView));
        em.removePropertyChangeListener((PropertyChangeListener)this);
        this.cancelBackgroundTasks();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            assert (EventQueue.isDispatchThread());
            this.selectedNodes = (Node[])evt.getNewValue();
            this.currentDifferenceIndex = 0;
            if (this.selectedNodes.length == 0) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            if (this.selectedNodes.length > 2) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_TooManyRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            this.revisionsToRefresh.clear();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DiffResultsView.this.showDiff();
                }
            };
            EventQueue.invokeLater(runnable);
        } else if ("eventsChanged".equals(evt.getPropertyName()) && evt.getSource() instanceof RepositoryRevision) {
            RepositoryRevision revision = (RepositoryRevision)evt.getSource();
            revision.removePropertyChangeListener("eventsChanged", this.list);
            if (this.revisionsToRefresh.contains(revision) && this.selectedNodes != null && this.selectedNodes.length > 0) {
                this.showDiff();
            }
        }
    }

    private void showDiff() {
        RepositoryRevision container1 = (RepositoryRevision)this.selectedNodes[0].getLookup().lookup(RepositoryRevision.class);
        RepositoryRevision.Event r1 = (RepositoryRevision.Event)this.selectedNodes[0].getLookup().lookup(RepositoryRevision.Event.class);
        boolean error = false;
        boolean loading = false;
        try {
            this.currentIndex = this.treeView.getSelection()[0];
            if (this.selectedNodes.length == 1) {
                if (container1 != null) {
                    container1.removePropertyChangeListener("eventsChanged", this.list);
                    container1.addPropertyChangeListener("eventsChanged", this.list);
                    if (container1.expandEvents()) {
                        this.revisionsToRefresh.add(container1);
                        loading = true;
                    } else {
                        container1.removePropertyChangeListener("eventsChanged", this.list);
                    }
                    if (this.showContainerDiff(container1, this.onSelectionshowLastDifference)) {
                        loading = false;
                    }
                } else if (r1 != null) {
                    this.showRevisionDiff(r1, this.onSelectionshowLastDifference);
                }
            } else if (this.selectedNodes.length == 2) {
                RepositoryRevision.Event revOlder = null;
                if (container1 != null) {
                    RepositoryRevision container2 = (RepositoryRevision)this.selectedNodes[1].getLookup().lookup(RepositoryRevision.class);
                    if (container2 == null) {
                        error = true;
                    } else {
                        container1.removePropertyChangeListener("eventsChanged", this.list);
                        container1.addPropertyChangeListener("eventsChanged", this.list);
                        container2.removePropertyChangeListener("eventsChanged", this.list);
                        container2.addPropertyChangeListener("eventsChanged", this.list);
                        if (container1.expandEvents() || container2.expandEvents()) {
                            loading = true;
                            this.revisionsToRefresh.add(container1);
                            this.revisionsToRefresh.add(container2);
                        } else {
                            container1.removePropertyChangeListener("eventsChanged", this.list);
                            container2.removePropertyChangeListener("eventsChanged", this.list);
                        }
                        r1 = this.getEventForRoots(container1, null);
                        revOlder = this.getEventForRoots(container2, r1 == null ? null : r1.getFile());
                        if (r1 != null && revOlder != null) {
                            loading = false;
                        }
                    }
                } else {
                    revOlder = (RepositoryRevision.Event)this.selectedNodes[1].getLookup().lookup(RepositoryRevision.Event.class);
                }
                if (r1 == null || revOlder == null || revOlder.getFile() == null) {
                    error = true;
                } else {
                    this.showDiff(r1.getLogInfoHeader().getRepositoryRoot(), revOlder, r1, false);
                }
            }
        }
        catch (Exception e) {
            error = true;
        }
        if (loading) {
            this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_LoadingDiff"));
            this.parent.refreshComponents(false);
        } else if (error) {
            this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_IllegalSelection"));
            this.parent.refreshComponents(false);
        } else {
            this.revisionsToRefresh.clear();
        }
    }

    @Override
    public Collection<Setup> getSetups() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes.length == 0) {
            return this.parent.getSetups(this.results.toArray(new RepositoryRevision[this.results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (Node n : nodes) {
            RevisionNode node = (RevisionNode)n;
            if (node.getEvent() != null) {
                events.add(node.getEvent());
                continue;
            }
            revisions.add(node.getContainer());
        }
        return this.parent.getSetups(revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    protected void showDiffError(final String s) {
        Runnable inAWT = new Runnable(){

            @Override
            public void run() {
                DiffResultsView.this.setBottomComponent((Component)new NoContentPanel(s));
            }
        };
        if (EventQueue.isDispatchThread()) {
            inAWT.run();
        } else {
            EventQueue.invokeLater(inAWT);
        }
    }

    protected final void setBottomComponent(Component component) {
        assert (EventQueue.isDispatchThread());
        int dl = this.diffView.getDividerLocation();
        this.diffView.setBottomComponent(component);
        this.diffView.setDividerLocation(dl);
    }

    protected HgProgressSupport createShowDiffTask(RepositoryRevision.Event revision1, RepositoryRevision.Event revision2, boolean showLastDifference) {
        return new ShowDiffTask(revision1, revision2, showLastDifference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showDiff(File repositoryRoot, RepositoryRevision.Event revision1, RepositoryRevision.Event revision2, boolean showLastDifference) {
        DiffResultsView diffResultsView = this;
        synchronized (diffResultsView) {
            this.cancelBackgroundTasks();
            this.currentTask = this.createShowDiffTask(revision1, revision2, showLastDifference);
            this.currentShowDiffTask = this.currentTask.start(rp, repositoryRoot, NbBundle.getMessage(DiffResultsView.class, (String)"LBL_SearchHistory_Diffing"));
        }
    }

    private synchronized void cancelBackgroundTasks() {
        if (this.currentShowDiffTask != null && !this.currentShowDiffTask.isFinished()) {
            this.currentShowDiffTask.cancel();
            this.currentTask.cancel();
        }
    }

    protected void setDiffIndex(int idx, boolean showLastDifference) {
        this.currentIndex = idx;
        this.onSelectionshowLastDifference = showLastDifference;
        this.treeView.setSelection(idx);
    }

    protected void showRevisionDiff(RepositoryRevision.Event rev, boolean showLastDifference) {
        if (rev.getFile() == null) {
            return;
        }
        this.showDiff(rev.getLogInfoHeader().getRepositoryRoot(), null, rev, showLastDifference);
    }

    protected boolean showContainerDiff(RepositoryRevision container, boolean showLastDifference) {
        boolean initialized = container.isEventsInitialized();
        RepositoryRevision.Event[] revs = container.getEvents();
        RepositoryRevision.Event newest = this.getEventForRoots(container, null);
        if (newest == null) {
            newest = revs[0];
        }
        if (newest == null && !initialized) {
            return false;
        }
        this.showRevisionDiff(newest, showLastDifference);
        return true;
    }

    private RepositoryRevision.Event getEventForRoots(RepositoryRevision container, File preferedFile) {
        RepositoryRevision.Event event = null;
        RepositoryRevision.Event[] revs = container.isEventsInitialized() ? container.getEvents() : container.getDummyEvents();
        File[] roots = this.parent.getRoots();
        block0: for (RepositoryRevision.Event evt : revs) {
            if (preferedFile == null) {
                for (File root : roots) {
                    if (root.equals(evt.getFile())) {
                        event = evt;
                        break block0;
                    }
                    if (!this.similarPaths(root, evt.getFile())) continue;
                    event = evt;
                }
                continue;
            }
            if (preferedFile.equals(evt.getFile())) {
                event = evt;
                break;
            }
            if (!this.similarPaths(preferedFile, evt.getFile())) continue;
            event = evt;
        }
        return event;
    }

    void onNextButton() {
        if (this.currentDiff != null) {
            if (++this.currentDifferenceIndex >= this.currentDiff.getDifferenceCount()) {
                if (++this.currentIndex >= this.treeView.getRowCount()) {
                    this.currentIndex = 0;
                }
                this.setDiffIndex(this.currentIndex, false);
            } else {
                this.currentDiff.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, this.currentDifferenceIndex);
                this.parent.updateActions();
            }
        } else {
            if (++this.currentIndex >= this.treeView.getRowCount()) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, false);
        }
    }

    void onPrevButton() {
        if (this.currentDiff != null) {
            if (--this.currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    this.currentIndex = this.treeView.getRowCount() - 1;
                }
                this.setDiffIndex(this.currentIndex, true);
            } else if (this.currentDifferenceIndex < this.currentDiff.getDifferenceCount()) {
                this.currentDiff.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, this.currentDifferenceIndex);
                this.parent.updateActions();
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.treeView.getRowCount() - 1;
            }
            this.setDiffIndex(this.currentIndex, true);
        }
    }

    boolean isNextEnabled() {
        if (this.currentDiff != null) {
            return this.currentIndex < this.treeView.getRowCount() - 1 || this.currentDifferenceIndex < this.currentDiff.getDifferenceCount() - 1;
        }
        return false;
    }

    boolean isPrevEnabled() {
        return this.currentIndex > 0 || this.currentDifferenceIndex > 0;
    }

    void select(RepositoryRevision.Event ... events) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(events);
    }

    void select(RepositoryRevision container) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(container);
    }

    void refreshResults(List<RepositoryRevision> res) {
        this.results = res;
        this.treeView.refreshResults(res);
    }

    private boolean similarPaths(File referenceFile, File file) {
        return referenceFile.getName().equals(file.getName()) || referenceFile.getAbsolutePath().equalsIgnoreCase(null);
    }

    public JComponent getComponent() {
        return this.diffView;
    }

    private class ShowDiffTask
    extends HgProgressSupport {
        private File file1;
        private File baseFile1;
        private HgLogMessage.HgRevision revision1;
        private boolean showLastDifference;
        private final RepositoryRevision.Event event2;

        public ShowDiffTask(RepositoryRevision.Event event1, RepositoryRevision.Event event2, boolean showLastDifference) {
            this.event2 = event2;
            if (event1 != null) {
                this.revision1 = event1.getLogInfoHeader().getLog().getHgRevision();
                this.file1 = event1.getOriginalFile();
                this.baseFile1 = event1.getFile();
            }
            this.showLastDifference = showLastDifference;
        }

        @Override
        public void perform() {
            DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_LoadingDiff"));
            if (this.revision1 == null) {
                this.revision1 = this.event2.getLogInfoHeader().getLog().getAncestor(this.event2.getOriginalFile());
                this.file1 = this.event2.getOriginalFile();
                this.baseFile1 = this.event2.getFile();
            }
            if (this.isCanceled()) {
                return;
            }
            final DiffStreamSource s1 = new DiffStreamSource(this.file1, this.baseFile1, this.revision1, this.file1.getName() + " (" + this.revision1.getRevisionNumber() + ")");
            final DiffStreamSource s2 = new DiffStreamSource(this.event2.getFile(), this.event2.getFile(), this.event2.getLogInfoHeader().getLog().getHgRevision(), this.event2.getFile().getName() + " (" + this.event2.getLogInfoHeader().getLog().getHgRevision().getRevisionNumber() + ")");
            s1.getMIMEType();
            if (this.isCanceled()) {
                DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                return;
            }
            s2.getMIMEType();
            if (this.isCanceled()) {
                DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                return;
            }
            if (DiffResultsView.this.currentTask != this) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ShowDiffTask.this.isCanceled()) {
                            DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                            return;
                        }
                        final DiffController view = DiffController.createEnhanced((StreamSource)s1, (StreamSource)s2);
                        if (DiffResultsView.this.currentTask == ShowDiffTask.this) {
                            DiffResultsView.this.currentDiff = view;
                            DiffResultsView.this.setBottomComponent(DiffResultsView.this.currentDiff.getJComponent());
                            final int dl = DiffResultsView.this.diffView.getDividerLocation();
                            if (!ShowDiffTask.this.setLocation(view)) {
                                view.addPropertyChangeListener(new PropertyChangeListener(){

                                    @Override
                                    public void propertyChange(PropertyChangeEvent evt) {
                                        view.removePropertyChangeListener((PropertyChangeListener)this);
                                        ShowDiffTask.this.setLocation(view);
                                        DiffResultsView.this.parent.updateActions();
                                    }
                                });
                            }
                            DiffResultsView.this.parent.refreshComponents(false);
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DiffResultsView.this.diffView.setDividerLocation(dl);
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
            });
        }

        private boolean setLocation(DiffController view) {
            boolean locationSet = false;
            if (view == DiffResultsView.this.currentDiff && view.getDifferenceCount() > 0) {
                locationSet = true;
                DiffResultsView.this.currentDifferenceIndex = this.showLastDifference ? view.getDifferenceCount() - 1 : 0;
                view.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.DifferenceIndex, DiffResultsView.this.currentDifferenceIndex);
            }
            return locationSet;
        }
    }
}

