/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class JavadocOutputProcessor
implements OutputProcessor {
    private static final String[] JAVADOCGOALS = new String[]{"mojo-execute#javadoc:javadoc"};
    private Pattern index = Pattern.compile("Generating (.*)index\\.html.*", 32);
    private String path;

    @Override
    public String[] getRegisteredOutputSequences() {
        return JAVADOCGOALS;
    }

    @Override
    public void processLine(String line, OutputVisitor visitor) {
        Matcher match = this.index.matcher(line);
        if (match.matches()) {
            this.path = match.group(1);
        }
    }

    @Override
    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
        this.path = null;
    }

    @Override
    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
        if (this.path != null) {
            visitor.setLine("View Generated javadoc at " + this.path);
            visitor.setOutputListener(new Listener(this.path), false);
        }
    }

    @Override
    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
    }

    private static class Listener
    implements OutputListener {
        private final String root;

        private Listener(String path) {
            this.root = path;
        }

        public void outputLineAction(OutputEvent arg0) {
            FileObject index;
            File javadoc = FileUtil.normalizeFile((File)new File(this.root));
            FileUtil.refreshFor((File[])new File[]{javadoc});
            FileObject fo = FileUtil.toFileObject((File)javadoc);
            if (fo != null && (index = fo.getFileObject("index.html")) != null) {
                URL link = URLMapper.findURL((FileObject)index, (int)1);
                HtmlBrowser.URLDisplayer.getDefault().showURL(link);
            }
        }
    }
}

