/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class ReactorChecker
implements PrerequisitesChecker {
    @Override
    public boolean checkRunConfig(RunConfig config) {
        RunConfig preExecution = config.getPreExecution();
        if (preExecution != null && !this.checkRunConfig(preExecution)) {
            return false;
        }
        if (preExecution == null && config.getReactorStyle() == RunConfig.ReactorStyle.NONE) {
            return true;
        }
        File dir = config.getExecutionDirectory();
        FileObject fo = FileUtil.toFileObject((File)dir);
        Project p = config.getProject();
        if (p == null || fo != p.getProjectDirectory()) {
            return true;
        }
        NbMavenProject mavenprj = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class);
        if (mavenprj == null) {
            return true;
        }
        if (NbMavenProject.isErrorPlaceholder(mavenprj.getMavenProject())) {
            return true;
        }
        NbMavenProject reactor = ReactorChecker.findReactor(mavenprj);
        File reactorRoot = reactor.getMavenProject().getBasedir();
        if (config.getReactorStyle() == RunConfig.ReactorStyle.NONE) {
            if (preExecution != null && "build-with-dependencies".equals(preExecution.getActionName()) && reactor == mavenprj) {
                config.setPreExecution(null);
            }
            return true;
        }
        if (reactor != mavenprj) {
            try {
                List<String> reactorProfiles;
                M2Configuration cfg = ((M2ConfigProvider)ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)reactorRoot)).getLookup().lookup(M2ConfigProvider.class)).getActiveConfiguration();
                if (cfg != null && !(reactorProfiles = cfg.getActivatedProfiles()).isEmpty()) {
                    ArrayList<String> profiles = new ArrayList<String>(config.getActivatedProfiles());
                    profiles.addAll(reactorProfiles);
                    config.setActivatedProfiles(profiles);
                }
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        config.setExecutionDirectory(reactorRoot);
        return true;
    }

    @NonNull
    public static NbMavenProject findReactor(@NonNull NbMavenProject module) {
        NbMavenProject p;
        MavenProject prj = module.getMavenProject();
        List models = MavenEmbedder.getModelDescriptors((MavenProject)prj);
        File moduleDir = prj.getBasedir();
        File current = moduleDir;
        if (current != null && models != null) {
            NbMavenProject loaded;
            boolean first = true;
            for (MavenEmbedder.ModelDescription model : models) {
                File modelDir;
                if (first) {
                    first = false;
                    continue;
                }
                File loc = model.getLocation();
                if (loc == null || loc.getName().endsWith(".pom") || !ReactorChecker.listsModule(modelDir = loc.getParentFile(), current, model.getModules())) break;
                current = modelDir;
            }
            if (!moduleDir.equals(current) && (loaded = ReactorChecker.load(current)) != null) {
                return ReactorChecker.findReactor(loaded);
            }
        }
        if ((p = ReactorChecker.load(prj.getBasedir().getParentFile())) != null && ReactorChecker.listsModule(moduleDir.getParentFile(), moduleDir, p.getMavenProject().getModules())) {
            return ReactorChecker.findReactor(p);
        }
        return module;
    }

    private static boolean listsModule(File parentDir, File moduleDir, List<String> modules) {
        for (String module : modules) {
            if (!moduleDir.equals(FileUtilities.resolveFilePath(parentDir, module))) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    private static NbMavenProject load(File parentDir) {
        if (parentDir == null) {
            return null;
        }
        FileObject d = FileUtil.toFileObject((File)parentDir);
        if (d != null) {
            try {
                Project p = ProjectManager.getDefault().findProject(d);
                if (p != null) {
                    return (NbMavenProject)p.getLookup().lookup(NbMavenProject.class);
                }
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        return null;
    }
}

