/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.customizer.support.TextComponentUpdater;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMModel;

public final class ReflectionTextComponentUpdater
extends TextComponentUpdater {
    private final Object model;
    private final Object defaults;
    private final Method modelgetter;
    private Method defgetter;
    private Method modelsetter;
    private ModelHandle handle;
    private ModelHandle2 handle2;
    private String initialValue2;
    private Operation operation;

    public ReflectionTextComponentUpdater(String getter, String setter, Object model, Object defaults, JTextComponent field, JLabel label, ModelHandle handle) throws NoSuchMethodException {
        this(getter, setter, model, defaults, field, label);
        this.handle = handle;
    }

    public ReflectionTextComponentUpdater(String getter, Object model, Object defaults, JTextComponent field, JLabel label, ModelHandle2 handle, Operation operation) throws NoSuchMethodException {
        this(getter, null, model, defaults, field, label);
        assert (handle != null);
        assert (operation != null);
        this.operation = operation;
        this.handle2 = handle;
        this.initialValue2 = this.getValue();
    }

    private ReflectionTextComponentUpdater(String getter, String setter, Object model, Object defaults, JTextComponent field, JLabel label) throws NoSuchMethodException {
        super(field, label);
        this.model = model;
        this.defaults = defaults;
        this.modelgetter = model.getClass().getMethod(getter, new Class[0]);
        if (setter != null) {
            this.modelsetter = model.getClass().getMethod(setter, String.class);
        }
        if (defaults != null) {
            this.defgetter = defaults.getClass().getMethod(getter, new Class[0]);
        }
    }

    @Override
    public String getValue() {
        if (this.operation.isValueSet) {
            return this.operation.getNewValue();
        }
        try {
            return (String)this.modelgetter.invoke(this.model, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public String getDefaultValue() {
        if (this.defgetter == null) {
            return null;
        }
        try {
            return (String)this.defgetter.invoke(this.defaults, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public void setValue(String value) {
        try {
            if (this.handle != null) {
                this.modelsetter.invoke(this.model, value);
                if (this.model instanceof POMComponent) {
                    this.handle.markAsModified(((POMComponent)this.model).getModel());
                } else {
                    this.handle.markAsModified(this.model);
                }
            }
            if (this.handle2 != null) {
                this.operation.setNewValue(value);
                if (value != null && value.equals(this.initialValue2)) {
                    this.handle2.removePOMModification(this.operation);
                } else {
                    this.handle2.addPOMModification(this.operation);
                }
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    public static abstract class Operation
    implements ModelOperation<POMModel> {
        boolean isValueSet = false;
        private String newValue;

        public final void setNewValue(String value) {
            this.newValue = value;
            this.isValueSet = true;
        }

        public final String getNewValue() {
            return this.newValue;
        }
    }
}

