/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.spi.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.execute.ModelRunConfig;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionReader;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Writer;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public abstract class AbstractMavenActionsProvider
implements MavenActionsProvider {
    private static final Logger LOG = Logger.getLogger(AbstractMavenActionsProvider.class.getName());
    protected ActionToGoalMapping originalMappings;
    protected NetbeansBuildActionXpp3Reader reader = new NetbeansBuildActionXpp3Reader();
    private final NetbeansBuildActionXpp3Writer writer = new NetbeansBuildActionXpp3Writer();

    protected static FileObject[] extractFileObjectsfromLookup(Lookup lookup) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (DataObject d : lookup.lookupAll(DataObject.class)) {
            FileObject f = d.getPrimaryFile();
            files.add(f);
        }
        Collection methods = lookup.lookupAll(SingleMethod.class);
        if (methods.size() == 1) {
            SingleMethod method = (SingleMethod)methods.iterator().next();
            files.add(method.getFile());
        }
        return files.toArray(new FileObject[files.size()]);
    }

    @Override
    public boolean isActionEnable(String action, Project project, Lookup lookup) {
        NbMavenProject mp = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        String prjPack = mp.getPackagingType();
        return this.isActionEnable(action, prjPack);
    }

    public final boolean isActionEnable(String action, String prjPack) {
        ActionToGoalMapping rawMappings = this.getRawMappings();
        for (NetbeansActionMapping elem : rawMappings.getActions()) {
            if (!action.equals(elem.getActionName()) || !elem.getPackagings().isEmpty() && !elem.getPackagings().contains(prjPack.trim()) && !elem.getPackagings().contains("*")) continue;
            return true;
        }
        return false;
    }

    @Override
    public final RunConfig createConfigForDefaultAction(String actionName, Project project, Lookup lookup) {
        FileObject[] fos = AbstractMavenActionsProvider.extractFileObjectsfromLookup(lookup);
        HashMap<String, String> replaceMap = (HashMap<String, String>)lookup.lookup(Map.class);
        if (replaceMap == null) {
            replaceMap = new HashMap<String, String>();
            Logger.getLogger(AbstractMavenActionsProvider.class.getName()).log(Level.FINE, "Missing replace tokens map when executing maven build. Could lead to problems with execution. See issue #159698 for details.", new Exception());
        }
        FileObject fo = null;
        if (fos.length > 0) {
            fo = fos[0];
        }
        return this.mapGoalsToAction(project, actionName, replaceMap, fo, lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionToGoalMapping getRawMappings() {
        if (this.originalMappings == null || this.reloadStream()) {
            InputStream in = this.getActionDefinitionStream();
            if (in == null) {
                this.originalMappings = new ActionToGoalMapping();
            } else {
                InputStreamReader rdr = null;
                try {
                    rdr = new InputStreamReader(in);
                    this.originalMappings = this.reader.read(rdr);
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "Loading raw mappings", ex);
                    this.originalMappings = new ActionToGoalMapping();
                }
                catch (XmlPullParserException ex) {
                    LOG.log(Level.INFO, "Loading raw mappings", ex);
                    this.originalMappings = new ActionToGoalMapping();
                }
                finally {
                    if (rdr != null) {
                        try {
                            ((Reader)rdr).close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
        }
        return this.originalMappings;
    }

    public String getRawMappingsAsString() {
        StringWriter str = new StringWriter();
        try {
            this.writer.write(str, this.getRawMappings());
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Loading raw mappings", ex);
        }
        return str.toString();
    }

    @Override
    public Set<String> getSupportedDefaultActions() {
        HashSet<String> toRet = new HashSet<String>();
        ActionToGoalMapping raw = this.getRawMappings();
        for (NetbeansActionMapping nb : raw.getActions()) {
            String name = nb.getActionName();
            if (name == null || name.startsWith("CUSTOM-")) continue;
            toRet.add(name);
        }
        return toRet;
    }

    protected boolean reloadStream() {
        return false;
    }

    @Override
    public NetbeansActionMapping getMappingForAction(String actionName, Project project) {
        return new NetbeansActionReader(){

            @Override
            protected String getRawMappingsAsString() {
                return AbstractMavenActionsProvider.this.getRawMappingsAsString();
            }

            @Override
            protected Reader performDynamicSubstitutions(Map<String, String> replaceMap, String in) throws IOException {
                return AbstractMavenActionsProvider.this.performDynamicSubstitutions(replaceMap, in);
            }
        }.getMappingForAction(this.reader, LOG, actionName, null, project, null, Collections.emptyMap());
    }

    protected abstract InputStream getActionDefinitionStream();

    private RunConfig mapGoalsToAction(Project project, String actionName, Map<String, String> replaceMap, FileObject selectedFile, Lookup lookup) {
        try {
            boolean[] fallback = new boolean[]{false};
            NetbeansActionMapping action = this instanceof M2Configuration ? ((M2Configuration)this).findMappingFor(replaceMap, project, actionName, fallback) : this.findMapAction(replaceMap, project, actionName);
            if (action != null) {
                ModelRunConfig mrc = new ModelRunConfig(project, action, actionName, selectedFile, lookup, fallback[0]);
                if (replaceMap.containsKey("nb.single.run.methodName")) {
                    mrc.setProperty("nb.single.run.methodName", replaceMap.get("nb.single.run.methodName"));
                }
                return mrc;
            }
        }
        catch (XmlPullParserException ex) {
            LOG.log(Level.INFO, "Parsing action mapping", ex);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Parsing action mapping", ex);
        }
        return null;
    }

    private NetbeansActionMapping findMapAction(Map<String, String> replaceMap, Project project, String actionName) throws XmlPullParserException, IOException {
        Reader read = this.performDynamicSubstitutions(replaceMap, this.getRawMappingsAsString());
        ActionToGoalMapping mapping = this.reader.read(read);
        Iterator<NetbeansActionMapping> it = mapping.getActions().iterator();
        NetbeansActionMapping action = null;
        NbMavenProject mp = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        String prjPack = mp.getPackagingType();
        while (it.hasNext()) {
            NetbeansActionMapping elem = it.next();
            if (!actionName.equals(elem.getActionName()) || !elem.getPackagings().contains(prjPack.trim()) && !elem.getPackagings().contains("*") && !elem.getPackagings().isEmpty()) continue;
            action = elem;
            break;
        }
        return action;
    }

    protected Reader performDynamicSubstitutions(Map<String, String> replaceMap, String in) throws IOException {
        return new StringReader(AbstractMavenActionsProvider.dynamicSubstitutions(replaceMap, in));
    }

    public static String dynamicSubstitutions(Map<String, String> replaceMap, String in) {
        StringBuilder buf = new StringBuilder(in);
        for (Map.Entry<String, String> elem : replaceMap.entrySet()) {
            String replaceItem = "${" + elem.getKey() + "}";
            int index = buf.indexOf(replaceItem);
            while (index > -1) {
                String newItem = elem.getValue();
                if (newItem == null) {
                    // empty if block
                }
                newItem = newItem == null ? "" : newItem;
                buf.replace(index, index + replaceItem.length(), newItem);
                index = buf.indexOf(replaceItem);
            }
        }
        return buf.toString();
    }
}

