/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ui.wizard.archetype;

import java.util.Map;
import java.util.TreeMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.openide.util.NbBundle;

abstract class BaseJ2eeArchetypeProvider {
    protected Map<Profile, Archetype> map = new TreeMap<Profile, Archetype>(Profile.UI_COMPARATOR);

    protected BaseJ2eeArchetypeProvider() {
        this.setUpProjectArchetypes();
    }

    protected abstract void setUpProjectArchetypes();

    protected void addMojoArchetype(Profile j2eeProfile, String version, String artifactId) {
        this.map.put(j2eeProfile, this.createMojoArchetype(version, artifactId));
    }

    protected void addJavaEE8Archetype(Profile j2eeProfile, String groupId, String version, String artifactId) {
        this.map.put(j2eeProfile, this.createArchetype(NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)groupId), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)version), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)artifactId)));
    }

    protected void addJakartaEEArchetype(Profile j2eeProfile, String groupId, String version, String artifactId) {
        this.map.put(j2eeProfile, this.createArchetype(NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)groupId), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)version), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)artifactId)));
    }

    protected void addSameMojoArchetypeForAllProfiles(String version, String artifactId) {
        Archetype archetype = this.createMojoArchetype(version, artifactId);
        this.map.put(Profile.J2EE_14, archetype);
        this.map.put(Profile.JAVA_EE_5, archetype);
        this.map.put(Profile.JAVA_EE_6_FULL, archetype);
        this.map.put(Profile.JAVA_EE_6_WEB, archetype);
        this.map.put(Profile.JAVA_EE_7_FULL, archetype);
        this.map.put(Profile.JAVA_EE_7_WEB, archetype);
        Archetype javaEE8Archetype = this.createArchetype(NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeGroupId.JavaEE8"), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeVersion.JavaEE8"), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeArtifactId.JavaEE8"));
        Archetype jakartaEE8Archetype = this.createArchetype(NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeGroupId.JakartaEE8"), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeVersion.JakartaEE8"), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeArtifactId.JakartaEE8"));
        Archetype jakartaEE9Archetype = this.createArchetype(NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeGroupId.JakartaEE9"), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeVersion.JakartaEE9"), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeArtifactId.JakartaEE9"));
        Archetype jakartaEE9_1Archetype = this.createArchetype(NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeGroupId.JakartaEE9_1"), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeVersion.JakartaEE9_1"), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeArtifactId.JakartaEE9_1"));
        Archetype jakartaEE10_0Archetype = this.createArchetype(NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeGroupId.JakartaEE10_0"), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeVersion.JakartaEE10_0"), NbBundle.getMessage(BaseJ2eeArchetypeProvider.class, (String)"mvn.archetypeArtifactId.JakartaEE10_0"));
        this.map.put(Profile.JAVA_EE_8_FULL, javaEE8Archetype);
        this.map.put(Profile.JAVA_EE_8_WEB, javaEE8Archetype);
        this.map.put(Profile.JAKARTA_EE_8_FULL, jakartaEE8Archetype);
        this.map.put(Profile.JAKARTA_EE_8_WEB, jakartaEE8Archetype);
        this.map.put(Profile.JAKARTA_EE_9_FULL, jakartaEE9Archetype);
        this.map.put(Profile.JAKARTA_EE_9_WEB, jakartaEE9Archetype);
        this.map.put(Profile.JAKARTA_EE_9_1_FULL, jakartaEE9_1Archetype);
        this.map.put(Profile.JAKARTA_EE_9_1_WEB, jakartaEE9_1Archetype);
        this.map.put(Profile.JAKARTA_EE_10_FULL, jakartaEE10_0Archetype);
        this.map.put(Profile.JAKARTA_EE_10_WEB, jakartaEE10_0Archetype);
    }

    private Archetype createMojoArchetype(String version, String artifactId) {
        Archetype archetype = new Archetype();
        archetype.setGroupId("org.codehaus.mojo.archetypes");
        archetype.setVersion(version);
        archetype.setArtifactId(artifactId);
        return archetype;
    }

    private Archetype createArchetype(String groupId, String version, String artifactId) {
        Archetype archetype = new Archetype();
        archetype.setGroupId(groupId);
        archetype.setVersion(version);
        archetype.setArtifactId(artifactId);
        return archetype;
    }

    @NonNull
    public Archetype getArchetypeFor(Profile profile) {
        Archetype archetype = this.map.get(profile);
        if (archetype != null) {
            return archetype;
        }
        throw new IllegalStateException("No archetype defined for profile " + profile + " in " + this.getClass() + "; check whether all possible <Profile, Archetype> pairs have been added");
    }

    public Map<Profile, Archetype> getArchetypeMap() {
        return this.map;
    }

    @CheckForNull
    public Archetype getAnyArchetype() {
        if (this.map.isEmpty()) {
            return null;
        }
        return this.map.values().iterator().next();
    }
}

