/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.Collection;
import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.maven.hints.pom.MavenResult;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;

public class MavenPOMParser
extends Parser
implements PreferenceChangeListener {
    private final ChangeSupport chs = new ChangeSupport((Object)this);
    private POMModel theModel;
    private Snapshot lastSnapshot;

    public MavenPOMParser() {
        Preferences prefs = NbPreferences.root().node("org/netbeans/modules/maven");
        prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)prefs));
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if ("commandLineMavenPath".equals(evt.getKey())) {
            this.chs.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        FileObject sFile = snapshot.getSource().getFileObject();
        if (sFile == null) {
            MavenPOMParser mavenPOMParser = this;
            synchronized (mavenPOMParser) {
                this.theModel = null;
                this.lastSnapshot = snapshot;
            }
            return;
        }
        BaseDocument document = (BaseDocument)snapshot.getSource().getDocument(false);
        DataObject d = (DataObject)sFile.getLookup().lookup(DataObject.class);
        ModelSource ms = Utilities.createModelSource((FileObject)sFile, (DataObject)d, (BaseDocument)document);
        MavenPOMParser mavenPOMParser = this;
        synchronized (mavenPOMParser) {
            this.theModel = POMModelFactory.getDefault().getModel(ms);
            this.lastSnapshot = snapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parser.Result getResult(Task task) throws ParseException {
        MavenPOMParser mavenPOMParser = this;
        synchronized (mavenPOMParser) {
            if (this.lastSnapshot == null) {
                return null;
            }
            return new MavenResult(this.theModel, this.lastSnapshot.getSource().getFileObject(), this.lastSnapshot);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.chs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.chs.removeChangeListener(changeListener);
    }

    public static class F
    extends ParserFactory {
        public Parser createParser(Collection<Snapshot> snapshots) {
            return new MavenPOMParser();
        }
    }
}

