/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.grammar;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.util.IteratorIterable;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.api.Constants;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.grammar.MavenSettingsGrammar;
import org.netbeans.modules.maven.grammar.spi.AbstractSchemaBasedGrammar;
import org.netbeans.modules.maven.grammar.spi.GrammarExtensionProvider;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.PluginIndexManager;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenProjectGrammar
extends AbstractSchemaBasedGrammar {
    private static final Logger LOG = Logger.getLogger(MavenProjectGrammar.class.getName());
    private static final String[] SCOPES = new String[]{"compile", "test", "runtime", "provided", "system"};
    private final Project owner;

    MavenProjectGrammar(GrammarEnvironment env, Project owner) {
        super(env);
        this.owner = owner;
    }

    @Override
    protected InputStream getSchemaStream() {
        return this.getClass().getResourceAsStream("/org/netbeans/modules/maven/grammar/maven-4.0.0.xsd");
    }

    private List<GrammarResult> hardwiredProperty(HintContext hintCtx, String name, String htmlDesc) {
        if (name.startsWith(hintCtx.getCurrentPrefix())) {
            AbstractSchemaBasedGrammar.MyElement el = new AbstractSchemaBasedGrammar.MyElement(name);
            el.setDescription(htmlDesc);
            return Collections.singletonList(el);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<GrammarResult> getDynamicCompletion(String path, HintContext hintCtx, org.jdom2.Element parent) {
        GrammarExtensionProvider extProvider;
        ArrayList<GrammarResult> result = new ArrayList<GrammarResult>();
        if (path.endsWith("plugins/plugin/configuration") || path.endsWith("plugins/plugin/executions/execution/configuration")) {
            Document pluginDoc;
            MavenEmbedder embedder;
            Node previous = path.indexOf("execution") > 0 ? hintCtx.getParentNode().getParentNode().getParentNode().getPreviousSibling() : hintCtx.getParentNode().getPreviousSibling();
            ArtifactInfoHolder info = this.findPluginInfo(previous, embedder = EmbedderFactory.getOnlineEmbedder(), true);
            List<GrammarResult> res = this.collectPluginParams(info, hintCtx);
            if (res == null && (pluginDoc = this.loadDocument(info, embedder)) != null) {
                res = this.collectPluginParams(pluginDoc, hintCtx);
            }
            if (res != null) {
                result.addAll(res);
            }
        }
        if (path.endsWith("project/properties") || path.endsWith("profile/properties")) {
            result.addAll(this.hardwiredProperty(hintCtx, "netbeans.hint.displayName", "<html><h4>netbeans.hint.displayName</h4><p>A NetBeans specific property, only applicable within the IDE.</p><br/>Used by NetBeans to customize the display of the project in question.</html>"));
            result.addAll(this.hardwiredProperty(hintCtx, "netbeans.hint.license", "<html><h4>netbeans.hint.license</h4><p>A NetBeans specific property, only applicable within the IDE.</p><br/>Used by NetBeans to select a license header template from the IDE's default set.</html>"));
            result.addAll(this.hardwiredProperty(hintCtx, "netbeans.hint.licensePath", "<html><h4>netbeans.hint.licensePath</h4><p>A NetBeans specific property, only applicable within the IDE.</p><br/>Used by NetBeans to find license header template from project's space in the filesystem. <br/>Value is an absolute or relative path to the template file.</html>"));
            result.addAll(this.hardwiredProperty(hintCtx, "netbeans.hint.jdkPlatform", "<html><h4>netbeans.hint.jdkPlatform</h4><p>A NetBeans specific property, only applicable within the IDE.</p><br/>Used by NetBeans to determine which JDK platform defined in Tools/Java Platforms should be used to run the Maven builds.</html>"));
            result.addAll(this.hardwiredProperty(hintCtx, "netbeans.compile.on.save", "<html><h4>netbeans.compile.on.save</h4><p>A NetBeans specific property, only applicable within the IDE.</p><br/>Used by NetBeans to determine if Compile on Save feature should be enabled for the project or not.<br/>Allowed values are: true/false</html>"));
            result.addAll(this.hardwiredProperty(hintCtx, "netbeans.checkstyle.format", "<html><h4>netbeans.checkstyle.format</h4><p>A NetBeans specific property, only applicable within the IDE.</p><br/>Allowed values are: true/false</html>"));
        }
        if ((extProvider = (GrammarExtensionProvider)Lookup.getDefault().lookup(GrammarExtensionProvider.class)) != null) {
            result.addAll(extProvider.getDynamicCompletion(path, hintCtx, parent));
        }
        return result;
    }

    private ArtifactInfoHolder findArtifactInfo(Node previous) {
        ArtifactInfoHolder holder = new ArtifactInfoHolder();
        while (previous != null) {
            Element el;
            NodeList lst;
            if (previous instanceof Element && (lst = (el = (Element)previous).getChildNodes()).getLength() > 0) {
                if ("artifactId".equals(el.getNodeName())) {
                    holder.setArtifactId(MavenProjectGrammar.getNodeValue(lst.item(0).getNodeValue(), (NbMavenProject)this.owner.getLookup().lookup(NbMavenProject.class)));
                }
                if ("groupId".equals(el.getNodeName())) {
                    holder.setGroupId(MavenProjectGrammar.getNodeValue(lst.item(0).getNodeValue(), (NbMavenProject)this.owner.getLookup().lookup(NbMavenProject.class)));
                }
                if ("version".equals(el.getNodeName())) {
                    holder.setVersion(MavenProjectGrammar.getNodeValue(lst.item(0).getNodeValue(), (NbMavenProject)this.owner.getLookup().lookup(NbMavenProject.class)));
                }
            }
            previous = previous.getPreviousSibling();
        }
        return holder;
    }

    static String getNodeValue(String value, NbMavenProject prj) {
        StringBuilder sb = new StringBuilder();
        Properties props = prj.getMavenProject().getProperties();
        int idxLeft = value.indexOf("${");
        if (idxLeft < 0) {
            return value;
        }
        if (idxLeft > 0) {
            sb.append(value.substring(0, idxLeft));
        }
        int idxRight = 0;
        while (idxLeft > -1) {
            String prop;
            idxRight = value.indexOf("}", idxLeft + 2);
            if (idxRight > -1) {
                String propName = value.substring(idxLeft + 2, idxRight);
                prop = props.getProperty(propName);
                if (prop == null) {
                    return value;
                }
            } else {
                return value;
            }
            sb.append(prop);
            idxLeft = value.indexOf("${", idxRight);
            if (idxRight < value.length()) {
                if (idxLeft > idxRight) {
                    sb.append(value.substring(idxRight + 1, idxLeft));
                } else {
                    sb.append(value.substring(idxRight + 1));
                }
            }
            ++idxRight;
        }
        return sb.toString();
    }

    private ArtifactInfoHolder findPluginInfo(Node previous, MavenEmbedder embedder, boolean checkLocalRepo) {
        File lev1;
        File dir;
        File fil;
        NbMavenProject prj;
        ArtifactInfoHolder holder = this.findArtifactInfo(previous);
        if (holder.getGroupId() == null) {
            holder.setGroupId("org.apache.maven.plugins");
        }
        if (holder.getVersion() != null && holder.getVersion().contains("${")) {
            holder.setVersion(null);
        }
        if (holder.getVersion() == null && holder.getGroupId() != null && holder.getArtifactId() != null && (prj = (NbMavenProject)this.owner.getLookup().lookup(NbMavenProject.class)) != null) {
            PluginManagement man;
            for (Object a : prj.getMavenProject().getBuildPlugins()) {
                if (!holder.getGroupId().equals(a.getGroupId()) || !holder.getArtifactId().equals(a.getArtifactId())) continue;
                holder.setVersion(a.getVersion());
                break;
            }
            if (holder.getVersion() == null && (man = prj.getMavenProject().getPluginManagement()) != null) {
                for (Plugin p : man.getPlugins()) {
                    if (!holder.getGroupId().equals(p.getGroupId()) || !holder.getArtifactId().equals(p.getArtifactId())) continue;
                    holder.setVersion(p.getVersion());
                    break;
                }
            }
        }
        if (checkLocalRepo && (holder.getVersion() == null || "LATEST".equals(holder.getVersion()) || "RELEASE".equals(holder.getVersion())) && holder.getArtifactId() != null && holder.getGroupId() != null && (fil = new File(dir = new File(lev1 = new File(embedder.getLocalRepositoryFile(), holder.getGroupId().replace('.', File.separatorChar)), holder.getArtifactId()), "maven-metadata-local.xml")).exists()) {
            MetadataXpp3Reader reader = new MetadataXpp3Reader();
            try {
                Metadata data = reader.read((Reader)new InputStreamReader(new FileInputStream(fil)));
                if (data.getVersion() != null) {
                    holder.setVersion(data.getVersion());
                } else {
                    Versioning vers = data.getVersioning();
                    if (vers != null) {
                        if ("LATEST".equals(holder.getVersion())) {
                            holder.setVersion(vers.getLatest());
                        }
                        if ("RELEASE".equals(holder.getVersion())) {
                            holder.setVersion(vers.getRelease());
                        }
                    }
                }
            }
            catch (FileNotFoundException ex) {
                LOG.log(Level.FINER, "", ex);
            }
            catch (XmlPullParserException ex) {
                LOG.log(Level.FINER, "", ex);
            }
            catch (IOException ex) {
                LOG.log(Level.FINER, "", ex);
            }
        }
        if (holder.getVersion() == null) {
            holder.setVersion("RELEASE");
        }
        return holder;
    }

    private List<GrammarResult> collectPluginParams(Document pluginDoc, HintContext hintCtx) {
        IteratorIterable it = pluginDoc.getRootElement().getDescendants();
        ArrayList<GrammarResult> toReturn = new ArrayList<GrammarResult>();
        HashSet<String> params = new HashSet<String>();
        while (it.hasNext()) {
            String name;
            String editable;
            org.jdom2.Element el;
            Content c = (Content)it.next();
            if (!(c instanceof org.jdom2.Element) || !"parameter".equals((el = (org.jdom2.Element)c).getName()) || el.getParentElement() == null || !"parameters".equals(el.getParentElement().getName()) || el.getParentElement().getParentElement() == null || !"mojo".equals(el.getParentElement().getParentElement().getName()) || !"true".equalsIgnoreCase(editable = el.getChildText("editable")) || !(name = el.getChildText("name")).startsWith(hintCtx.getCurrentPrefix()) || params.contains(name)) continue;
            params.add(name);
            toReturn.add(new AbstractSchemaBasedGrammar.MyElement(name));
        }
        return toReturn;
    }

    private List<GrammarResult> collectPluginParams(ArtifactInfoHolder info, HintContext hintCtx) {
        Set params;
        if (info.getGroupId() == null || info.getArtifactId() == null || info.getVersion() == null) {
            return null;
        }
        try {
            params = PluginIndexManager.getPluginParameters((String)info.getGroupId(), (String)info.getArtifactId(), (String)info.getVersion(), null);
            if (params == null) {
                return null;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        ArrayList<GrammarResult> toReturn = new ArrayList<GrammarResult>();
        for (PluginIndexManager.ParameterDetail plg : params) {
            if (!plg.getName().startsWith(hintCtx.getCurrentPrefix())) continue;
            AbstractSchemaBasedGrammar.MyElement me = new AbstractSchemaBasedGrammar.MyElement(plg.getName());
            me.setDescription(plg.getHtmlDetails(true));
            toReturn.add(me);
        }
        return toReturn;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Enumeration<GrammarResult> getDynamicValueCompletion(String path, HintContext virtualTextCtx, org.jdom2.Element el) {
        FileObject fo;
        Node previous;
        ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> texts;
        RepositoryQueries.Result result;
        ArtifactInfoHolder hold;
        ArtifactInfoHolder hold2;
        Node previous2;
        String prefix;
        if (virtualTextCtx.getCurrentPrefix().length() > 0 && (prefix = virtualTextCtx.getCurrentPrefix()).lastIndexOf("${") > prefix.lastIndexOf("}")) {
            Object fo2;
            int s;
            int propStart = prefix.lastIndexOf("${") + 2;
            int delLen = -1;
            String propPrefix = prefix.substring(propStart);
            String val = virtualTextCtx.getNodeValue();
            int e = val.indexOf(125, propStart);
            if (e != -1 && ((s = val.indexOf("${", propStart)) == -1 || e < s)) {
                delLen = e - (propStart + propPrefix.length()) + 1;
            }
            if ((fo2 = this.getEnvironment().getFileObject()) != null) {
                ArrayList<String> set = new ArrayList<String>();
                set.add("basedir");
                set.add("project.build.finalName");
                set.add("project.version");
                set.add("project.groupId");
                try {
                    Properties props;
                    NbMavenProject nbMavenProject;
                    Project project = ProjectManager.getDefault().findProject(fo2.getParent());
                    if (project != null && (nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class)) != null && (props = nbMavenProject.getMavenProject().getProperties()) != null) {
                        set.addAll(props.stringPropertyNames());
                    }
                }
                catch (IOException iOException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ArrayList<AbstractSchemaBasedGrammar.ExpressionValueTextElement> arrayList = new ArrayList<AbstractSchemaBasedGrammar.ExpressionValueTextElement>();
                Collections.sort(set);
                String suffix = virtualTextCtx.getNodeValue().substring(prefix.length());
                int pplen = propPrefix.length();
                for (String pr : set) {
                    if (!pr.startsWith(propPrefix)) continue;
                    int l = delLen;
                    if (l == -1) {
                        for (l = 0; l < suffix.length() && l + pplen < pr.length() && suffix.charAt(l) == pr.charAt(pplen + l); ++l) {
                        }
                    }
                    arrayList.add(new AbstractSchemaBasedGrammar.ExpressionValueTextElement(pr, propPrefix, l));
                }
                return Collections.enumeration(arrayList);
            }
        }
        if (path.endsWith("executions/execution/goals/goal")) {
            if (virtualTextCtx.getCurrentPrefix().length() == 0) {
                Node previous4 = virtualTextCtx.getParentNode().getParentNode().getParentNode();
            } else {
                previous2 = virtualTextCtx.getParentNode().getParentNode().getParentNode().getParentNode();
            }
            previous2 = previous2.getPreviousSibling();
            MavenEmbedder embedder = EmbedderFactory.getOnlineEmbedder();
            ArtifactInfoHolder info = this.findPluginInfo(previous2, embedder, true);
            Enumeration<GrammarResult> res = this.collectGoals(info, virtualTextCtx);
            if (res == null) {
                Document pluginDoc = this.loadDocument(info, embedder);
                if (pluginDoc != null) {
                    return this.collectGoals(pluginDoc, virtualTextCtx);
                }
            } else {
                return res;
            }
        }
        if (path.endsWith("executions/execution/phase")) {
            return super.createTextValueList(Constants.DEFAULT_PHASES.toArray(new String[0]), virtualTextCtx);
        }
        if ((path.endsWith("dependencies/dependency/version") || path.endsWith("plugins/plugin/version") || path.endsWith("extensions/extension/version") || path.endsWith("/project/parent/version")) && (hold2 = this.findPluginInfo(previous2 = virtualTextCtx.getCurrentPrefix().length() == 0 ? virtualTextCtx.getPreviousSibling() : virtualTextCtx.getParentNode().getPreviousSibling(), null, false)).getGroupId() != null && hold2.getArtifactId() != null) {
            RepositoryQueries.Result result2 = RepositoryQueries.getVersionsResult((String)hold2.getGroupId(), (String)hold2.getArtifactId(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            List verStrings = result2.getResults();
            ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> elems = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
            HashSet<String> uniques = new HashSet<String>();
            for (NBVersionInfo vers : verStrings) {
                if (uniques.contains(vers.getVersion()) || !vers.getVersion().startsWith(virtualTextCtx.getCurrentPrefix())) continue;
                uniques.add(vers.getVersion());
                elems.add(new AbstractSchemaBasedGrammar.MyTextElement(vers.getVersion(), virtualTextCtx.getCurrentPrefix()));
            }
            if (result2.isPartial()) {
                elems.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(elems);
        }
        String propXPath = "/project/properties/";
        String profPropXPath = "/project/profiles/profile/properties/";
        if (path.startsWith(propXPath) && path.indexOf("/", propXPath.length()) == -1 || path.startsWith(profPropXPath) && path.indexOf("/", profPropXPath.length()) == -1) {
            Object property;
            Node projectNode = virtualTextCtx.getCurrentPrefix().isEmpty() ? virtualTextCtx.getParentNode().getParentNode() : virtualTextCtx.getParentNode().getParentNode().getParentNode();
            if (path.startsWith(profPropXPath)) {
                property = path.substring(profPropXPath.length());
                projectNode = projectNode.getParentNode().getParentNode();
            } else {
                property = path.substring(propXPath.length());
            }
            property = "${" + (String)property + "}";
            HashSet<ArtifactInfoHolder> usages = new HashSet<ArtifactInfoHolder>();
            block6: for (Node node : MavenProjectGrammar.iterate(projectNode.getChildNodes())) {
                if ("dependencies".equals(node.getNodeName())) {
                    this.collectArtifacts("dependency", node, (String)property, usages);
                    continue;
                }
                if ("dependencyManagement".equals(node.getNodeName())) {
                    for (Node node2 : MavenProjectGrammar.iterate(node.getChildNodes())) {
                        if (!"dependencies".equals(node2.getNodeName())) continue;
                        this.collectArtifacts("dependency", node2, (String)property, usages);
                        continue block6;
                    }
                    continue;
                }
                if (!"build".equals(node.getNodeName())) continue;
                block8: for (Node node3 : MavenProjectGrammar.iterate(node.getChildNodes())) {
                    if ("plugins".equals(node3.getNodeName())) {
                        this.collectArtifacts("plugin", node3, (String)property, usages);
                        continue;
                    }
                    if (!"pluginManagement".equals(node3.getNodeName())) continue;
                    for (Node pmChild : MavenProjectGrammar.iterate(node3.getChildNodes())) {
                        if (!"plugins".equals(pmChild.getNodeName())) continue;
                        this.collectArtifacts("plugin", pmChild, (String)property, usages);
                        continue block8;
                    }
                }
            }
            LinkedHashSet versions = new LinkedHashSet();
            boolean first = true;
            boolean partial = false;
            for (ArtifactInfoHolder artifactInfoHolder : usages) {
                RepositoryQueries.Result versionInfo = RepositoryQueries.getVersionsResult((String)artifactInfoHolder.getGroupId(), (String)artifactInfoHolder.getArtifactId(), null);
                partial |= versionInfo.isPartial();
                List list = versionInfo.getResults().stream().map(NBVersionInfo::getVersion).collect(Collectors.toList());
                if (first) {
                    versions.addAll(list);
                    first = false;
                    continue;
                }
                versions.retainAll(list);
            }
            ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> arrayList = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
            for (String version : versions) {
                if (!version.startsWith(virtualTextCtx.getCurrentPrefix())) continue;
                arrayList.add(new AbstractSchemaBasedGrammar.MyTextElement(version, virtualTextCtx.getCurrentPrefix()));
            }
            if (partial) {
                arrayList.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(arrayList);
        }
        if (path.endsWith("dependencies/dependency/groupId") || path.endsWith("extensions/extension/groupId")) {
            RepositoryQueries.Result result3 = RepositoryQueries.getGroupsResult((List)RepositoryPreferences.getInstance().getRepositoryInfos());
            List elems = result3.getResults();
            ArrayList<AbstractSchemaBasedGrammar.PartialTextElement> texts2 = new ArrayList<AbstractSchemaBasedGrammar.PartialTextElement>();
            for (String elem : elems) {
                if (!elem.startsWith(virtualTextCtx.getCurrentPrefix())) continue;
                texts2.add((AbstractSchemaBasedGrammar.PartialTextElement)((Object)new AbstractSchemaBasedGrammar.MyTextElement(elem, virtualTextCtx.getCurrentPrefix())));
            }
            if (result3.isPartial()) {
                texts2.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(texts2);
        }
        if (path.endsWith("plugins/plugin/groupId")) {
            RepositoryQueries.Result result4 = RepositoryQueries.filterPluginGroupIdsResult((String)virtualTextCtx.getCurrentPrefix(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> texts3 = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
            for (String elem : result4.getResults()) {
                texts3.add(new AbstractSchemaBasedGrammar.MyTextElement(elem, virtualTextCtx.getCurrentPrefix()));
            }
            if (result4.isPartial()) {
                texts3.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(texts3);
        }
        if (path.endsWith("dependencies/dependency/artifactId") || path.endsWith("extensions/extension/artifactId")) {
            Node previous3;
            if (virtualTextCtx.getCurrentPrefix().length() == 0) {
                Node previous32 = virtualTextCtx.getPreviousSibling();
            } else {
                previous3 = virtualTextCtx.getParentNode().getPreviousSibling();
            }
            hold = this.findArtifactInfo(previous3);
            if (hold.getGroupId() != null) {
                result = RepositoryQueries.getArtifactsResult((String)hold.getGroupId(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
                List elems = result.getResults();
                texts = new ArrayList<AbstractSchemaBasedGrammar.PartialTextElement>();
                String currprefix = virtualTextCtx.getCurrentPrefix();
                for (String string : elems) {
                    if (!string.startsWith(currprefix)) continue;
                    texts.add(new AbstractSchemaBasedGrammar.MyTextElement(string, currprefix));
                }
                if (result.isPartial()) {
                    texts.add(new AbstractSchemaBasedGrammar.PartialTextElement());
                }
                return Collections.enumeration(texts);
            }
        }
        if (path.endsWith("dependencies/dependency/classifier")) {
            Node previous4;
            if (virtualTextCtx.getCurrentPrefix().length() == 0) {
                Node previous22 = virtualTextCtx.getPreviousSibling();
            } else {
                previous4 = virtualTextCtx.getParentNode().getPreviousSibling();
            }
            hold = this.findArtifactInfo(previous4);
            if (hold.getGroupId() != null && hold.getArtifactId() != null && hold.getVersion() != null) {
                result = RepositoryQueries.getRecordsResult((String)hold.getGroupId(), (String)hold.getArtifactId(), (String)hold.getVersion(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
                List elems = result.getResults();
                texts = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
                String currprefix = virtualTextCtx.getCurrentPrefix();
                HashSet<String> hashSet = new HashSet<String>();
                for (NBVersionInfo elem : elems) {
                    if (hashSet.contains(elem.getClassifier()) || elem.getClassifier() == null || !elem.getClassifier().startsWith(currprefix)) continue;
                    texts.add(new AbstractSchemaBasedGrammar.MyTextElement(elem.getClassifier(), currprefix));
                    hashSet.add(elem.getClassifier());
                }
                if (result.isPartial()) {
                    texts.add(new AbstractSchemaBasedGrammar.PartialTextElement());
                }
                return Collections.enumeration(texts);
            }
        }
        if (path.endsWith("plugins/plugin/artifactId") && (hold = this.findArtifactInfo(previous = virtualTextCtx.getCurrentPrefix().length() == 0 ? virtualTextCtx.getPreviousSibling() : virtualTextCtx.getParentNode().getPreviousSibling())).getGroupId() != null) {
            result = RepositoryQueries.filterPluginArtifactIdsResult((String)hold.getGroupId(), (String)virtualTextCtx.getCurrentPrefix(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> texts4 = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
            for (String elem : result.getResults()) {
                texts4.add(new AbstractSchemaBasedGrammar.MyTextElement(elem, virtualTextCtx.getCurrentPrefix()));
            }
            if (result.isPartial()) {
                texts4.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(texts4);
        }
        if (path.endsWith("dependencies/dependency/scope")) {
            if (path.contains("dependencyManagement")) {
                ArrayList<String> lst = new ArrayList<String>(Arrays.asList(SCOPES));
                lst.add("import");
                Collections.sort(lst);
                return super.createTextValueList(lst.toArray(new String[0]), virtualTextCtx);
            }
            return super.createTextValueList(SCOPES, virtualTextCtx);
        }
        if (path.endsWith("repositories/repository/releases/updatePolicy") || path.endsWith("repositories/repository/snapshots/updatePolicy") || path.endsWith("pluginRepositories/pluginRepository/releases/updatePolicy") || path.endsWith("pluginRepositories/pluginRepository/snapshots/updatePolicy")) {
            return super.createTextValueList(MavenSettingsGrammar.UPDATE_POLICIES, virtualTextCtx);
        }
        if (path.endsWith("repository/releases/checksumPolicy") || path.endsWith("repository/snapshots/checksumPolicy") || path.endsWith("pluginRepository/releases/checksumPolicy") || path.endsWith("pluginRepository/snapshots/checksumPolicy")) {
            return super.createTextValueList(MavenSettingsGrammar.CHECKSUM_POLICIES, virtualTextCtx);
        }
        if (path.endsWith("repositories/repository/layout") || path.endsWith("pluginRepositories/pluginRepository/layout") || path.endsWith("distributionManagement/repository/layout")) {
            return super.createTextValueList(MavenSettingsGrammar.LAYOUTS, virtualTextCtx);
        }
        if (path.endsWith("repositories/repository/url") || path.endsWith("pluginRepositories/pluginRepository/url") || path.endsWith("distributionManagement/repository/url")) {
            List<String> repoIds = this.getRepoUrls();
            return super.createTextValueList(repoIds.toArray(new String[0]), virtualTextCtx);
        }
        if (path.endsWith("modules/module") && (fo = this.getEnvironment().getFileObject()) != null) {
            void var12_51;
            File dir = FileUtil.toFile((FileObject)fo).getParentFile();
            String prefix2 = virtualTextCtx.getCurrentPrefix();
            boolean endingSlash = prefix2.endsWith("/");
            String[] elms = StringUtils.split((String)prefix2, (String)"/");
            String lastElement = "";
            boolean bl = false;
            while (var12_51 < elms.length) {
                if ("..".equals(elms[var12_51])) {
                    dir = dir != null ? dir.getParentFile() : null;
                } else if (var12_51 < elms.length - (endingSlash ? 0 : 1)) {
                    dir = dir != null ? new File(dir, elms[var12_51]) : null;
                } else {
                    lastElement = elms[var12_51];
                }
                ++var12_51;
            }
            String string = prefix2 = lastElement != null ? lastElement : prefix2;
            if (dir == null || !dir.exists() || !dir.isDirectory()) {
                return null;
            }
            File[] fileArray = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && new File(pathname, "pom.xml").exists();
                }
            });
            ArrayList<AbstractSchemaBasedGrammar.MyTextElement> arrayList = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getName().startsWith(prefix2)) continue;
                arrayList.add(new AbstractSchemaBasedGrammar.MyTextElement(fileArray[i].getName(), prefix2));
            }
            return Collections.enumeration(arrayList);
        }
        return null;
    }

    private List<String> getRepoUrls() {
        ArrayList<String> repos = new ArrayList<String>();
        List ris = RepositoryPreferences.getInstance().getRepositoryInfos();
        for (RepositoryInfo ri : ris) {
            if (ri.getRepositoryUrl() == null) continue;
            repos.add(ri.getRepositoryUrl());
        }
        return repos;
    }

    private Document loadDocument(ArtifactInfoHolder info, MavenEmbedder embedder) {
        if (info.getArtifactId() != null && info.getGroupId() != null && info.getVersion() != null) {
            Artifact art = embedder.createArtifact(info.getGroupId(), info.getArtifactId(), info.getVersion(), null, "jar");
            String repopath = embedder.getLocalRepository().pathOf(art);
            File fil = new File(embedder.getLocalRepositoryFile(), repopath);
            if (fil.exists()) {
                try {
                    JarFile jf = new JarFile(fil);
                    JarEntry entry = jf.getJarEntry("META-INF/maven/plugin.xml");
                    if (entry != null) {
                        InputStream str = jf.getInputStream(entry);
                        SAXBuilder builder = new SAXBuilder();
                        return builder.build(str);
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.FINER, "", ex);
                }
                catch (JDOMException ex) {
                    LOG.log(Level.FINER, "", ex);
                }
            }
        }
        return null;
    }

    private static Iterable<Node> iterate(final NodeList list) {
        return () -> new Iterator<Node>(){
            int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < list.getLength();
            }

            @Override
            public Node next() {
                return list.item(this.current++);
            }
        };
    }

    private void collectArtifacts(String artifactTag, Node parent, String decoratedProperty, Set<ArtifactInfoHolder> usages) {
        for (Node child : MavenProjectGrammar.iterate(parent.getChildNodes())) {
            if (!artifactTag.equals(child.getNodeName())) continue;
            ArtifactInfoHolder artifact = new ArtifactInfoHolder();
            artifact.setGroupId("org.apache.maven.plugins");
            for (Node attr : MavenProjectGrammar.iterate(child.getChildNodes())) {
                if (attr.getNodeName() == null) continue;
                switch (attr.getNodeName()) {
                    case "groupId": {
                        artifact.setGroupId(attr.getFirstChild().getNodeValue());
                        break;
                    }
                    case "artifactId": {
                        artifact.setArtifactId(attr.getFirstChild().getNodeValue());
                        break;
                    }
                    case "version": {
                        artifact.setVersion(attr.getFirstChild().getNodeValue());
                    }
                }
            }
            if (artifact.getGroupId() == null || artifact.getArtifactId() == null || !decoratedProperty.equals(artifact.getVersion())) continue;
            usages.add(artifact);
        }
    }

    private Enumeration<GrammarResult> collectGoals(Document pluginDoc, HintContext virtualTextCtx) {
        IteratorIterable it = pluginDoc.getRootElement().getDescendants();
        ArrayList<AbstractSchemaBasedGrammar.MyTextElement> toReturn = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
        while (it.hasNext()) {
            String name;
            org.jdom2.Element el;
            Content c = (Content)it.next();
            if (!(c instanceof org.jdom2.Element) || !"goal".equals((el = (org.jdom2.Element)c).getName()) || el.getParentElement() == null || !"mojo".equals(el.getParentElement().getName()) || !(name = el.getText()).startsWith(virtualTextCtx.getCurrentPrefix())) continue;
            toReturn.add(new AbstractSchemaBasedGrammar.MyTextElement(name, virtualTextCtx.getCurrentPrefix()));
        }
        return Collections.enumeration(toReturn);
    }

    private Enumeration<GrammarResult> collectGoals(ArtifactInfoHolder info, HintContext virtualTextCtx) {
        Set goals;
        if (info.getGroupId() == null || info.getArtifactId() == null || info.getVersion() == null) {
            return null;
        }
        try {
            goals = PluginIndexManager.getPluginGoals((String)info.getGroupId(), (String)info.getArtifactId(), (String)info.getVersion());
            if (goals == null) {
                return null;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        ArrayList<AbstractSchemaBasedGrammar.MyTextElement> toReturn = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
        for (String name : goals) {
            if (!name.startsWith(virtualTextCtx.getCurrentPrefix())) continue;
            toReturn.add(new AbstractSchemaBasedGrammar.MyTextElement(name, virtualTextCtx.getCurrentPrefix()));
        }
        return Collections.enumeration(toReturn);
    }

    private static class ArtifactInfoHolder {
        private String artifactId;
        private String groupId;
        private String version;

        private ArtifactInfoHolder() {
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + Objects.hashCode(this.artifactId);
            hash = 67 * hash + Objects.hashCode(this.groupId);
            hash = 67 * hash + Objects.hashCode(this.version);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArtifactInfoHolder other = (ArtifactInfoHolder)obj;
            if (!Objects.equals(this.artifactId, other.artifactId)) {
                return false;
            }
            if (!Objects.equals(this.groupId, other.groupId)) {
                return false;
            }
            return Objects.equals(this.version, other.version);
        }

        public String toString() {
            return "ArtifactInfoHolder{artifactId=" + this.artifactId + ", groupId=" + this.groupId + ", version=" + this.version + "}";
        }
    }
}

