/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.languages.yaml.YamlLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.LanguageProvider;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.openide.util.Lookup;

public enum YamlTokenId implements TokenId
{
    TEXT("identifier"),
    COMMENT("comment"),
    RUBYCOMMENT("comment"),
    RUBY_EXPR("ruby"),
    RUBY("ruby"),
    DELIMITER("ruby-delimiter"),
    PHP("php"),
    MUSTACHE("mustache"),
    MUSTACHE_DELIMITER("mustache-delimiter");

    private final String primaryCategory;
    private static final Language<YamlTokenId> language;
    public static final String YAML_MIME_TYPE = "text/x-yaml";

    private YamlTokenId(String primaryCategory) {
        this.primaryCategory = primaryCategory;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static boolean isRuby(TokenId id) {
        return id == RUBY || id == RUBY_EXPR || id == RUBYCOMMENT;
    }

    public static Language<YamlTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<YamlTokenId>(){

            protected String mimeType() {
                return YamlTokenId.YAML_MIME_TYPE;
            }

            protected Collection<YamlTokenId> createTokenIds() {
                return EnumSet.allOf(YamlTokenId.class);
            }

            protected Map<String, Collection<YamlTokenId>> createTokenCategories() {
                HashMap<String, Collection<YamlTokenId>> cats = new HashMap<String, Collection<YamlTokenId>>();
                return cats;
            }

            protected Lexer<YamlTokenId> createLexer(LexerRestartInfo<YamlTokenId> info) {
                return new YamlLexer(info);
            }

            protected LanguageEmbedding<? extends TokenId> embedding(Token<YamlTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                switch ((YamlTokenId)token.id()) {
                    case RUBY_EXPR: 
                    case RUBY: {
                        LanguageProvider provider;
                        Language rubyLanguage = null;
                        Collection providers = Lookup.getDefault().lookupAll(LanguageProvider.class);
                        Iterator iterator = providers.iterator();
                        while (iterator.hasNext() && (rubyLanguage = (provider = (LanguageProvider)iterator.next()).findLanguage("text/x-ruby")) == null) {
                        }
                        return rubyLanguage != null ? LanguageEmbedding.create(rubyLanguage, (int)0, (int)0, (boolean)false) : null;
                    }
                    case PHP: {
                        LanguageProvider provider;
                        Language phpLanguage = null;
                        Collection providers = Lookup.getDefault().lookupAll(LanguageProvider.class);
                        Iterator iterator = providers.iterator();
                        while (iterator.hasNext() && (phpLanguage = (provider = (LanguageProvider)iterator.next()).findLanguage("text/x-php5")) == null) {
                        }
                        return phpLanguage != null ? LanguageEmbedding.create(phpLanguage, (int)0, (int)0, (boolean)false) : null;
                    }
                }
                return null;
            }
        }.language();
    }
}

