/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.terraform;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.languages.hcl.HCLParserResult;
import org.netbeans.modules.languages.hcl.ast.HCLAttribute;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLContainer;
import org.netbeans.modules.languages.hcl.ast.HCLDocument;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.ast.SourceRef;
import org.netbeans.modules.languages.hcl.terraform.Bundle;
import org.netbeans.modules.parsing.api.Snapshot;

public class TerraformParserResult
extends HCLParserResult {
    public TerraformParserResult(Snapshot snapshot) {
        super(snapshot);
    }

    @Override
    protected void processDocument(HCLDocument doc, SourceRef references) {
        HashSet<String> defined = new HashSet<String>();
        for (HCLBlock hCLBlock : doc.getBlocks()) {
            List<HCLIdentifier> decl = hCLBlock.getDeclaration();
            HCLIdentifier type = decl.get(0);
            BlockType bt = BlockType.get(type.id());
            if (bt != null) {
                if (decl.size() != bt.definitionLength) {
                    references.getOffsetRange(type).ifPresent(range -> this.addError(Bundle.INVALID_BLOCK_DECLARATION(bt.type, bt.definitionLength - 1), (OffsetRange)range));
                } else if (!defined.add(hCLBlock.id())) {
                    switch (bt) {
                        case CHECK: 
                        case DATA: 
                        case MODULE: 
                        case OUTPUT: 
                        case RESOURCE: 
                        case VARIABLE: {
                            references.getOffsetRange(type).ifPresent(range -> this.addError(Bundle.DUPLICATE_BLOCK(block.id()), (OffsetRange)range));
                        }
                    }
                }
            } else {
                references.getOffsetRange(type).ifPresent(range -> this.addError(Bundle.UNKNOWN_BLOCK(type.id()), (OffsetRange)range));
            }
            this.checkDuplicateAttribute(hCLBlock, references);
        }
        for (HCLAttribute hCLAttribute : doc.getAttributes()) {
            references.getOffsetRange(hCLAttribute.getName()).ifPresent(range -> this.addError(Bundle.UNEXPECTED_DOCUMENT_ATTRIBUTE(attribute.id()), (OffsetRange)range));
        }
    }

    private void checkDuplicateAttribute(HCLContainer c, SourceRef references) {
        for (HCLBlock hCLBlock : c.getBlocks()) {
            this.checkDuplicateAttribute(hCLBlock, references);
        }
        if (c.hasAttributes()) {
            HashSet<String> defined = new HashSet<String>();
            for (HCLAttribute hCLAttribute : c.getAttributes()) {
                if (defined.add(hCLAttribute.id())) continue;
                references.getOffsetRange(hCLAttribute.getName()).ifPresent(range -> this.addError(Bundle.DUPLICATE_ATTRIBUTE(attr.id()), (OffsetRange)range));
            }
        }
    }

    private void addError(String message, OffsetRange range) {
        DefaultError error = new DefaultError(null, message, null, this.getFileObject(), range.getStart(), range.getEnd(), Severity.ERROR);
        this.errors.add(error);
    }

    public static enum BlockType {
        CHECK("check", 2),
        DATA("data", 3),
        LOCALS("locals", 1),
        MODULE("module", 2),
        MOVED("moved", 1),
        OUTPUT("output", 2),
        PROVIDER("provider", 2),
        RESOURCE("resource", 3),
        TERRAFORM("terraform", 1),
        VARIABLE("variable", 2);

        final String type;
        final int definitionLength;
        private static final Map<String, BlockType> TYPES;

        private BlockType(String type, int definitionLenght) {
            this.type = type;
            this.definitionLength = definitionLenght;
        }

        public static BlockType get(String name) {
            return TYPES.get(name);
        }

        static {
            TYPES = new HashMap<String, BlockType>();
            for (BlockType bt : BlockType.values()) {
                TYPES.put(bt.type, bt);
            }
        }
    }
}

