/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.vue.editor.embedding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.vue.editor.lexer.VueTokenId;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;

public class VueHtmlEmbeddingProvider
extends EmbeddingProvider {
    public static final String FILLER = " ";
    public static final String TARGET_MIME_TYPE = "text/html";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy tokenHierarchy = snapshot.getTokenHierarchy();
        TokenSequence ts = tokenHierarchy.tokenSequence();
        if (ts == null || !ts.isValid()) {
            return Collections.emptyList();
        }
        ts.moveStart();
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        try {
            while (ts.moveNext()) {
                Token token = ts.token();
                TokenId id = token.id();
                if (token.text() == null || id != VueTokenId.HTML) continue;
                embeddings.add(snapshot.create(ts.offset(), token.length(), TARGET_MIME_TYPE));
            }
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
        if (embeddings.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    public int getPriority() {
        return 210;
    }

    public void cancel() {
    }
}

