/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptions;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferences;
import org.netbeans.modules.javascript.nodejs.ui.Bundle;
import org.netbeans.modules.javascript.nodejs.util.GraalVmUtils;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.NotificationDisplayer;
import org.openide.awt.StatusDisplayer;

public final class Notifications {
    private Notifications() {
    }

    public static void notifyNodeJsDetected(Project project) {
        final String projectName = NodeJsUtils.getProjectDisplayName(project);
        final NodeJsPreferences preferences = NodeJsSupport.forProject(project).getPreferences();
        assert (!preferences.isEnabled()) : "node.js support should not be enabled in project " + projectName;
        NotificationDisplayer.getDefault().notify(Bundle.Notifications_detection_title(), NotificationDisplayer.Priority.LOW.getIcon(), Bundle.Notifications_detection_description(projectName), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text;
                if (preferences.isEnabled()) {
                    text = Bundle.Notifications_detection_noop(projectName);
                } else {
                    preferences.setEnabled(true);
                    text = Bundle.Notifications_detection_done(projectName);
                }
                StatusDisplayer.getDefault().setStatusText(text);
            }
        }, NotificationDisplayer.Priority.LOW);
    }

    public static void notifyGraalVmDetected() {
        NotificationDisplayer.getDefault().notify(Bundle.Notifications_graalvm_detection_title(), NotificationDisplayer.Priority.LOW.getIcon(), Bundle.Notifications_graalvm_detection_description(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text;
                if (GraalVmUtils.properPathsSet()) {
                    text = Bundle.Notifications_graalvm_detection_noop();
                } else {
                    NodeJsOptions.getInstance().setNode(GraalVmUtils.getNode());
                    NodeJsOptions.getInstance().setNpm(GraalVmUtils.getNpm(true));
                    text = Bundle.Notifications_graalvm_detection_done();
                }
                StatusDisplayer.getDefault().setStatusText(text);
            }
        }, NotificationDisplayer.Priority.LOW);
    }

    public static void notifyRunConfiguration(Project project) {
        final String projectName = NodeJsUtils.getProjectDisplayName(project);
        final NodeJsSupport nodeJsSupport = NodeJsSupport.forProject(project);
        final NodeJsPreferences preferences = nodeJsSupport.getPreferences();
        assert (!preferences.isRunEnabled()) : "node.js run should not be enabled in " + projectName;
        NotificationDisplayer.getDefault().notify(Bundle.Notifications_enabled_title(), NotificationDisplayer.Priority.LOW.getIcon(), Bundle.Notifications_enabled_description(projectName), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text;
                if (!preferences.isEnabled()) {
                    text = Bundle.Notifications_enabled_invalid(projectName);
                } else if (preferences.isRunEnabled()) {
                    text = Bundle.Notifications_enabled_noop(projectName);
                } else {
                    nodeJsSupport.firePropertyChanged("RUN_CONFIGURATION", null, "node.js");
                    text = Bundle.Notifications_enabled_done(projectName);
                }
                StatusDisplayer.getDefault().setStatusText(text);
            }
        }, NotificationDisplayer.Priority.LOW);
    }

    public static void notifyUser(String title, String details) {
        NotificationDisplayer.getDefault().notify(title, NotificationDisplayer.Priority.LOW.getIcon(), details, null, NotificationDisplayer.Priority.LOW);
    }

    public static void informUser(String message) {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
    }

    public static void ask(final String title, final String question, final @NullAllowed Runnable yesTask, final @NullAllowed Runnable noTask) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)question, title, 0);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION) {
                    if (yesTask != null) {
                        yesTask.run();
                    }
                } else if (noTask != null) {
                    noTask.run();
                }
            }
        });
    }

    public static void askSyncChanges(Project project, @NullAllowed Runnable yesTask, @NullAllowed Runnable noTask) {
        Notifications.ask(NodeJsUtils.getProjectDisplayName(project), Bundle.Notifications_ask_sync(), yesTask, noTask);
    }
}

