/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.ui.vars.tooltip;

import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.lib.chrome_devtools_protocol.runtime.RemoteObject;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.ui.vars.models.VariablesModel;
import org.netbeans.modules.javascript.cdtdebug.vars.CDTEvaluator;
import org.netbeans.modules.javascript.cdtdebug.vars.EvaluationError;
import org.netbeans.modules.javascript.cdtdebug.vars.Variable;
import org.netbeans.modules.javascript2.debug.ui.tooltip.AbstractJSToolTipAnnotation;
import org.openide.util.Pair;

public class ToolTipAnnotation
extends AbstractJSToolTipAnnotation {
    protected void handleToolTipClose(DebuggerEngine engine, ToolTipSupport tts) {
        CDTDebugger debugger = (CDTDebugger)engine.lookupFirst(null, CDTDebugger.class);
        if (debugger == null) {
            return;
        }
        ToolTipAnnotation.handleToolTipClose(debugger, tts);
    }

    public static void handleToolTipClose(CDTDebugger debugger, final ToolTipSupport tts) {
        CDTDebugger.Listener listener = new CDTDebugger.Listener(){

            public void notifySuspended(boolean suspended) {
                if (!suspended) {
                    this.doClose();
                }
            }

            public void notifyCurrentFrame(CallFrame cf) {
                this.doClose();
            }

            public void notifyFinished() {
                this.doClose();
            }

            private void doClose() {
                SwingUtilities.invokeLater(() -> tts.setToolTipVisible(false));
            }
        };
        debugger.addListener(listener);
        tts.addPropertyChangeListener(pl -> {
            if ("status".equals(pl.getPropertyName()) && !tts.isToolTipVisible()) {
                debugger.removeListener(listener);
            }
        });
    }

    protected Pair<String, Object> evaluate(String expression, DebuggerEngine engine) throws CancellationException {
        String toolTipText;
        Variable var = null;
        CDTDebugger debugger = (CDTDebugger)engine.lookupFirst(null, CDTDebugger.class);
        if (debugger == null || !debugger.isSuspended()) {
            return null;
        }
        try {
            RemoteObject value = CDTEvaluator.evaluate((CDTDebugger)debugger, (String)expression);
            if (value == null) {
                throw new CancellationException();
            }
            toolTipText = expression + " = " + CDTEvaluator.getStringValue((RemoteObject)value);
            if (!VariablesModel.isLeaf2(value)) {
                var = new Variable(expression, value);
            }
        }
        catch (EvaluationError ex) {
            toolTipText = expression + " = >" + ex.getMessage() + "<";
        }
        return Pair.of((Object)toolTipText, var);
    }
}

