/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.ui.vars.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.lib.chrome_devtools_protocol.debugger.EvaluateOnCallFrameRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.Scope;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetVariableValueRequest;
import org.netbeans.lib.chrome_devtools_protocol.runtime.CallArgument;
import org.netbeans.lib.chrome_devtools_protocol.runtime.GetPropertiesRequest;
import org.netbeans.lib.chrome_devtools_protocol.runtime.GetPropertiesResponse;
import org.netbeans.lib.chrome_devtools_protocol.runtime.RemoteObject;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.vars.CDTEvaluator;
import org.netbeans.modules.javascript.cdtdebug.vars.Variable;
import org.netbeans.modules.javascript2.debug.ui.models.ViewModelSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.TableHTMLModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.datatransfer.PasteType;

public class VariablesModel
extends ViewModelSupport
implements TreeModel,
ExtendedNodeModel,
TableModel,
TableHTMLModel,
CDTDebugger.Listener {
    private static final Set<String> WRITABLE_SCOPES = new HashSet<String>(Arrays.asList("local", "closure", "catch"));
    private static final String ICON_LOCAL = "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png";
    private static final String ICON_SCOPE = "org/netbeans/modules/javascript2/debug/ui/resources/global_variable_16.png";
    protected final CDTDebugger dbg;
    private volatile boolean topFrameRefreshed;

    public VariablesModel(ContextProvider contextProvider) {
        this.dbg = (CDTDebugger)contextProvider.lookupFirst(null, CDTDebugger.class);
        this.dbg.addListener((CDTDebugger.Listener)this);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            CallFrame frame = this.dbg.getCurrentFrame();
            if (frame == null) {
                return EMPTY_CHILDREN;
            }
            ArrayList scopes = new ArrayList(frame.getScopeChain());
            if (!scopes.isEmpty()) {
                Scope topScope = (Scope)scopes.remove(0);
                Object[] topChildren = this.getObjectChildren(topScope, "", topScope.getObject());
                Object[] result = new Object[topChildren.length + scopes.size()];
                System.arraycopy(topChildren, 0, result, 0, topChildren.length);
                for (int i = 0; i < scopes.size(); ++i) {
                    result[i + topChildren.length] = scopes.get(i);
                }
                return result;
            }
            return EMPTY_CHILDREN;
        }
        if (parent instanceof Variable) {
            if (((Variable)parent).getValue().getObjectId() == null) {
                return EMPTY_CHILDREN;
            }
            Variable v = (Variable)parent;
            Object newParentPath = v.getParentPath().isEmpty() ? v.getName() : v.getParentPath() + "['" + v.getName() + "']";
            return this.getObjectChildren(v.getScope(), (String)newParentPath, v.getValue());
        }
        if (parent instanceof Scope) {
            Scope s = (Scope)parent;
            return this.getObjectChildren(s, "", s.getObject());
        }
        return EMPTY_CHILDREN;
    }

    protected final Object[] getObjectChildren(Scope scope, String parentObjectPath, RemoteObject remoteObject) {
        try {
            return ((GetPropertiesResponse)this.dbg.getConnection().getRuntime().getProperties(new GetPropertiesRequest(remoteObject.getObjectId(), Boolean.valueOf(true))).toCompletableFuture().get()).getResult().stream().map(pd -> new Variable(scope, pd.getName(), parentObjectPath, pd.getValue())).collect(Collectors.toList()).toArray();
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new Object[0];
        }
    }

    public boolean isLeaf(Object node) {
        return VariablesModel.isLeaf2(node);
    }

    public static boolean isLeaf2(Object node) {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Scope) {
            return false;
        }
        if (node instanceof Variable) {
            return VariablesModel.isLeaf2(((Variable)node).getValue());
        }
        if (node instanceof RemoteObject) {
            return ((RemoteObject)node).getObjectId() == null;
        }
        return true;
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        return null;
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        return null;
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        return null;
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node instanceof Scope) {
            return ICON_SCOPE;
        }
        return ICON_LOCAL;
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof Variable) {
            return ((Variable)node).getName();
        }
        if (node instanceof Scope) {
            Scope scope = (Scope)node;
            String text = scope.getName();
            if (text == null) {
                text = scope.getType();
            }
            return text + " Scope";
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof Variable) {
            Variable var = (Variable)node;
            RemoteObject value = var.getValue();
            if (value == null) {
                return null;
            }
            String strVal = CDTEvaluator.getStringValue((RemoteObject)value);
            return var.getName() + " = " + strVal;
        }
        return null;
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node == "Root") {
            return "";
        }
        if (node instanceof Variable) {
            if ("LocalsValue".equals(columnID) || "LocalsToString".equals(columnID)) {
                return CDTEvaluator.getStringValue((RemoteObject)((Variable)node).getValue());
            }
            if ("LocalsType".equals(columnID)) {
                return CDTEvaluator.getStringType((RemoteObject)((Variable)node).getValue());
            }
        } else if (node instanceof Scope) {
            return "";
        }
        throw new UnknownTypeException(node);
    }

    public boolean hasHTMLValueAt(Object node, String columnID) throws UnknownTypeException {
        return "LocalsValue".equals(columnID) || "LocalsToString".equals(columnID) || "LocalsType".equals(columnID);
    }

    public String getHTMLValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node == "Root") {
            return "";
        }
        if (node instanceof Variable) {
            if ("LocalsValue".equals(columnID) || "LocalsToString".equals(columnID)) {
                return VariablesModel.toHTML((String)CDTEvaluator.getStringValue((RemoteObject)((Variable)node).getValue()));
            }
            if ("LocalsType".equals(columnID)) {
                return VariablesModel.toHTML((String)CDTEvaluator.getStringType((RemoteObject)((Variable)node).getValue()));
            }
        } else if (node instanceof Scope) {
            return "";
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (("LocalsValue".equals(columnID) || "LocalsToString".equals(columnID)) && node instanceof Variable) {
            Variable v = (Variable)node;
            return v.getScope() == null || !WRITABLE_SCOPES.contains(v.getScope().getType()) || !v.getParentPath().isEmpty();
        }
        return true;
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        if (Objects.equals(value, this.getValueAt(node, columnID))) {
            return;
        }
        if (!(value instanceof String)) {
            throw new UnknownTypeException((Object)("Accepting String values only. Not " + value));
        }
        if ("LocalsValue".equals(columnID) && node instanceof Variable) {
            Variable var = (Variable)node;
            CallFrame cf = this.dbg.getCurrentFrame();
            if (cf == null) {
                return;
            }
            int scopeNumber = this.dbg.getCurrentFrame().getScopeChain().indexOf(var.getScope());
            if (scopeNumber < 0) {
                return;
            }
            String frameId = this.dbg.getCurrentFrame().getCallFrameId();
            EvaluateOnCallFrameRequest req = new EvaluateOnCallFrameRequest(frameId, (String)value);
            this.dbg.getConnection().getDebugger().evaluateOnCallFrame(req).thenCompose(eocfr -> {
                if (eocfr.getExceptionDetails() != null) {
                    throw new RuntimeException(eocfr.getExceptionDetails().getException().getDescription());
                }
                CallArgument ca = new CallArgument();
                ca.setObjectId(eocfr.getResult().getObjectId());
                ca.setUnserializableValue(eocfr.getResult().getUnserializableValue());
                ca.setValue(eocfr.getResult().getValue());
                SetVariableValueRequest svvr = new SetVariableValueRequest();
                svvr.setCallFrameId(frameId);
                svvr.setNewValue(ca);
                svvr.setScopeNumber(scopeNumber);
                svvr.setVariableName(var.getName());
                return this.dbg.getConnection().getDebugger().setVariableValue(svvr).thenApply(svvr2 -> eocfr);
            }).handle((eocfr, thr) -> {
                if (thr instanceof CompletionException) {
                    thr = thr.getCause();
                }
                if (thr != null) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)thr.getMessage(), 0));
                } else {
                    var.setValue(eocfr.getResult());
                    this.fireChangeEvent((ModelEvent)new ModelEvent.TableValueChanged((Object)this, node, null, 1));
                }
                return null;
            });
        }
    }

    public void notifySuspended(boolean suspended) {
        this.refresh();
        this.topFrameRefreshed = suspended;
    }

    public void notifyCurrentFrame(CallFrame cf) {
        if (cf == null) {
            return;
        }
        if (this.topFrameRefreshed && cf == this.dbg.getCurrentCallStack().get(0)) {
            return;
        }
        this.topFrameRefreshed = false;
        this.refresh();
    }

    public void notifyFinished() {
    }
}

