/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.bower.exec.BowerExecutable;
import org.netbeans.modules.javascript.bower.file.BowerJson;
import org.netbeans.modules.javascript.bower.file.BowerrcJson;
import org.netbeans.modules.javascript.bower.problems.Bundle;
import org.netbeans.modules.javascript.bower.util.BowerUtils;
import org.netbeans.modules.javascript.bower.util.StringUtils;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class BowerProblemsProvider
implements ProjectProblemsProvider,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(BowerProblemsProvider.class.getName());
    final FileChangeListener fileChangeListener = new FileChangeListener();
    final Project project;
    private final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
    private final BowerJson bowerJson;
    final BowerrcJson bowerrcJson;

    private BowerProblemsProvider(Project project) {
        this.project = project;
        FileObject projectDirectory = project.getProjectDirectory();
        this.bowerJson = new BowerJson(projectDirectory);
        this.bowerrcJson = new BowerrcJson(projectDirectory);
    }

    private static BowerProblemsProvider create(Project project) {
        BowerProblemsProvider bowerProblemsProvider = new BowerProblemsProvider(project);
        FileObject projectDirectory = project.getProjectDirectory();
        projectDirectory.addFileChangeListener((org.openide.filesystems.FileChangeListener)WeakListeners.create(org.openide.filesystems.FileChangeListener.class, (EventListener)((Object)bowerProblemsProvider.fileChangeListener), (Object)projectDirectory));
        bowerProblemsProvider.listenOnBowerComponentsDir();
        bowerProblemsProvider.bowerrcJson.addPropertyChangeListener(bowerProblemsProvider);
        return bowerProblemsProvider;
    }

    public static ProjectProblemsProvider forHtml5Project(Project project) {
        return BowerProblemsProvider.create(project);
    }

    public static ProjectProblemsProvider forPhpProject(Project project) {
        return BowerProblemsProvider.create(project);
    }

    public static ProjectProblemsProvider forWebProject(Project project) {
        return BowerProblemsProvider.create(project);
    }

    public static ProjectProblemsProvider forMavenProject(Project project) {
        return BowerProblemsProvider.create(project);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

            public Collection<? extends ProjectProblemsProvider.ProjectProblem> collectProblems() {
                ArrayList<ProjectProblemsProvider.ProjectProblem> currentProblems = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
                BowerProblemsProvider.this.checkDependencies(currentProblems);
                return currentProblems;
            }
        });
    }

    void checkDependencies(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        if (this.bowerInstallRequired()) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.BowerProblemsProvider_dependencies_none_title(), (String)Bundle.BowerProblemsProvider_dependencies_none_description(BowerUtils.getProjectDisplayName(this.project)), (ProjectProblemResolver)new ProjectProblemResolverImpl("bowerInstall", new BowerInstallResult()));
            currentProblems.add(problem);
        }
    }

    boolean bowerInstallRequired() {
        if (!this.bowerJson.exists()) {
            return false;
        }
        if (this.bowerrcJson.getBowerComponentsDir().isDirectory()) {
            return false;
        }
        return !this.bowerJson.getDependencies().isEmpty();
    }

    void listenOnBowerComponentsDir() {
        File projectDir = this.bowerJson.getFile().getParentFile();
        File bowerComponents = this.bowerrcJson.getBowerComponentsDir();
        if (bowerComponents.getParentFile().equals(projectDir)) {
            return;
        }
        try {
            FileUtil.addFileChangeListener((org.openide.filesystems.FileChangeListener)this.fileChangeListener, (File)FileUtil.normalizeFile((File)bowerComponents.getParentFile()));
        }
        catch (IllegalArgumentException exc) {
            LOGGER.log(Level.FINE, null, exc);
        }
    }

    void fireProblemsChanged() {
        this.problemsProviderSupport.fireProblemsChange();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("DIRECTORY".equals(evt.getPropertyName())) {
            this.listenOnBowerComponentsDir();
            this.fireProblemsChanged();
        }
    }

    private final class FileChangeListener
    extends FileChangeAdapter {
        private FileChangeListener() {
        }

        public void fileDataCreated(FileEvent fe) {
            this.processFileChange(fe.getFile().getNameExt());
        }

        public void fileChanged(FileEvent fe) {
            this.processFileChange(fe.getFile().getNameExt());
        }

        public void fileFolderCreated(FileEvent fe) {
            this.processFolderChange(fe.getFile().getNameExt());
        }

        public void fileDeleted(FileEvent fe) {
            this.processFolderChange(fe.getFile().getNameExt());
        }

        public void fileRenamed(FileRenameEvent fe) {
            String oldName = fe.getName() + (StringUtils.hasText(fe.getExt()) ? "." + fe.getExt() : "");
            this.processFileChange(fe.getFile().getNameExt());
            this.processFileChange(oldName);
            this.processFolderChange(fe.getFile().getNameExt());
            this.processFolderChange(oldName);
        }

        private void processFileChange(String fileName) {
            if ("bower.json".equals(fileName) || ".bowerrc".equals(fileName)) {
                BowerProblemsProvider.this.fireProblemsChanged();
            }
        }

        private void processFolderChange(String folderName) {
            if (BowerProblemsProvider.this.bowerrcJson.getBowerComponentsDir().getName().equals(folderName)) {
                BowerProblemsProvider.this.listenOnBowerComponentsDir();
                BowerProblemsProvider.this.fireProblemsChanged();
            }
        }
    }

    private static final class ProjectProblemResolverImpl
    implements ProjectProblemResolver {
        private final String ident;
        private final Future<ProjectProblemsProvider.Result> resolver;

        public ProjectProblemResolverImpl(String ident, Future<ProjectProblemsProvider.Result> resolver) {
            assert (ident != null);
            assert (resolver != null);
            this.ident = ident;
            this.resolver = resolver;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            return this.resolver;
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + Objects.hashCode(this.ident);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectProblemResolverImpl other = (ProjectProblemResolverImpl)obj;
            return Objects.equals(this.ident, other.ident);
        }
    }

    private final class BowerInstallResult
    implements Future<ProjectProblemsProvider.Result> {
        private Future<Integer> task;

        private BowerInstallResult() {
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            if (this.task == null) {
                return false;
            }
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public synchronized boolean isCancelled() {
            if (this.task == null) {
                return false;
            }
            return this.task.isCancelled();
        }

        @Override
        public synchronized boolean isDone() {
            if (this.task == null) {
                return false;
            }
            return this.task.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProjectProblemsProvider.Result get() throws InterruptedException, ExecutionException {
            try {
                this.getTask().get();
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (BowerProblemsProvider.this.bowerInstallRequired()) {
                BowerInstallResult bowerInstallResult = this;
                synchronized (bowerInstallResult) {
                    this.task = null;
                }
                return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED);
            }
            BowerProblemsProvider.this.fireProblemsChanged();
            return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
        }

        @Override
        public ProjectProblemsProvider.Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }

        public synchronized Future<Integer> getTask() {
            if (this.task == null) {
                BowerExecutable bower = BowerExecutable.getDefault(BowerProblemsProvider.this.project, true);
                if (bower != null) {
                    BowerUtils.logUsageBowerInstall();
                    this.task = bower.install(new String[0]);
                } else {
                    this.task = new DummyTask();
                }
            }
            return this.task;
        }
    }

    private static final class DummyTask
    implements Future<Integer> {
        private DummyTask() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            return -1;
        }

        @Override
        public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }
}

