/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class JFXPlatformUpdater {
    private static final Logger LOGGER = Logger.getLogger("javafx");
    private final Project prj;
    private final J2SEPropertyEvaluator eval;
    volatile PropertyChangeListener listener;
    volatile boolean updated = false;

    public JFXPlatformUpdater(Lookup lkp) {
        Parameters.notNull((CharSequence)"lkp", (Object)lkp);
        this.prj = (Project)lkp.lookup(Project.class);
        Parameters.notNull((CharSequence)"prj", (Object)this.prj);
        this.eval = (J2SEPropertyEvaluator)lkp.lookup(J2SEPropertyEvaluator.class);
        Parameters.notNull((CharSequence)"eval", (Object)this.eval);
    }

    public void updateFXPlatform() {
        try {
            JFXProjectUtils.updateClassPathExtension(this.prj);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Can't update project properties: {0}", ex);
        }
        this.updated = true;
        this.fireChange();
    }

    public void addListener(@NonNull PropertyChangeListener listener) {
        this.listener = listener;
    }

    public void removeListener() {
        this.listener = null;
    }

    public boolean hasUpdated() {
        return this.updated;
    }

    public void resetUpdated() {
        this.updated = false;
    }

    private void fireChange() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }
}

