/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes;

import java.awt.Image;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.modules.javaee.wildfly.config.WildflyMailSessionResource;
import org.netbeans.modules.javaee.wildfly.nodes.SimplePropertySupport;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyDatasourceNode;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

class WildflyMailSessionNode
extends AbstractNode {
    public WildflyMailSessionNode(String name, WildflyMailSessionResource mailSession, Lookup lookup) {
        super(Children.LEAF);
        this.setDisplayName(mailSession.getJndiName());
        this.setName(name);
        this.setShortDescription(mailSession.getJndiName());
        this.initProperties(mailSession);
    }

    protected final void initProperties(WildflyMailSessionResource mailSession) {
        if (mailSession.getJndiName() != null) {
            this.addProperty("JndiName", mailSession.getJndiName());
        }
        if (mailSession.getHostName() != null) {
            this.addProperty("Server", mailSession.getHostName());
        }
        this.addProperty("Port", mailSession.getPort());
        if (mailSession.getIsDebug() != null) {
            this.addProperty("Debug", mailSession.getIsDebug());
        }
        for (Map.Entry<String, String> property : mailSession.getConfiguration().entrySet()) {
            SimplePropertySupport ps = new SimplePropertySupport(property.getKey(), property.getValue(), property.getKey(), property.getKey());
            this.getSheet().get("properties").put((Node.Property)ps);
        }
    }

    private void addProperty(String name, String value) {
        String displayName = NbBundle.getMessage(WildflyDatasourceNode.class, (String)("LBL_Resources_MailSessions_Session_" + name));
        String description = NbBundle.getMessage(WildflyDatasourceNode.class, (String)("DESC_Resources_MailSessions_Session_" + name));
        SimplePropertySupport ps = new SimplePropertySupport(name, value, displayName, description);
        this.getSheet().get("properties").put((Node.Property)ps);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        this.setSheet(sheet);
        return sheet;
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(PropertiesAction.class)};
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/javaee/wildfly/resources/javamail.gif");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/javaee/wildfly/resources/javamail.gif");
    }
}

