/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.project.api.ant.ui.customizer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ui.CustomizerUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class LicensePanelSupport
implements CustomizerUtilities.LicensePanelContentHandler {
    public static final String LICENSE_NAME = "project.license";
    public static final String LICENSE_PATH = "project.licensePath";
    private String licenseName;
    private String licensePath;
    private String licenseContent;
    private PropertyEvaluator evaluator;
    private AntProjectHelper antHelper;

    public LicensePanelSupport(PropertyEvaluator evaluator, AntProjectHelper antHelper, String licensePath, String licenseName) {
        this.evaluator = evaluator;
        this.antHelper = antHelper;
        this.licensePath = licensePath;
        this.licenseName = licenseName;
        this.licenseContent = null;
    }

    public String getProjectLicenseLocation() {
        return this.licensePath;
    }

    public String getGlobalLicenseName() {
        return this.licenseName;
    }

    public FileObject resolveProjectLocation(@NonNull String path) {
        String evaluated = this.evaluator.evaluate(path);
        if (evaluated != null) {
            return this.antHelper.resolveFileObject(evaluated);
        }
        return null;
    }

    public void setProjectLicenseLocation(@NullAllowed String newLocation) {
        this.licensePath = newLocation;
    }

    public void setGlobalLicenseName(@NullAllowed String newName) {
        this.licenseName = newName;
    }

    public String getDefaultProjectLicenseLocation() {
        return "./nbproject/licenseheader.txt";
    }

    public void setProjectLicenseContent(@NullAllowed String text) {
        this.licenseContent = text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLicenseFile() throws IOException {
        if (this.licenseContent != null) {
            assert (this.licensePath != null);
            String evaluated = this.evaluator.evaluate(this.licensePath);
            assert (evaluated != null);
            File file = this.antHelper.resolveFile(evaluated);
            FileObject fo = !file.exists() ? FileUtil.createData((File)file) : FileUtil.toFileObject((File)file);
            try (OutputStream out = fo.getOutputStream();){
                FileUtil.copy((InputStream)new ByteArrayInputStream(this.licenseContent.getBytes()), (OutputStream)out);
            }
        }
    }

    public void updateProperties(EditableProperties projectProperties) {
        if (this.licensePath != null) {
            projectProperties.setProperty(LICENSE_PATH, this.licensePath);
        } else {
            projectProperties.remove((Object)LICENSE_PATH);
        }
        if (this.licenseName != null) {
            projectProperties.setProperty(LICENSE_NAME, this.licenseName);
        } else {
            projectProperties.remove((Object)LICENSE_NAME);
        }
    }
}

