/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.project.api.ant.ui.wizard;

import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.spi.java.project.support.PreferredProjectPlatform;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

final class J2eeVersionWarningPanel
extends JPanel {
    public static final String WARN_SET_JDK_15 = "warnSetJdk15";
    public static final String WARN_SET_JDK_6 = "warnSetJdk6";
    public static final String WARN_SET_JDK_7 = "warnSetJdk7";
    public static final String WARN_SET_JDK_8 = "warnSetJdk8";
    public static final String WARN_SET_SOURCE_LEVEL_15 = "warnSetSourceLevel15";
    public static final String WARN_SET_SOURCE_LEVEL_6 = "warnSetSourceLevel6";
    public static final String WARN_SET_SOURCE_LEVEL_7 = "warnSetSourceLevel7";
    public static final String WARN_SET_SOURCE_LEVEL_8 = "warnSetSourceLevel8";
    public static final String WARN_JDK_6_REQUIRED = "warnJdk6Required";
    public static final String WARN_JDK_7_REQUIRED = "warnJdk7Required";
    public static final String WARN_JDK_8_REQUIRED = "warnJdk8Required";
    private String warningType;
    private JLabel jLabel;

    public J2eeVersionWarningPanel(String warningType) {
        this.initComponents();
        this.setWarningType(warningType);
    }

    public String getWarningType() {
        return this.warningType;
    }

    public void setWarningType(String warningType) {
        String labelText = "";
        this.warningType = warningType;
        if (WARN_SET_JDK_15.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetJdk15");
        } else if (WARN_SET_SOURCE_LEVEL_15.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetSourceLevel15");
        } else if (WARN_SET_JDK_6.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetJdk6");
        } else if (WARN_SET_JDK_7.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetJdk7");
        } else if (WARN_SET_JDK_8.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetJdk8");
        } else if (WARN_SET_SOURCE_LEVEL_6.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetSourceLevel6");
        } else if (WARN_SET_SOURCE_LEVEL_7.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetSourceLevel7");
        } else if (WARN_SET_SOURCE_LEVEL_8.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetSourceLevel8");
        } else if (WARN_JDK_6_REQUIRED.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationJDK6");
        } else if (WARN_JDK_7_REQUIRED.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationJDK7");
        } else if (WARN_JDK_8_REQUIRED.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationJDK8");
        }
        this.jLabel.setText(labelText);
    }

    public String getSuggestedJavaPlatformName() {
        if (WARN_SET_JDK_15.equals(this.warningType)) {
            JavaPlatform[] javaPlatforms = J2eeVersionWarningPanel.getJavaPlatforms("1.5");
            return J2eeVersionWarningPanel.getPreferredPlatform(javaPlatforms).getDisplayName();
        }
        if (WARN_SET_JDK_6.equals(this.warningType)) {
            JavaPlatform[] javaPlatforms = J2eeVersionWarningPanel.getJavaPlatforms("1.6");
            return J2eeVersionWarningPanel.getPreferredPlatform(javaPlatforms).getDisplayName();
        }
        if (WARN_SET_JDK_7.equals(this.warningType)) {
            JavaPlatform[] javaPlatforms = J2eeVersionWarningPanel.getJavaPlatforms("1.7");
            return J2eeVersionWarningPanel.getPreferredPlatform(javaPlatforms).getDisplayName();
        }
        if (WARN_SET_JDK_8.equals(this.warningType)) {
            JavaPlatform[] javaPlatforms = J2eeVersionWarningPanel.getJavaPlatforms("1.8");
            return J2eeVersionWarningPanel.getPreferredPlatform(javaPlatforms).getDisplayName();
        }
        return JavaPlatform.getDefault().getDisplayName();
    }

    public Specification getSuggestedJavaPlatformSpecification() {
        if (WARN_SET_JDK_15.equals(this.warningType)) {
            JavaPlatform[] javaPlatforms = J2eeVersionWarningPanel.getJavaPlatforms("1.5");
            return J2eeVersionWarningPanel.getPreferredPlatform(javaPlatforms).getSpecification();
        }
        if (WARN_SET_JDK_6.equals(this.warningType)) {
            JavaPlatform[] javaPlatforms = J2eeVersionWarningPanel.getJavaPlatforms("1.6");
            return J2eeVersionWarningPanel.getPreferredPlatform(javaPlatforms).getSpecification();
        }
        if (WARN_SET_JDK_7.equals(this.warningType)) {
            JavaPlatform[] javaPlatforms = J2eeVersionWarningPanel.getJavaPlatforms("1.7");
            return J2eeVersionWarningPanel.getPreferredPlatform(javaPlatforms).getSpecification();
        }
        if (WARN_SET_JDK_8.equals(this.warningType)) {
            JavaPlatform[] javaPlatforms = J2eeVersionWarningPanel.getJavaPlatforms("1.8");
            return J2eeVersionWarningPanel.getPreferredPlatform(javaPlatforms).getSpecification();
        }
        return JavaPlatform.getDefault().getSpecification();
    }

    private static JavaPlatform getPreferredPlatform(@NullAllowed JavaPlatform[] platforms) {
        JavaPlatform pp = PreferredProjectPlatform.getPreferredPlatform((String)JavaPlatform.getDefault().getSpecification().getName());
        if (platforms == null) {
            return pp;
        }
        for (JavaPlatform jp : platforms) {
            if (!jp.equals(pp)) continue;
            return jp;
        }
        return platforms[0];
    }

    public static String findWarningType(Profile j2eeProfile, Set acceptableSourceLevels) {
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        SpecificationVersion version = defaultPlatform.getSpecification().getVersion();
        String sourceLevel = version.toString();
        if (j2eeProfile == Profile.JAVA_EE_5 && J2eeVersionWarningPanel.isAcceptableSourceLevel("1.5", sourceLevel, acceptableSourceLevels)) {
            return null;
        }
        if ((j2eeProfile == Profile.JAVA_EE_6_FULL || j2eeProfile == Profile.JAVA_EE_6_WEB) && J2eeVersionWarningPanel.isAcceptableSourceLevel("1.6", sourceLevel, acceptableSourceLevels)) {
            return null;
        }
        if ((j2eeProfile == Profile.JAVA_EE_7_FULL || j2eeProfile == Profile.JAVA_EE_7_WEB) && J2eeVersionWarningPanel.isAcceptableSourceLevel("1.7", sourceLevel, acceptableSourceLevels)) {
            return null;
        }
        if ((j2eeProfile == Profile.JAVA_EE_8_FULL || j2eeProfile == Profile.JAVA_EE_8_WEB) && J2eeVersionWarningPanel.isAcceptableSourceLevel("1.8", sourceLevel, acceptableSourceLevels)) {
            return null;
        }
        if (j2eeProfile == Profile.JAVA_EE_5) {
            JavaPlatform[] java15Platforms = J2eeVersionWarningPanel.getJavaPlatforms("1.5");
            if (java15Platforms.length > 0) {
                return WARN_SET_JDK_15;
            }
            return WARN_SET_SOURCE_LEVEL_15;
        }
        if (j2eeProfile == Profile.JAVA_EE_6_FULL || j2eeProfile == Profile.JAVA_EE_6_WEB) {
            JavaPlatform[] java16Platforms = J2eeVersionWarningPanel.getJavaPlatforms("1.6");
            if (java16Platforms.length > 0) {
                return WARN_SET_JDK_6;
            }
            if (J2eeVersionWarningPanel.canSetSourceLevel("1.6")) {
                return WARN_SET_SOURCE_LEVEL_6;
            }
            return WARN_JDK_6_REQUIRED;
        }
        if (j2eeProfile == Profile.JAVA_EE_7_FULL || j2eeProfile == Profile.JAVA_EE_7_WEB) {
            JavaPlatform[] java17Platforms = J2eeVersionWarningPanel.getJavaPlatforms("1.7");
            if (java17Platforms.length > 0) {
                return WARN_SET_JDK_7;
            }
            if (J2eeVersionWarningPanel.canSetSourceLevel("1.7")) {
                return WARN_SET_SOURCE_LEVEL_7;
            }
            return WARN_JDK_7_REQUIRED;
        }
        if (j2eeProfile == Profile.JAVA_EE_8_FULL || j2eeProfile == Profile.JAVA_EE_8_WEB) {
            JavaPlatform[] java18Platforms = J2eeVersionWarningPanel.getJavaPlatforms("1.8");
            if (java18Platforms.length > 0) {
                return WARN_SET_JDK_8;
            }
            if (J2eeVersionWarningPanel.canSetSourceLevel("1.8")) {
                return WARN_SET_SOURCE_LEVEL_8;
            }
            return WARN_JDK_8_REQUIRED;
        }
        return null;
    }

    private static boolean canSetSourceLevel(String sourceLevel) {
        SpecificationVersion spec = JavaPlatformManager.getDefault().getDefaultPlatform().getSpecification().getVersion();
        return spec.compareTo((Object)new SpecificationVersion(sourceLevel)) >= 0;
    }

    private static boolean isAcceptableSourceLevel(String minSourceLevel, String sourceLevel, Set acceptableSourceLevels) {
        if (minSourceLevel.equals(sourceLevel)) {
            return true;
        }
        SpecificationVersion minSpec = new SpecificationVersion(minSourceLevel);
        SpecificationVersion spec = new SpecificationVersion(sourceLevel);
        if (minSpec.compareTo((Object)spec) > 0) {
            return false;
        }
        return acceptableSourceLevels.contains(sourceLevel);
    }

    private static JavaPlatform[] getJavaPlatforms(String level) {
        return JavaPlatformManager.getDefault().getPlatforms(null, new Specification("J2SE", new SpecificationVersion(level)));
    }

    private void initComponents() {
        this.jLabel = new JLabel();
        this.jLabel.setText(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetJdk7"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel, -1, 275, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel));
    }
}

