/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.testrunner.ui.api;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.modules.gsf.testrunner.ui.api.CallstackFrameNode;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.ui.api.TestsuiteNode;
import org.netbeans.modules.java.testrunner.ui.api.Bundle;
import org.netbeans.modules.java.testrunner.ui.api.UIJavaUtils;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class JumpAction
extends AbstractAction {
    private static final RequestProcessor RP = new RequestProcessor(JumpAction.class);
    private final Node node;
    private final String callstackFrameInfo;
    private final String projectType;
    private final String testingFramework;

    public JumpAction(Node node, String callstackFrameInfo, String projectType, String testingFramework) {
        this.node = node;
        this.callstackFrameInfo = callstackFrameInfo;
        this.projectType = projectType;
        this.testingFramework = testingFramework;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                if (JumpAction.this.node instanceof TestsuiteNode) {
                    UIJavaUtils.openTestsuite((TestsuiteNode)JumpAction.this.node, JumpAction.this.projectType, JumpAction.this.testingFramework);
                } else if (JumpAction.this.node instanceof CallstackFrameNode) {
                    UIJavaUtils.openCallstackFrame(JumpAction.this.node, JumpAction.this.callstackFrameInfo, JumpAction.this.projectType, JumpAction.this.testingFramework);
                } else if (JumpAction.this.node instanceof TestMethodNode) {
                    if (((TestMethodNode)JumpAction.this.node).getTestcase().getTrouble() != null) {
                        UIJavaUtils.openCallstackFrame(JumpAction.this.node, "", JumpAction.this.projectType, JumpAction.this.testingFramework);
                    } else {
                        UIJavaUtils.openTestMethod((TestMethodNode)JumpAction.this.node, JumpAction.this.projectType, JumpAction.this.testingFramework);
                    }
                }
            }
        });
    }

    @Override
    public Object getValue(String key) {
        if (key.equals("Name")) {
            return Bundle.LBL_GotoSource();
        }
        return super.getValue(key);
    }

    public Node getNode() {
        return this.node;
    }
}

