/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.openjdk.common.BuildUtils;
import org.netbeans.modules.java.openjdk.project.JDKProject;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.openide.filesystems.FileObject;

public class FilterStandardProjects
implements ProjectFactory {
    private static final boolean BLOCK_LANGTOOLS_PROJECT = Boolean.getBoolean("nb.jdk.project.block.langtools");
    public static final String MSG_FILTER = "This project cannot be load while the NetBeans JDK project is open.";

    public boolean isProject(FileObject projectDirectory) {
        FileObject jdkRoot;
        return BuildUtils.getFileObject(projectDirectory, "nbproject/project.xml") != null && (jdkRoot = BuildUtils.getFileObject(projectDirectory, "../../..")) != null && (JDKProject.isJDKProject(jdkRoot) || BuildUtils.getFileObject(jdkRoot, "../modules.xml") != null) && projectDirectory.getParent().equals(BuildUtils.getFileObject(jdkRoot, "make/netbeans")) && "netbeans".equals(projectDirectory.getParent().getName());
    }

    public Project loadProject(FileObject projectDirectory, ProjectState state) throws IOException {
        String project2Repository;
        FileObject repository;
        if (!this.isProject(projectDirectory)) {
            return null;
        }
        if ("langtools".equals(projectDirectory.getNameExt())) {
            if (!BLOCK_LANGTOOLS_PROJECT) {
                return null;
            }
            repository = BuildUtils.getFileObject(projectDirectory, "../../../../langtools");
            project2Repository = "../..";
        } else {
            repository = BuildUtils.getFileObject(projectDirectory, "../../..");
            project2Repository = "";
        }
        if (repository != null) {
            for (Project prj : OpenProjects.getDefault().getOpenProjects()) {
                if (!repository.equals(BuildUtils.getFileObject(prj.getProjectDirectory(), project2Repository))) continue;
                throw new IOException(MSG_FILTER);
            }
        }
        return null;
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
    }
}

