/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.mx.project.suitepy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.modules.java.mx.project.suitepy.MxSuite;

final class Parse {
    private Parse() {
    }

    static MxSuite parse(URL u) throws IOException {
        if (u == null) {
            return null;
        }
        return new Parse().parseImpl(u);
    }

    private MxSuite parseImpl(URL u) throws IOException {
        Object value;
        StringBuilder sb = new StringBuilder();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream()));){
            String line;
            while ((line = r.readLine()) != null) {
                line = line.replaceAll("(\\s*)#.*", "$1");
                sb.append(line).append("\n");
            }
        }
        String text = Parse.jsonify(sb.toString());
        try {
            JSONParser p = new JSONParser();
            value = p.parse(text);
        }
        catch (ParseException ex) {
            throw new IOException("Cannot parse " + u, ex);
        }
        Value suite = new Value(value);
        return Meta.create(MxSuite.class).cast(suite);
    }

    private static String jsonify(String content) {
        String text = content.replaceFirst("\\s*suite *= *\\{", "{");
        text = text.replace("True", "true").replace("False", "false");
        text = text.replaceAll(",\\s*(\\]|\\})", "$1");
        text = Parse.replaceQuotes("\"\"\"", text);
        text = Parse.replaceQuotes("'''", text);
        text = Parse.replaceQuotes("'", text);
        return text;
    }

    private static String replaceQuotes(String quoteSeq, String imports) {
        Matcher m = Pattern.compile(quoteSeq + "(.*?)" + quoteSeq, 32).matcher(imports);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "\"");
            sb.append(m.group(1).replace("\n", "\\n"));
            sb.append("\"");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    static List<String> objectKeys(JSONObject o) {
        return new ArrayList<String>(o.keySet());
    }

    private final class Value {
        private final Object obj;
        private final Map<String, Value> members = new HashMap<String, Value>();
        private Number arraySize;
        private String asString;

        Value(Object obj) {
            this.obj = obj;
        }

        Value getMember(String key) {
            Value value = this.members.get(key);
            if (value == null && this.obj instanceof JSONObject) {
                value = new Value(((JSONObject)this.obj).get((Object)key));
                this.members.put(key, value);
            }
            return value;
        }

        Value getArrayElement(int index) {
            if (this.obj instanceof List) {
                return new Value(((List)this.obj).get(index));
            }
            return this.getMember("" + index);
        }

        int getArraySize() {
            if (this.arraySize == null) {
                this.arraySize = ((JSONArray)this.obj).size();
            }
            return this.arraySize.intValue();
        }

        Iterable<String> getMemberKeys() {
            List<String> keys = Parse.objectKeys((JSONObject)this.obj);
            Value names = new Value(keys);
            int namesCount = keys.size();
            ArrayList<String> arrOfNames = new ArrayList<String>(namesCount);
            for (int i = 0; i < namesCount; ++i) {
                arrOfNames.add(names.getArrayElement(i).asString());
            }
            return arrOfNames;
        }

        String asString() {
            if (this.asString == null) {
                this.asString = this.obj.toString();
            }
            return this.asString;
        }

        boolean hasMember(String key) {
            return this.getMember((String)key).obj != null;
        }
    }

    private static final class HandlerList<T>
    extends AbstractList<T> {
        private final Value value;
        private final Meta<T> elementType;

        HandlerList(Value value, Meta<T> elementType) {
            this.value = value;
            this.elementType = elementType;
        }

        @Override
        public T get(int index) {
            return this.elementType.cast(this.value.getArrayElement(index));
        }

        @Override
        public int size() {
            return this.value.getArraySize();
        }
    }

    private static final class HandlerMap
    extends AbstractMap<String, Object> {
        private final Value value;
        private final Meta<?> keyType;
        private final Meta<?> valueType;

        HandlerMap(Value result, Meta<?> keyType, Meta<?> valueType) {
            this.value = result;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            TreeSet<Map.Entry<String, Object>> set = new TreeSet<Map.Entry<String, Object>>();
            for (String key : this.value.getMemberKeys()) {
                set.add(new HE(key));
            }
            return set;
        }

        private final class HE
        implements Map.Entry<String, Object>,
        Comparable<HE> {
            final String key;

            public HE(String key) {
                this.key = key;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public Object getValue() {
                return HandlerMap.this.valueType.cast(HandlerMap.this.value.getMember(this.key));
            }

            @Override
            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int compareTo(HE o) {
                return this.key.compareTo(o.key);
            }
        }
    }

    private static final class Meta<T> {
        final Class<T> clazz;
        final Type type;

        Meta(Class<T> clazz, Type type) {
            this.clazz = clazz;
            this.type = type;
        }

        public static <T> Meta<T> create(Class<T> clazz) {
            return new Meta<T>(clazz, clazz);
        }

        public static Meta<?> create(Type type) {
            if (type instanceof Class) {
                return Meta.create((Class)type);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                return new Meta((Class)pt.getRawType(), pt);
            }
            throw new IllegalStateException();
        }

        public Meta<?> getComponent(int index) {
            if (this.type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)this.type;
                Type ct = pt.getActualTypeArguments()[index];
                return new Meta<T>((Class)ct, ct);
            }
            TypeVariable<Class<T>> ct = this.clazz.getTypeParameters()[index];
            throw new IllegalStateException("" + ct);
        }

        boolean isInterface() {
            return this.clazz.isInterface();
        }

        T cast(Value result) {
            Object val;
            if (this.clazz == Map.class) {
                val = new HandlerMap(result, this.getComponent(0), this.getComponent(1));
            } else if (this.clazz == List.class) {
                val = new HandlerList(result, this.getComponent(0));
            } else if (this.clazz.isInterface()) {
                val = Proxy.newProxyInstance(this.clazz.getClassLoader(), new Class[]{this.clazz}, (InvocationHandler)new Handler(result));
            } else {
                if (this.clazz == Boolean.TYPE) {
                    Boolean asBoolean = Boolean.valueOf(result.asString());
                    return (T)asBoolean;
                }
                val = result.asString();
            }
            return this.clazz.cast(val);
        }

        boolean isMap() {
            return this.clazz == Map.class;
        }

        boolean isList() {
            return this.clazz == List.class;
        }
    }

    private static final class Handler
    implements InvocationHandler {
        private final Value value;

        public Handler(Value value) {
            this.value = value;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this.value, args);
            }
            Meta<?> type = Meta.create(method.getGenericReturnType());
            String key = method.getName();
            if (!Handler.hasMember(this.value, key)) {
                if (type.isMap()) {
                    return Collections.emptyMap();
                }
                if (type.isList()) {
                    return Collections.emptyList();
                }
                if (type.clazz == Boolean.TYPE) {
                    return false;
                }
                return null;
            }
            Value result = this.value.getMember(key);
            return type.cast(result);
        }

        private static boolean hasMember(Value value, String key) {
            return value.hasMember(key);
        }
    }
}

