/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.mx.project;

import java.util.logging.Level;
import org.openide.util.Exceptions;

public final class Compliance {
    final int max;
    final int min;

    private Compliance(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public static Compliance exact(int version) {
        return new Compliance(version, version);
    }

    public static Compliance plus(int version) {
        return new Compliance(version, Integer.MAX_VALUE);
    }

    public static Compliance range(int min, int max) {
        return new Compliance(min, max);
    }

    public static Compliance parse(String spec) {
        int version;
        boolean plus;
        if (spec == null) {
            return Compliance.plus(8);
        }
        if (spec.startsWith("1.")) {
            spec = spec.substring(2);
        }
        if (spec.endsWith("+")) {
            plus = true;
            spec = spec.substring(0, spec.length() - 1);
        } else {
            plus = false;
            int dots = spec.indexOf("..");
            if (dots != -1) {
                int low = Integer.parseInt(spec.substring(0, dots));
                int high = Integer.parseInt(spec.substring(dots + 2));
                return Compliance.range(low, high);
            }
        }
        int comma = spec.indexOf(",");
        if (comma != -1) {
            spec = spec.substring(0, comma);
        }
        if (spec.endsWith("-loom")) {
            spec = spec.substring(0, spec.length() - 5);
        }
        try {
            version = Integer.parseInt(spec);
        }
        catch (NumberFormatException numberFormatException) {
            Exceptions.attachSeverity((Throwable)numberFormatException, (Level)Level.INFO);
            Exceptions.printStackTrace((Throwable)numberFormatException);
            return Compliance.plus(8);
        }
        return plus ? Compliance.plus(version) : Compliance.exact(version);
    }

    public boolean includes(int version) {
        return this.min <= version && version <= this.max;
    }

    public String toString() {
        if (this.max == Integer.MAX_VALUE) {
            return this.min + "+";
        }
        if (this.min == this.max) {
            return "" + this.min;
        }
        return this.min + ".." + this.max;
    }

    String getSourceLevel() {
        if (this.min == 8) {
            return "1.8";
        }
        return "" + this.min;
    }

    public static interface Provider {
        public Compliance getCompliance();
    }
}

