/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.java.lsp.server.text.TextDocumentServiceImpl;
import org.netbeans.modules.java.lsp.server.workspace.WorkspaceServiceImpl;
import org.netbeans.spi.sendopts.Arg;
import org.netbeans.spi.sendopts.ArgsProcessor;
import org.netbeans.spi.sendopts.Description;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class Server
implements ArgsProcessor {
    @Arg(longName="start-java-language-server")
    @Description(shortDescription="whatever")
    public boolean enable;
    static final String INDEXING_COMPLETED = "Indexing completed.";

    public void process(Env env) throws CommandException {
        try {
            Server.run(env.getInputStream(), env.getOutputStream());
        }
        catch (Exception ex) {
            throw (CommandException)new CommandException(1).initCause((Throwable)ex);
        }
    }

    private static void run(InputStream in, OutputStream out) throws Exception {
        LanguageServerImpl server = new LanguageServerImpl();
        Launcher serverLauncher = LSPLauncher.createServerLauncher((LanguageServer)server, (InputStream)in, (OutputStream)out);
        server.connect((LanguageClient)serverLauncher.getRemoteProxy());
        serverLauncher.startListening();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(100000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static class LanguageServerImpl
    implements LanguageServer,
    LanguageClientAware {
        private static final Logger LOG = Logger.getLogger(LanguageServerImpl.class.getName());
        private LanguageClient client;
        private final TextDocumentService textDocumentService = new TextDocumentServiceImpl();

        private LanguageServerImpl() {
        }

        public CompletableFuture<InitializeResult> initialize(InitializeParams init) {
            ArrayList<FileObject> projectCandidates = new ArrayList<FileObject>();
            List folders = init.getWorkspaceFolders();
            if (folders != null) {
                for (WorkspaceFolder w : folders) {
                    try {
                        projectCandidates.add(TextDocumentServiceImpl.fromUri(w.getUri()));
                    }
                    catch (MalformedURLException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                }
            } else {
                String root = init.getRootUri();
                if (root != null) {
                    try {
                        projectCandidates.add(TextDocumentServiceImpl.fromUri(root));
                    }
                    catch (MalformedURLException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                }
            }
            ArrayList<Project> projects = new ArrayList<Project>();
            for (FileObject candidate : projectCandidates) {
                Project prj = FileOwnerQuery.getOwner((FileObject)candidate);
                if (prj == null) continue;
                projects.add(prj);
            }
            try {
                Class.forName("org.netbeans.modules.project.ui.OpenProjectList", false, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).getDeclaredMethod("waitProjectsFullyOpen", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            OpenProjects.getDefault().open(projects.toArray(new Project[0]), false);
            try {
                OpenProjects.getDefault().openProjects().get();
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new IllegalStateException(ex);
            }
            for (Project prj : projects) {
                ProjectUtils.getSources((Project)prj).getSourceGroups("generic");
            }
            try {
                JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY), (FileObject[])new FileObject[0]).runWhenScanFinished(cc -> this.client.showMessage(new MessageParams(MessageType.Info, Server.INDEXING_COMPLETED)), true);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            ServerCapabilities capabilities = new ServerCapabilities();
            capabilities.setTextDocumentSync(TextDocumentSyncKind.Incremental);
            CompletionOptions completionOptions = new CompletionOptions();
            completionOptions.setResolveProvider(Boolean.valueOf(true));
            capabilities.setCompletionProvider(completionOptions);
            capabilities.setCodeActionProvider(Boolean.valueOf(true));
            capabilities.setDocumentSymbolProvider(Boolean.valueOf(true));
            capabilities.setDefinitionProvider(Boolean.valueOf(true));
            capabilities.setDocumentHighlightProvider(Boolean.valueOf(true));
            return CompletableFuture.completedFuture(new InitializeResult(capabilities));
        }

        public CompletableFuture<Object> shutdown() {
            return CompletableFuture.completedFuture(null);
        }

        public void exit() {
            System.exit(1);
        }

        public TextDocumentService getTextDocumentService() {
            return this.textDocumentService;
        }

        public WorkspaceService getWorkspaceService() {
            return new WorkspaceServiceImpl();
        }

        public void connect(LanguageClient client) {
            this.client = client;
            ((LanguageClientAware)this.getTextDocumentService()).connect(client);
        }
    }

    public static class OptionProcessorImpl
    extends OptionProcessor {
        protected Set<Option> getOptions() {
            return new HashSet<Option>(Arrays.asList(Option.withoutArgument((char)'\u0000', (String)"--start-java-language-server")));
        }

        protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
            try {
                Server.run(env.getInputStream(), env.getOutputStream());
            }
            catch (Exception ex) {
                throw (CommandException)new CommandException(1).initCause((Throwable)ex);
            }
        }
    }
}

