/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.project.ui.ProjectUISupport;
import org.netbeans.modules.java.api.common.project.ui.customizer.MainClassChooser;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.api.J2SECategoryExtensionProvider;
import org.netbeans.modules.java.j2seproject.api.J2SERunConfigProvider;
import org.netbeans.modules.java.j2seproject.api.J2SERuntimePlatformProvider;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    public static final Logger log = Logger.getLogger(CustomizerRun.class.getName());
    private J2SEProject project;
    private DataSource[] data;
    private Map<String, Map<String, String>> configs;
    J2SEProjectProperties uiProperties;
    private List<J2SECategoryExtensionProvider> compProviders = new LinkedList<J2SECategoryExtensionProvider>();
    private J2SERunConfigProvider compProviderDeprecated;
    private int nextExtensionYPos;
    private JComboBox configCombo;
    private JButton configDel;
    private JLabel configLabel;
    private JButton configNew;
    private JPanel configPanel;
    private JSeparator configSep;
    private JButton customizeOptionsButton;
    private JPanel extPanel;
    private JButton jButtonMainClass;
    private JButton jButtonManagePlatforms;
    private JButton jButtonWorkingDirectoryBrowse;
    private JLabel jLabelArgs;
    private JLabel jLabelMainClass;
    private JLabel jLabelVMOptions;
    private JLabel jLabelVMOptionsExample;
    private JLabel jLabelWorkingDirectory;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldArgs;
    private JTextField jTextFieldMainClass;
    private JTextArea jTextVMOptions;
    private JTextField jTextWorkingDirectory;
    private JLabel lblPlatform;
    private JPanel mainPanel;
    private JComboBox platform;

    public CustomizerRun(J2SEProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.initComponents();
        this.project = uiProperties.getProject();
        this.nextExtensionYPos = 0;
        this.compProviderDeprecated = (J2SERunConfigProvider)Lookup.getDefault().lookup(J2SERunConfigProvider.class);
        this.initExtPanel(this.project);
        for (J2SECategoryExtensionProvider compProvider : this.project.getLookup().lookupAll(J2SECategoryExtensionProvider.class)) {
            if (compProvider.getCategory() != J2SECategoryExtensionProvider.ExtensibleCategory.RUN || !this.addExtPanel(this.project, compProvider, this.nextExtensionYPos)) continue;
            this.compProviders.add(compProvider);
            ++this.nextExtensionYPos;
        }
        this.addPanelFiller(this.nextExtensionYPos);
        this.configs = uiProperties.RUN_CONFIGS;
        this.updatePlatformsList();
        this.data = new DataSource[]{new ComboDataSource("platform.runtime", this.lblPlatform, this.platform, this.configCombo, this.configs), new TextDataSource("main.class", this.jLabelMainClass, this.jTextFieldMainClass, this.configCombo, this.configs), new TextDataSource("application.args", this.jLabelArgs, this.jTextFieldArgs, this.configCombo, this.configs), new TextDataSource("run.jvmargs", this.jLabelVMOptions, this.jTextVMOptions, this.configCombo, this.configs), new TextDataSource("work.dir", this.jLabelWorkingDirectory, this.jTextWorkingDirectory, this.configCombo, this.configs)};
        this.configChanged(uiProperties.activeConfig);
        this.configCombo.setRenderer(new ConfigListCellRenderer());
        this.jButtonMainClass.addActionListener(new MainClassListener(this.project.getSourceRoots(), this.jTextFieldMainClass));
        ListDataListener currentSourceLevelListener = new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                PlatformKey currentPlatform = (PlatformKey)CustomizerRun.this.platform.getSelectedItem();
                CustomizerRun.this.platform.setSelectedIndex(0);
                List updatedPlatforms = CustomizerRun.this.updatePlatformsList();
                if (updatedPlatforms.contains(currentPlatform)) {
                    CustomizerRun.this.platform.setSelectedItem(currentPlatform);
                }
            }
        };
        uiProperties.JAVAC_SOURCE_MODEL.addListDataListener(currentSourceLevelListener);
        uiProperties.JAVAC_PROFILE_MODEL.addListDataListener(currentSourceLevelListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    private void initComponents() {
        this.configSep = new JSeparator();
        this.configPanel = new JPanel();
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.configNew = new JButton();
        this.configDel = new JButton();
        this.mainPanel = new JPanel();
        this.jLabelMainClass = new JLabel();
        this.jTextFieldMainClass = new JTextField();
        this.jButtonMainClass = new JButton();
        this.jLabelArgs = new JLabel();
        this.jTextFieldArgs = new JTextField();
        this.jLabelWorkingDirectory = new JLabel();
        this.jTextWorkingDirectory = new JTextField();
        this.jButtonWorkingDirectoryBrowse = new JButton();
        this.jLabelVMOptions = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextVMOptions = new JTextArea();
        this.jLabelVMOptionsExample = new JLabel();
        this.customizeOptionsButton = new JButton();
        this.lblPlatform = new JLabel();
        this.platform = new JComboBox();
        this.jButtonManagePlatforms = new JButton();
        this.extPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.configSep, gridBagConstraints);
        this.configPanel.setLayout(new GridBagLayout());
        this.configLabel.setLabelFor(this.configCombo);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.configPanel.add((Component)this.configLabel, gridBagConstraints);
        this.configLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizerRun_Cfg"));
        this.configCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        this.configCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.configNew, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew"));
        this.configNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configNew, gridBagConstraints);
        this.configNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizerRun_NewCfg"));
        Mnemonics.setLocalizedText((AbstractButton)this.configDel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configDelete"));
        this.configDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configDelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configDel, gridBagConstraints);
        this.configDel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizerRun_DeleteCfg"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.configPanel, gridBagConstraints);
        this.mainPanel.setLayout(new GridBagLayout());
        this.jLabelMainClass.setLabelFor(this.jTextFieldMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.jLabelMainClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.mainPanel.add((Component)this.jTextFieldMainClass, gridBagConstraints);
        this.jTextFieldMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jTextFieldMainClass"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.mainPanel.add((Component)this.jButtonMainClass, gridBagConstraints);
        this.jButtonMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jButtonMainClass"));
        this.jLabelArgs.setLabelFor(this.jTextFieldArgs);
        Mnemonics.setLocalizedText((JLabel)this.jLabelArgs, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Args_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.mainPanel.add((Component)this.jLabelArgs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.mainPanel.add((Component)this.jTextFieldArgs, gridBagConstraints);
        this.jTextFieldArgs.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jTextFieldArgs"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelWorkingDirectory, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.jLabelWorkingDirectory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.mainPanel.add((Component)this.jTextWorkingDirectory, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/java/j2seproject/ui/customizer/Bundle");
        this.jTextWorkingDirectory.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizeRun_Run_Working_Directory "));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonWorkingDirectoryBrowse, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory_Browse"));
        this.jButtonWorkingDirectoryBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.jButtonWorkingDirectoryBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.mainPanel.add((Component)this.jButtonWorkingDirectoryBrowse, gridBagConstraints);
        this.jButtonWorkingDirectoryBrowse.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizeRun_Run_Working_Directory_Browse"));
        this.jLabelVMOptions.setLabelFor(this.jTextVMOptions);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptions, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.jLabelVMOptions, gridBagConstraints);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jTextVMOptions.setColumns(20);
        this.jTextVMOptions.setLineWrap(true);
        this.jTextVMOptions.setRows(5);
        this.jTextVMOptions.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                CustomizerRun.this.jTextVMOptionsKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextVMOptions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.mainPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelVMOptionsExample.setLabelFor(this.jTextFieldMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptionsExample, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options_Example"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.mainPanel.add((Component)this.jLabelVMOptionsExample, gridBagConstraints);
        this.jLabelVMOptionsExample.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_CustomizeRun_Run_VM_Options_Example"));
        Mnemonics.setLocalizedText((AbstractButton)this.customizeOptionsButton, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options_JButton"));
        this.customizeOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.customizeVMOptionsByDialog(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.mainPanel.add((Component)this.customizeOptionsButton, gridBagConstraints);
        this.customizeOptionsButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"AN_CustomizeRun_Run_VM_Options_JButton"));
        this.customizeOptionsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizeRun_Run_VM_Options_Customize"));
        this.lblPlatform.setLabelFor(this.platform);
        Mnemonics.setLocalizedText((JLabel)this.lblPlatform, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_RuntimePlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.lblPlatform, gridBagConstraints);
        this.platform.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.platform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.platformActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.mainPanel.add((Component)this.platform, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonManagePlatforms, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ManagePlatforms"));
        this.jButtonManagePlatforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.jButtonManagePlatformsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.mainPanel.add((Component)this.jButtonManagePlatforms, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.extPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.extPanel, gridBagConstraints);
    }

    private List<PlatformKey> updatePlatformsList() {
        ArrayList<PlatformKey> platformList = new ArrayList<PlatformKey>();
        SpecificationVersion targetLevel = this.getProjectTargetLevel();
        SourceLevelQuery.Profile targetProfile = this.getProjectProfile();
        if (targetLevel != null && targetProfile != null) {
            for (J2SERuntimePlatformProvider rpt : this.project.getLookup().lookupAll(J2SERuntimePlatformProvider.class)) {
                for (JavaPlatform javaPlatform : rpt.getPlatformType(targetLevel, targetProfile)) {
                    platformList.add(PlatformKey.create(javaPlatform));
                }
            }
            Collections.sort(platformList);
        }
        platformList.add(0, PlatformKey.createDefault());
        DefaultComboBoxModel<PlatformKey> model = new DefaultComboBoxModel<PlatformKey>(platformList.toArray(new PlatformKey[0]));
        this.platform.setModel(model);
        return platformList;
    }

    @CheckForNull
    private SpecificationVersion getProjectTargetLevel() {
        Object key = this.uiProperties.JAVAC_SOURCE_MODEL.getSelectedItem();
        return key == null ? null : PlatformUiSupport.getSourceLevel((Object)key);
    }

    @CheckForNull
    private SourceLevelQuery.Profile getProjectProfile() {
        Object key = this.uiProperties.JAVAC_PROFILE_MODEL.getSelectedItem();
        return key == null ? null : PlatformUiSupport.getProfile((Object)key);
    }

    @Deprecated
    private void initExtPanel(Project p) {
        J2SERunConfigProvider.ConfigChangeListener ccl;
        JComponent comp;
        if (this.compProviderDeprecated != null && (comp = this.compProviderDeprecated.createComponent(p, ccl = new J2SERunConfigProvider.ConfigChangeListener(){

            @Override
            public void propertiesChanged(Map<String, String> updates) {
                Map m = (Map)CustomizerRun.this.configs.get(CustomizerRun.this.uiProperties.activeConfig);
                m.putAll(updates);
            }
        })) != null) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = this.nextExtensionYPos++;
            constraints.weightx = 1.0;
            this.extPanel.add((Component)comp, constraints);
        }
    }

    private boolean addExtPanel(Project p, J2SECategoryExtensionProvider compProvider, int gridY) {
        J2SECategoryExtensionProvider.ConfigChangeListener ccl;
        JComponent comp;
        if (compProvider != null && (comp = compProvider.createComponent(p, ccl = new J2SECategoryExtensionProvider.ConfigChangeListener(){

            @Override
            public void propertiesChanged(Map<String, String> updates) {
                Map m = (Map)CustomizerRun.this.configs.get(CustomizerRun.this.uiProperties.activeConfig);
                m.putAll(updates);
            }
        })) != null) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = gridY;
            constraints.weightx = 1.0;
            this.extPanel.add((Component)comp, constraints);
            return true;
        }
        return false;
    }

    private void addPanelFiller(int gridY) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = gridY;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.extPanel.add((Component)new Box.Filler(new Dimension(), new Dimension(), new Dimension(10000, 10000)), constraints);
    }

    private boolean createNewConfiguration(boolean platformChanged) {
        DialogDescriptor d = new DialogDescriptor((Object)new CreateConfigurationPanel(platformChanged), NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
            return false;
        }
        String name = ((CreateConfigurationPanel)d.getMessage()).getConfigName();
        String config = name.replaceAll("[^a-zA-Z0-9_.-]", "_");
        if (config.trim().length() == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.empty", (Object)config), 2));
            return false;
        }
        if (this.configs.get(config) != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.duplicate", (Object)config), 2));
            return false;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        if (!name.equals(config)) {
            m.put("$label", name);
        }
        this.configs.put(config, m);
        this.configChanged(config);
        this.uiProperties.activeConfig = config;
        return true;
    }

    private void configDelActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        assert (config != null);
        this.configs.put(config, null);
        this.configChanged(null);
        this.uiProperties.activeConfig = null;
    }

    private void configNewActionPerformed(ActionEvent evt) {
        this.createNewConfiguration(false);
    }

    private void configComboActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        if (config.length() == 0) {
            config = null;
            this.platform.setSelectedIndex(0);
        }
        this.configChanged(config);
        this.uiProperties.activeConfig = config;
    }

    private void jButtonWorkingDirectoryBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        String workDir = this.jTextWorkingDirectory.getText();
        if (workDir.equals("")) {
            workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getAbsolutePath();
        }
        chooser.setSelectedFile(new File(workDir));
        chooser.setDialogTitle(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory_Browse_Title"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.jTextWorkingDirectory.setText(file.getAbsolutePath());
        }
    }

    private void customizeVMOptionsByDialog(ActionEvent evt) {
        String origin = this.jTextVMOptions.getText();
        try {
            String result = ProjectUISupport.showVMOptionCustomizer((Window)SwingUtilities.getWindowAncestor(this), (String)origin);
            this.jTextVMOptions.setText(result);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot parse vm options.", e);
        }
    }

    private void jButtonManagePlatformsActionPerformed(ActionEvent evt) {
        PlatformKey currentPlatform = (PlatformKey)this.platform.getSelectedItem();
        this.platform.setSelectedIndex(0);
        JavaPlatform jp = ((PlatformKey)this.platform.getSelectedItem()).getPlatform();
        PlatformsCustomizer.showCustomizer((JavaPlatform)jp);
        List<PlatformKey> updatedPlatforms = this.updatePlatformsList();
        if (updatedPlatforms.contains(currentPlatform)) {
            this.platform.setSelectedItem(currentPlatform);
        }
    }

    private void platformActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        PlatformKey currentPlatform = (PlatformKey)this.platform.getSelectedItem();
        String currentPlatformName = ((PlatformKey)this.platform.getSelectedItem()).displayName;
        if (config.isEmpty() && !currentPlatformName.equals(NbBundle.getMessage(CustomizerRun.class, (String)"TXT_ActivePlatform"))) {
            this.platform.setSelectedIndex(0);
            if (this.createNewConfiguration(true)) {
                this.platform.setSelectedItem(currentPlatform);
            }
        }
    }

    private void jTextVMOptionsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            evt.consume();
        }
        if (evt.getKeyCode() == 9) {
            if (evt.getModifiers() > 0) {
                this.jTextVMOptions.transferFocusBackward();
            } else {
                this.jTextVMOptions.transferFocus();
            }
            evt.consume();
        }
    }

    private void configChanged(String activeConfig) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("");
        TreeSet<String> alphaConfigs = new TreeSet<String>(new Comparator<String>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(String s1, String s2) {
                return this.coll.compare(this.label(s1), this.label(s2));
            }

            private String label(String c) {
                Map m = (Map)CustomizerRun.this.configs.get(c);
                String label = (String)m.get("$label");
                return label != null ? label : c;
            }
        });
        for (Map.Entry<String, Map<String, String>> entry : this.configs.entrySet()) {
            String config = entry.getKey();
            if (config == null || entry.getValue() == null) continue;
            alphaConfigs.add(config);
        }
        for (String c : alphaConfigs) {
            model.addElement(c);
        }
        this.configCombo.setModel(model);
        this.configCombo.setSelectedItem(activeConfig != null ? activeConfig : "");
        Map<String, String> m = this.configs.get(activeConfig);
        if (m != null) {
            if (this.compProviderDeprecated != null) {
                this.compProviderDeprecated.configUpdated(m);
            }
            for (J2SECategoryExtensionProvider compProvider : this.compProviders) {
                compProvider.configUpdated(m);
            }
            for (DataSource ds : this.data) {
                ds.update(activeConfig);
            }
        }
        this.configDel.setEnabled(activeConfig != null);
    }

    private static class CreateConfigurationPanel
    extends JPanel {
        private JLabel defaultConfigPlatformMsg = new JLabel();
        private JLabel configNameLabel = new JLabel();
        private JTextField configName = new JTextField();

        public CreateConfigurationPanel(boolean showDefaultConfigMsg) {
            Mnemonics.setLocalizedText((JLabel)this.defaultConfigPlatformMsg, (String)NbBundle.getMessage(CustomizerRun.class, (String)"TXT_DefaultConfigPlatformChange"));
            Mnemonics.setLocalizedText((JLabel)this.configNameLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.prompt"));
            this.configNameLabel.setLabelFor(this.configName);
            this.defaultConfigPlatformMsg.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/j2seproject/ui/resources/info.png")));
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.configNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.configName, -1, 200, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.defaultConfigPlatformMsg).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.defaultConfigPlatformMsg).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configName, -2, -1, -2).addComponent(this.configNameLabel))));
            this.defaultConfigPlatformMsg.setVisible(showDefaultConfigMsg);
        }

        public String getConfigName() {
            return this.configName.getText();
        }
    }

    private static class ComboDataSource
    extends DataSource {
        private final JComboBox<PlatformKey> combo;

        ComboDataSource(@NonNull String propName, @NonNull JLabel label, @NonNull JComboBox<PlatformKey> combo, @NonNull JComboBox<?> configCombo, @NonNull Map<String, Map<String, String>> configs) {
            super(propName, label, configCombo, configs);
            Parameters.notNull((CharSequence)"combo", combo);
            this.combo = combo;
            this.combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    this.changed(this.getPropertyValue());
                }
            });
            this.updateFont(this.getPropertyValue());
        }

        @Override
        final String getPropertyValue() {
            return ((PlatformKey)this.combo.getSelectedItem()).getPlatformAntName();
        }

        @Override
        void update(String activeConfig) {
            String antName = this.getPropertyValue(activeConfig, this.getPropertyName());
            if (antName == null) {
                antName = "";
            }
            ComboBoxModel<PlatformKey> model = this.combo.getModel();
            PlatformKey active = null;
            PlatformKey project = null;
            for (int i = 0; i < model.getSize(); ++i) {
                PlatformKey pk = (PlatformKey)model.getElementAt(i);
                String pkn = pk.getPlatformAntName();
                if (antName.equals(pkn)) {
                    active = pk;
                    break;
                }
                if (!pkn.isEmpty()) continue;
                project = pk;
            }
            if (active == null) {
                active = project;
            }
            this.combo.setSelectedItem(active);
        }
    }

    private static class TextDataSource
    extends DataSource {
        private final JTextComponent textComp;

        TextDataSource(@NonNull String propName, @NonNull JLabel label, final @NonNull JTextComponent textComp, @NonNull JComboBox<?> configCombo, @NonNull Map<String, Map<String, String>> configs) {
            super(propName, label, configCombo, configs);
            Parameters.notNull((CharSequence)"textComp", (Object)textComp);
            this.textComp = textComp;
            this.textComp.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changed(textComp.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changed(textComp.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            this.updateFont(textComp.getText());
        }

        @Override
        String getPropertyValue() {
            return this.textComp.getText();
        }

        @Override
        void update(@NullAllowed String activeConfig) {
            this.textComp.setText(this.getPropertyValue(activeConfig, this.getPropertyName()));
        }
    }

    private static abstract class DataSource {
        private final String propName;
        private final JLabel label;
        private final JComboBox<?> configCombo;
        private final Map<String, Map<String, String>> configs;
        private final Font basefont;
        private final Font boldfont;

        DataSource(@NonNull String propName, @NonNull JLabel label, @NonNull JComboBox<?> configCombo, @NonNull Map<String, Map<String, String>> configs) {
            Parameters.notNull((CharSequence)"propName", (Object)propName);
            Parameters.notNull((CharSequence)"label", (Object)label);
            Parameters.notNull((CharSequence)"configCombo", configCombo);
            Parameters.notNull((CharSequence)"configs", configs);
            this.propName = propName;
            this.label = label;
            this.configCombo = configCombo;
            this.configs = configs;
            this.basefont = label.getFont();
            this.boldfont = this.basefont.deriveFont(1);
        }

        final String getPropertyName() {
            return this.propName;
        }

        final JLabel getLabel() {
            return this.label;
        }

        final void changed(@NullAllowed String value) {
            String config = (String)this.configCombo.getSelectedItem();
            if (config.length() == 0) {
                config = null;
            }
            if (value != null && config != null && value.equals(this.configs.get(null).get(this.propName))) {
                value = null;
            }
            this.configs.get(config).put(this.propName, value);
            this.updateFont(value);
        }

        final void updateFont(@NullAllowed String value) {
            String config = (String)this.configCombo.getSelectedItem();
            if (config.length() == 0) {
                config = null;
            }
            String def = this.configs.get(null).get(this.propName);
            this.label.setFont(config != null && !Utilities.compareObjects((Object)(value != null ? value : ""), (Object)(def != null ? def : "")) ? this.boldfont : this.basefont);
        }

        @CheckForNull
        final String getPropertyValue(@NullAllowed String config, @NonNull String key) {
            Map<String, String> m = this.configs.get(config);
            String v = m.get(key);
            if (v == null) {
                Map<String, String> def = this.configs.get(null);
                v = def.get(this.getPropertyName());
            }
            return v;
        }

        abstract String getPropertyValue();

        abstract void update(@NullAllowed String var1);
    }

    private static final class PlatformKey
    implements Comparable<PlatformKey> {
        private final JavaPlatform platform;
        private final String displayName;

        private PlatformKey() {
            this.displayName = NbBundle.getMessage(CustomizerRun.class, (String)"TXT_ActivePlatform");
            this.platform = null;
        }

        private PlatformKey(@NonNull JavaPlatform platform) {
            this.displayName = platform.getDisplayName();
            this.platform = platform;
        }

        public String toString() {
            return this.displayName;
        }

        public int hashCode() {
            return this.platform == null ? 17 : this.platform.hashCode();
        }

        public boolean equals(@NullAllowed Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PlatformKey)) {
                return false;
            }
            PlatformKey pk = (PlatformKey)obj;
            return this.platform == null ? pk.platform == null : this.platform.equals(pk.platform);
        }

        @NonNull
        String getPlatformAntName() {
            String antName;
            String string = antName = this.platform == null ? "" : (String)this.platform.getProperties().get("platform.ant.name");
            assert (antName != null);
            return antName;
        }

        @CheckForNull
        JavaPlatform getPlatform() {
            return this.platform;
        }

        static PlatformKey create(@NonNull JavaPlatform platform) {
            return new PlatformKey(platform);
        }

        static PlatformKey createDefault() {
            return new PlatformKey();
        }

        @Override
        public int compareTo(PlatformKey o) {
            return this.displayName.toLowerCase().compareTo(o.displayName.toLowerCase());
        }
    }

    private final class ConfigListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ConfigListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label;
            this.setName("ComboBox.listRenderer");
            String config = (String)value;
            if (config == null) {
                label = null;
            } else if (config.length() > 0) {
                Map m = (Map)CustomizerRun.this.configs.get(config);
                String string = label = m != null ? (String)m.get("$label") : null;
                if (label == null) {
                    label = config;
                }
            } else {
                label = NbBundle.getBundle((String)"org.netbeans.modules.java.j2seproject.Bundle").getString("J2SEConfigurationProvider.default.label");
            }
            this.setText(label);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private final class MainClassListener
    implements ActionListener {
        private final JButton okButton;
        private SourceRoots sourceRoots;
        private JTextField mainClassTextField;

        MainClassListener(SourceRoots sourceRoots, JTextField mainClassTextField) {
            this.sourceRoots = sourceRoots;
            this.mainClassTextField = mainClassTextField;
            this.okButton = new JButton(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ChooseMainClass_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_ChooseMainClass_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final MainClassChooser panel = new MainClassChooser(this.sourceRoots.getRoots(), null, this.mainClassTextField.getText());
            Object[] options = new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION};
            panel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                        MainClassListener.this.okButton.doClick();
                    } else {
                        MainClassListener.this.okButton.setEnabled(panel.getSelectedMainClass() != null);
                    }
                }
            });
            this.okButton.setEnabled(false);
            DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ChooseMainClass_Title"), true, options, options[0], 0, null, null);
            Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.setVisible(true);
            if (desc.getValue() == options[0]) {
                this.mainClassTextField.setText(panel.getSelectedMainClass());
            }
            dlg.dispose();
        }
    }
}

