/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.java.j2seproject.ui.wizards.MoveToModulePathPanel;
import org.netbeans.spi.java.project.support.ui.templates.JavaFileWizardIteratorFactory;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class J2SEFileWizardIterator
implements JavaFileWizardIteratorFactory {
    private static final String MODULE_INFO_JAVA = "module-info.java";

    public static JavaFileWizardIteratorFactory create() {
        return new J2SEFileWizardIterator();
    }

    private J2SEFileWizardIterator() {
    }

    public WizardDescriptor.Iterator<WizardDescriptor> createIterator(@NonNull FileObject template) {
        return MODULE_INFO_JAVA.equals(template.getNameExt()) ? new WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor>(){
            private transient WizardDescriptor wiz;
            private WizardDescriptor.Panel<WizardDescriptor> panel = null;
            private final transient Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

            public Set instantiate() throws IOException {
                J2SEProject project = (J2SEProject)Templates.getProject((WizardDescriptor)this.wiz);
                boolean modularSources = J2SEProjectUtil.hasModuleInfo(project.getSourceRoots());
                boolean modularTests = J2SEProjectUtil.hasModuleInfo(project.getTestSourceRoots());
                Iterable toMove = (Iterable)this.wiz.getProperty("cp_items_to_move");
                ProjectManager.mutex().writeAccess(() -> {
                    EditableProperties ep = project.getUpdateHelper().getProperties("nbproject/project.properties");
                    boolean changed = false;
                    if (toMove != null) {
                        for (ClassPathSupport.Item item : toMove) {
                            changed |= J2SEFileWizardIterator.removeRef(ep, "javac.classpath", item.getReference());
                            changed |= J2SEFileWizardIterator.addRefIfAbsent(ep, "javac.modulepath", item.getReference(), null);
                        }
                    }
                    if (modularSources) {
                        if (modularTests) {
                            changed |= J2SEFileWizardIterator.removeRef(ep, "javac.test.classpath", J2SEProjectUtil.ref("build.classes.dir", true));
                            changed |= J2SEFileWizardIterator.addRefIfAbsent(ep, "javac.test.modulepath", J2SEProjectUtil.ref("build.classes.dir", true), J2SEProjectUtil.ref("javac.modulepath", true));
                            changed |= J2SEFileWizardIterator.removeRef(ep, "run.test.classpath", J2SEProjectUtil.ref("build.test.classes.dir", true));
                            changed |= J2SEFileWizardIterator.addRefIfAbsent(ep, "run.test.modulepath", J2SEProjectUtil.ref("build.test.classes.dir", true), J2SEProjectUtil.ref("javac.test.modulepath", true));
                        } else {
                            changed |= J2SEFileWizardIterator.removeRef(ep, "javac.test.classpath", J2SEProjectUtil.ref("build.classes.dir", true));
                            changed |= J2SEFileWizardIterator.addRefIfAbsent(ep, "javac.test.modulepath", J2SEProjectUtil.ref("build.classes.dir", true), J2SEProjectUtil.ref("javac.modulepath", true));
                            changed |= J2SEFileWizardIterator.removeRef(ep, "run.test.classpath", J2SEProjectUtil.ref("build.test.classes.dir", true));
                            changed |= J2SEFileWizardIterator.removeRef(ep, "run.test.modulepath", J2SEProjectUtil.ref("build.test.classes.dir", true));
                        }
                    } else {
                        changed |= J2SEFileWizardIterator.addRefIfAbsent(ep, "javac.test.classpath", J2SEProjectUtil.ref("build.classes.dir", true), J2SEProjectUtil.ref("javac.classpath", true));
                        changed |= J2SEFileWizardIterator.removeRef(ep, "javac.test.modulepath", J2SEProjectUtil.ref("build.classes.dir", true));
                        changed |= J2SEFileWizardIterator.addRefIfAbsent(ep, "run.test.classpath", J2SEProjectUtil.ref("build.test.classes.dir", true), J2SEProjectUtil.ref("javac.test.classpath", true));
                        changed |= J2SEFileWizardIterator.removeRef(ep, "run.test.modulepath", J2SEProjectUtil.ref("build.test.classes.dir", true));
                    }
                    if (changed) {
                        try {
                            project.getUpdateHelper().putProperties("nbproject/project.properties", ep);
                            ProjectManager.getDefault().saveProject((Project)project);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                return null;
            }

            public void initialize(WizardDescriptor wizard) {
                this.wiz = wizard;
                Project project = Templates.getProject((WizardDescriptor)wizard);
                if (project == null) {
                    throw new NullPointerException("No project found for: " + wizard);
                }
                J2SEProject j2seProject = (J2SEProject)project.getLookup().lookup(J2SEProject.class);
                if (j2seProject == null) {
                    throw new NullPointerException("No j2seproject found in: " + project);
                }
                EditableProperties ep = j2seProject.getUpdateHelper().getProperties("nbproject/project.properties");
                if (J2SEFileWizardIterator.hasAnyRef(ep, "javac.classpath") && !J2SEFileWizardIterator.hasAnyRef(ep, "javac.modulepath")) {
                    this.panel = new MoveToModulePathPanel(j2seProject, ep);
                }
            }

            public void uninitialize(WizardDescriptor wizard) {
                this.wiz = null;
            }

            public WizardDescriptor.Panel<WizardDescriptor> current() {
                return this.panel;
            }

            public String name() {
                return "";
            }

            public boolean hasNext() {
                return false;
            }

            public boolean hasPrevious() {
                return false;
            }

            public void nextPanel() {
            }

            public void previousPanel() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void addChangeListener(ChangeListener l) {
                Set<ChangeListener> set = this.listeners;
                synchronized (set) {
                    this.listeners.add(l);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void removeChangeListener(ChangeListener l) {
                Set<ChangeListener> set = this.listeners;
                synchronized (set) {
                    this.listeners.remove(l);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected final void fireChangeEvent() {
                ChangeListener[] ls;
                Set<ChangeListener> set = this.listeners;
                synchronized (set) {
                    ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
                }
                ChangeEvent ev = new ChangeEvent(this);
                for (ChangeListener l : ls) {
                    l.stateChanged(ev);
                }
            }
        } : null;
    }

    private static boolean hasAnyRef(@NonNull EditableProperties ep, @NonNull String pathId) {
        return Optional.ofNullable(ep.getProperty(pathId)).map(val -> !val.isEmpty()).orElse(Boolean.FALSE);
    }

    private static boolean removeRef(@NonNull EditableProperties ep, @NonNull String pathId, @NonNull String elementToRemove) {
        boolean[] changed = new boolean[1];
        Optional.ofNullable(ep.getProperty(pathId)).map(val -> (String[])Arrays.stream(PropertyUtils.tokenizePath((String)val)).filter(element -> {
            boolean remove = elementToRemove.equals(element);
            changed[0] = changed[0] | remove;
            return !remove;
        }).toArray(String[]::new)).ifPresent(val -> ep.setProperty(pathId, J2SEFileWizardIterator.addPathSeparators(val)));
        return changed[0];
    }

    private static boolean addRefIfAbsent(@NonNull EditableProperties ep, @NonNull String pathId, @NonNull String elementToAdd, @NullAllowed String insertAfter) {
        boolean[] changed = new boolean[1];
        Optional.ofNullable(ep.getProperty(pathId)).map(val -> {
            String[] path = PropertyUtils.tokenizePath((String)val);
            if (!Arrays.stream(path).anyMatch(element -> elementToAdd.equals(element))) {
                ArrayList<String> newPath = new ArrayList<String>(path.length + 1);
                boolean added = false;
                for (int i = 0; i < path.length; ++i) {
                    newPath.add(path[i]);
                    if (insertAfter == null || !insertAfter.equals(path[i])) continue;
                    added = true;
                    newPath.add(elementToAdd);
                }
                if (!added) {
                    newPath.add(elementToAdd);
                }
                path = newPath.toArray(new String[newPath.size()]);
                changed[0] = true;
            }
            return path;
        }).ifPresent(val -> ep.setProperty(pathId, J2SEFileWizardIterator.addPathSeparators(val)));
        return changed[0];
    }

    @NonNull
    private static String[] addPathSeparators(String ... path) {
        for (int i = 0; i < path.length; ++i) {
            path[i] = i + 1 == path.length ? path[i] : String.format("%s:", path[i]);
        }
        return path;
    }
}

