/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.project;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.java.j2seembedded.project.Utilities;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class RemoteProjectOpenHook
extends ProjectOpenedHook {
    private static final Logger LOG = Logger.getLogger(RemoteProjectOpenHook.class.getName());
    private final Project prj;

    public RemoteProjectOpenHook(@NonNull Project prj) {
        Parameters.notNull((CharSequence)"prj", (Object)prj);
        this.prj = prj;
    }

    protected void projectOpened() {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                try {
                    RemoteProjectOpenHook.this.updateBuildScript();
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        });
    }

    protected void projectClosed() {
    }

    private void updateBuildScript() throws IOException {
        assert (ProjectManager.mutex().isWriteAccess());
        AntBuildExtender extender = (AntBuildExtender)this.prj.getLookup().lookup(AntBuildExtender.class);
        if (extender == null) {
            LOG.log(Level.WARNING, "No AntBuildExtender in project: {0}({1})", new Object[]{ProjectUtils.getInformation((Project)this.prj).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.prj.getProjectDirectory())});
            return;
        }
        if (!Utilities.hasRemoteExtension(this.prj)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "The project: {0}({1}) does not have current remote platform extension", new Object[]{ProjectUtils.getInformation((Project)this.prj).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.prj.getProjectDirectory())});
            }
            return;
        }
        Utilities.copyBuildScript(this.prj);
    }
}

