/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2sedeploy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.netbeans.api.actions.Closable;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;

public final class J2SEDeployProperties {
    public static final String NATIVE_BUNDLING_ENABLED = "native.bundling.enabled";
    public static final String JAVAFX_ENABLED = "javafx.enabled";
    private static final String J2SEDEPLOY_EXTENSION = "j2sedeploy";
    private static final String[] OLD_J2SEDEPLOY_EXTENSION = new String[0];
    private static final String BUILD_SCRIPT_PROTOTYPE = String.format("%s/resources/build-native-prototype.xml", J2SEDeployProperties.class.getPackage().getName().replace('.', '/'));
    private static final String EXTENSION_BUILD_SCRIPT_PATH = "nbproject/build-native.xml";
    private static final Logger LOG = Logger.getLogger(J2SEDeployProperties.class.getName());
    private J2SEPropertyEvaluator j2sePropEval;
    private PropertyEvaluator evaluator;
    private Project project;
    boolean nativeBundlingEnabled;
    private static Map<String, J2SEDeployProperties> propInstance = new HashMap<String, J2SEDeployProperties>();

    public Project getProject() {
        return this.project;
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public boolean getNativeBundlingEnabled() {
        return this.nativeBundlingEnabled;
    }

    public void setNativeBundlingEnabled(boolean enabled) {
        this.nativeBundlingEnabled = enabled;
    }

    public static J2SEDeployProperties getInstance(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        J2SEDeployProperties prop = propInstance.get(projDir);
        if (prop == null) {
            prop = new J2SEDeployProperties(context);
            propInstance.put(projDir, prop);
        }
        return prop;
    }

    public static J2SEDeployProperties getInstanceIfExists(Project proj) {
        assert (proj != null);
        String projDir = proj.getProjectDirectory().getPath();
        J2SEDeployProperties prop = propInstance.get(projDir);
        if (prop != null) {
            return prop;
        }
        return null;
    }

    public static J2SEDeployProperties getInstanceIfExists(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        return J2SEDeployProperties.getInstanceIfExists(proj);
    }

    public static void cleanup(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        propInstance.remove(projDir);
    }

    static String getCurrentExtensionName() {
        return J2SEDEPLOY_EXTENSION;
    }

    static String[] getOldExtensionNames() {
        return OLD_J2SEDEPLOY_EXTENSION;
    }

    static void updateJ2SEDeployExtension(@NonNull Project project) throws IOException {
        Parameters.notNull((CharSequence)"project", (Object)project);
        FileObject buildNativeXml = J2SEDeployProperties.copyBuildNativeTemplate(project);
        assert (buildNativeXml != null);
        AntBuildExtender extender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
        assert (extender != null);
        J2SEDeployProperties.modifyBuildXml(extender, buildNativeXml);
    }

    /*
     * Exception decompiling
     */
    static boolean isBuildNativeUpToDate(@NonNull Project project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileObject copyBuildNativeTemplate(@NonNull Project project) throws IOException {
        FileLock lock;
        FileObject buildExFo;
        Parameters.notNull((CharSequence)"project", (Object)project);
        FileObject buildExFoBack = project.getProjectDirectory().getFileObject(String.format("%s~", EXTENSION_BUILD_SCRIPT_PATH));
        if (buildExFoBack != null) {
            J2SEDeployProperties.closeInEditor(buildExFoBack);
            buildExFoBack.delete();
        }
        if ((buildExFo = project.getProjectDirectory().getFileObject(EXTENSION_BUILD_SCRIPT_PATH)) != null) {
            J2SEDeployProperties.closeInEditor(buildExFo);
            lock = buildExFo.lock();
            try {
                buildExFo.rename(lock, buildExFo.getName(), String.format("%s~", buildExFo.getExt()));
            }
            finally {
                lock.releaseLock();
            }
        }
        buildExFo = FileUtil.createData((FileObject)project.getProjectDirectory(), (String)EXTENSION_BUILD_SCRIPT_PATH);
        lock = buildExFo.lock();
        try (InputStream in = J2SEDeployProperties.class.getClassLoader().getResourceAsStream(BUILD_SCRIPT_PROTOTYPE);
             OutputStream out = buildExFo.getOutputStream(lock);){
            FileUtil.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            lock.releaseLock();
        }
        return buildExFo;
    }

    private static AntBuildExtender.Extension modifyBuildXml(@NonNull AntBuildExtender extender, @NonNull FileObject buildNativeXml) {
        Parameters.notNull((CharSequence)"extender", (Object)extender);
        Parameters.notNull((CharSequence)"buildNativeXml", (Object)buildNativeXml);
        return extender.addExtension(J2SEDeployProperties.getCurrentExtensionName(), buildNativeXml);
    }

    private static void closeInEditor(@NonNull FileObject file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        try {
            DataObject dobj = DataObject.find((FileObject)file);
            Closable closeCookie = (Closable)dobj.getLookup().lookup(Closable.class);
            if (closeCookie != null) {
                closeCookie.close();
            }
        }
        catch (DataObjectNotFoundException donfe) {
            LOG.log(Level.INFO, "Cannot close {0}.", FileUtil.getFileDisplayName((FileObject)file));
        }
    }

    private static long computeCRC(@NonNull InputStream in) throws IOException {
        int curr;
        CRC32 crc = new CRC32();
        int last = -1;
        while ((curr = in.read()) != -1) {
            if (curr != 10 && last == 13) {
                crc.update(10);
            }
            if (curr != 13) {
                crc.update(curr);
            }
            last = curr;
        }
        if (last == 13) {
            crc.update(10);
        }
        return crc.getValue();
    }

    private J2SEDeployProperties(Lookup context) {
        this.project = (Project)context.lookup(Project.class);
        if (this.project != null) {
            this.j2sePropEval = (J2SEPropertyEvaluator)this.project.getLookup().lookup(J2SEPropertyEvaluator.class);
            this.evaluator = this.j2sePropEval.evaluator();
            this.nativeBundlingEnabled = J2SEDeployProperties.isTrue(this.evaluator.getProperty(NATIVE_BUNDLING_ENABLED));
        }
    }

    private static void setOrRemove(@NonNull EditableProperties props, @NonNull String name, String value) {
        if (value != null) {
            props.setProperty(name, value);
        } else {
            props.remove((Object)name);
        }
    }

    public void store() throws IOException {
        final EditableProperties ep = new EditableProperties(true);
        final FileObject projPropsFO = this.project.getProjectDirectory().getFileObject("nbproject/project.properties");
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    try (InputStream is = projPropsFO.getInputStream();){
                        ep.load(is);
                    }
                    J2SEDeployProperties.setOrRemove(ep, J2SEDeployProperties.NATIVE_BUNDLING_ENABLED, J2SEDeployProperties.this.nativeBundlingEnabled ? "true" : null);
                    FileLock lock = projPropsFO.lock();
                    try (OutputStream os = projPropsFO.getOutputStream(lock);){
                        ep.store(os);
                    }
                    finally {
                        lock.releaseLock();
                    }
                    AntBuildExtender extender = (AntBuildExtender)J2SEDeployProperties.this.project.getLookup().lookup(AntBuildExtender.class);
                    if (extender != null) {
                        AntBuildExtender.Extension extension = extender.getExtension(J2SEDeployProperties.getCurrentExtensionName());
                        if (J2SEDeployProperties.this.nativeBundlingEnabled) {
                            if (extension == null) {
                                FileObject buildExFo = J2SEDeployProperties.copyBuildNativeTemplate(J2SEDeployProperties.this.project);
                                extension = J2SEDeployProperties.modifyBuildXml(extender, buildExFo);
                            }
                        } else {
                            FileObject buildExFo;
                            if (extension != null) {
                                extender.removeExtension(J2SEDeployProperties.getCurrentExtensionName());
                            }
                            if ((buildExFo = J2SEDeployProperties.this.project.getProjectDirectory().getFileObject(J2SEDeployProperties.EXTENSION_BUILD_SCRIPT_PATH)) != null) {
                                J2SEDeployProperties.closeInEditor(buildExFo);
                                buildExFo.delete();
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
    }

    public static boolean isTrue(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }

    public static boolean isNonEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean isEqual(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
    }

    public static boolean isEqualIgnoreCase(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equalsIgnoreCase(s2);
    }

    public static boolean isEqualText(String s1, String s2) {
        return (s1 == null || s1.isEmpty()) && (s2 == null || s2.isEmpty()) || s1 != null && s2 != null && s1.equals(s2);
    }
}

