/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class ConvertToVarHint {
    private static final Set<String> SKIPPED_ERROR_CODES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("compiler.err.generic.array.creation")));

    public static ErrorDescription computeExplicitToVarType(HintContext ctx) {
        if (!ConvertToVarHint.preConditionChecker(ctx)) {
            return null;
        }
        if (!ConvertToVarHint.isValidVarType(ctx)) {
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.MSG_ConvertibleToVarType(), (Fix[])new Fix[]{new JavaFixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix()});
    }

    private static boolean preConditionChecker(HintContext ctx) {
        CompilationInfo info = ctx.getInfo();
        if (info.getSourceVersion().compareTo(SourceVersion.RELEASE_9) < 1) {
            return false;
        }
        TreePath treePath = ctx.getPath();
        if (info.getTrees().getElement(treePath).getKind() != ElementKind.LOCAL_VARIABLE) {
            return false;
        }
        if (ConvertToVarHint.isDiagnosticCodeTobeSkipped(ctx.getInfo(), treePath.getLeaf())) {
            return false;
        }
        if (info.getTreeUtilities().isPartOfCompoundVariableDeclaration(treePath.getLeaf())) {
            return false;
        }
        return !info.getTreeUtilities().isVarType(treePath);
    }

    private static boolean isDiagnosticCodeTobeSkipped(CompilationInfo info, Tree tree) {
        long startPos = info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), tree);
        long endPos = info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), tree);
        List diagnosticsList = info.getDiagnostics();
        return diagnosticsList.stream().anyMatch(d -> d.getKind() == Diagnostic.Kind.ERROR && d.getStartPosition() >= startPos && d.getEndPosition() <= endPos && SKIPPED_ERROR_CODES.contains(d.getCode()));
    }

    private static boolean isValidVarType(HintContext ctx) {
        TreePath treePath = ctx.getPath();
        TreePath initTreePath = (TreePath)ctx.getVariables().get("$init");
        if (initTreePath != null) {
            Tree.Kind kind = initTreePath.getLeaf().getKind();
            switch (kind) {
                case NEW_CLASS: {
                    NewClassTree nct = (NewClassTree)initTreePath.getLeaf();
                    if (nct.getClassBody() == null) break;
                    return false;
                }
                case NEW_ARRAY: {
                    NewArrayTree nat = (NewArrayTree)((VariableTree)treePath.getLeaf()).getInitializer();
                    if (nat.getType() != null) break;
                    return false;
                }
                case LAMBDA_EXPRESSION: {
                    return false;
                }
            }
        } else {
            return false;
        }
        TypeMirror initTypeMirror = ctx.getInfo().getTrees().getTypeMirror(initTreePath);
        TypeMirror variableTypeMirror = ctx.getInfo().getTrees().getElement(treePath).asType();
        return Utilities.isValidType(initTypeMirror) && ctx.getInfo().getTypes().isSameType(variableTypeMirror, Utilities.resolveCapturedType(ctx.getInfo(), initTypeMirror));
    }

    private static final class JavaFixImpl
    extends JavaFix {
        public JavaFixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_ShowMessage();
        }

        protected void performRewrite(JavaFix.TransformationContext tc) throws Exception {
            WorkingCopy wc = tc.getWorkingCopy();
            TreePath statementPath = tc.getPath();
            TreeMaker make = wc.getTreeMaker();
            if (statementPath.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                NewClassTree nct;
                VariableTree oldVariableTree = (VariableTree)statementPath.getLeaf();
                ExpressionTree initializerTree = oldVariableTree.getInitializer();
                if (initializerTree == null) {
                    return;
                }
                if (initializerTree.getKind() == Tree.Kind.NEW_CLASS && (nct = (NewClassTree)initializerTree).getIdentifier().getKind() == Tree.Kind.PARAMETERIZED_TYPE && oldVariableTree.getType().getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                    ParameterizedTypeTree ptt = (ParameterizedTypeTree)oldVariableTree.getType();
                    ParameterizedTypeTree nue = (ParameterizedTypeTree)((Object)nct.getIdentifier());
                    if (nue.getTypeArguments().isEmpty() && ptt.getTypeArguments().size() > 0) {
                        wc.rewrite((Tree)nue, (Tree)ptt);
                    }
                }
                VariableTree newVariableTree = make.Variable(oldVariableTree.getModifiers(), (CharSequence)oldVariableTree.getName(), make.Type("var"), initializerTree);
                wc.rewrite((Tree)oldVariableTree, (Tree)newVariableTree);
            }
        }
    }
}

