/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.idebinding;

import java.util.Collection;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintRegistry;
import org.netbeans.modules.java.hints.declarative.HintDataObject;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.refactoring.InspectAndRefactorUI;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class HintsActionProvider
implements ActionProvider {
    public String[] getSupportedActions() {
        return new String[]{"run.single"};
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        Map<HintMetadata, Collection<? extends HintDescription>> hints;
        assert ("run.single".equals(command));
        HintDataObject hdo = (HintDataObject)((Object)context.lookup(HintDataObject.class));
        assert (hdo != null);
        EditorCookie ec = (EditorCookie)hdo.getLookup().lookup(EditorCookie.class);
        final StyledDocument doc = ec.getDocument();
        if (doc != null) {
            final String[] spec = new String[1];
            doc.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        spec[0] = doc.getText(0, doc.getLength());
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        spec[0] = "";
                    }
                }
            });
            hints = DeclarativeHintRegistry.parseHints(hdo.getPrimaryFile(), spec[0]);
        } else {
            hints = DeclarativeHintRegistry.parseHintFile(hdo.getPrimaryFile());
        }
        if (hints.isEmpty()) {
            StatusDisplayer.getDefault().setStatusText("No hints specified in " + FileUtil.getFileDisplayName((FileObject)hdo.getPrimaryFile()));
            return;
        }
        HintMetadata m = hints.entrySet().iterator().next().getKey();
        InspectAndRefactorUI.openRefactoringUI((Lookup)Lookups.singleton((Object)new InspectAndRefactorUI.HintWrap(m, DeclarativeHintRegistry.join(hints))));
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        assert ("run.single".equals(command));
        return context.lookup(HintDataObject.class) != null;
    }
}

