/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.test;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class TestLocatorImpl
implements TestLocator {
    public boolean appliesTo(FileObject fo) {
        String mimeType = FileUtil.getMIMEType((FileObject)fo);
        if ("text/x-javahints".equals(mimeType)) {
            return true;
        }
        return "text/x-javahintstest".equals(mimeType);
    }

    public boolean asynchronous() {
        return false;
    }

    public TestLocator.LocationResult findOpposite(FileObject fo, int caretOffset) {
        String mimeType = FileUtil.getMIMEType((FileObject)fo);
        if ("text/x-javahints".equals(mimeType)) {
            FileObject test = TestLocatorImpl.findOpposite(fo, true);
            if (test != null) {
                return new TestLocator.LocationResult(test, -1);
            }
            return new TestLocator.LocationResult("Test not found.");
        }
        if ("text/x-javahintstest".equals(mimeType)) {
            FileObject rule = TestLocatorImpl.findOpposite(fo, false);
            if (rule != null) {
                return new TestLocator.LocationResult(rule, -1);
            }
            return new TestLocator.LocationResult("Rule file not found.");
        }
        throw new IllegalArgumentException();
    }

    public void findOpposite(FileObject fo, int caretOffset, TestLocator.LocationListener callback) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TestLocator.FileType getFileType(FileObject fo) {
        String mimeType = FileUtil.getMIMEType((FileObject)fo);
        if ("text/x-javahints".equals(mimeType)) {
            return TestLocator.FileType.TESTED;
        }
        if ("text/x-javahintstest".equals(mimeType)) {
            return TestLocator.FileType.TEST;
        }
        return TestLocator.FileType.NEITHER;
    }

    @CheckForNull
    static FileObject findOpposite(FileObject rule, boolean toTest) {
        String resourceName;
        ClassPath cp = ClassPath.getClassPath((FileObject)rule, (String)"classpath/source");
        String string = resourceName = cp != null ? cp.getResourceName(rule) : null;
        if (resourceName == null) {
            Logger.getLogger(TestLocatorImpl.class.getName()).log(Level.FINE, "cp==null or rule file cannot be found on its own source cp");
            return null;
        }
        String testFileName = resourceName.substring(0, resourceName.lastIndexOf(46)) + (toTest ? ".test" : ".hint");
        FileObject testFile = cp.findResource(testFileName);
        if (testFile == null) {
            URL testRoot;
            FileObject testRootFO;
            URL[] sr = toTest ? UnitTestForSourceQuery.findUnitTests((FileObject)cp.findOwnerRoot(rule)) : UnitTestForSourceQuery.findSources((FileObject)cp.findOwnerRoot(rule));
            URL[] uRLArray = sr;
            int n = uRLArray.length;
            for (int i = 0; i < n && ((testRootFO = URLMapper.findFileObject((URL)(testRoot = uRLArray[i]))) == null || (testFile = testRootFO.getFileObject(testFileName)) == null); ++i) {
            }
        }
        return testFile;
    }
}

