/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.file.launcher.actions;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.base.ExplicitProcessParameters;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.file.launcher.SingleSourceFileUtil;
import org.netbeans.modules.java.file.launcher.actions.JPDAStart;
import org.netbeans.modules.java.file.launcher.actions.LaunchProcess;
import org.netbeans.spi.project.ActionProvider;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public final class SingleJavaSourceRunActionProvider
implements ActionProvider {
    private final Map<FileObject, Future<Integer>> running = new WeakHashMap<FileObject, Future<Integer>>();
    private volatile boolean rerun = false;

    public String[] getSupportedActions() {
        return new String[]{"run.single", "debug.single"};
    }

    private String getTaskName(String command, String fileName) {
        if (command == null || command.isEmpty()) {
            return fileName;
        }
        String action = command.contains(".") ? command.substring(0, command.indexOf(46)) : command;
        String capitalized = action.substring(0, 1).toUpperCase(Locale.ROOT) + action.substring(1).toLowerCase(Locale.ROOT);
        String baseName = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName;
        return String.format("%s (%s)", capitalized, baseName);
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        LifecycleManager.getDefault().saveAll();
        FileObject fileObject = SingleSourceFileUtil.getJavaFileWithoutProjectFromLookup(context);
        if (fileObject == null) {
            return;
        }
        Future<Integer> previous = this.running.get(fileObject);
        if (previous != null && !previous.isDone()) {
            this.rerun = true;
            if (previous.cancel(true)) {
                return;
            }
            this.rerun = false;
        }
        ExplicitProcessParameters params = ExplicitProcessParameters.buildExplicitParameters((Lookup)context);
        String preferredEncoding = System.getProperty("native.encoding");
        ExecutionDescriptor descriptor = new ExecutionDescriptor().showProgress(true).controllable(true).frontWindow(true).preExecution(null).inputVisible(true).charset(preferredEncoding != null ? Charset.forName(preferredEncoding) : null).postExecution(exitCode -> {
            if (this.rerun) {
                this.rerun = false;
                this.invokeAction(command, context);
            }
        });
        LaunchProcess process = this.invokeActionHelper(command, fileObject, params);
        ExecutionService exeService = ExecutionService.newService((Callable)process, (ExecutionDescriptor)descriptor, (String)this.getTaskName(command, fileObject.getNameExt()));
        Future future = exeService.run();
        if (NbPreferences.forModule(JavaPlatformManager.class).getBoolean("java_file_launcher_global_stop_and_run_option", false)) {
            this.running.put(fileObject, future);
        }
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        FileObject fileObject = SingleSourceFileUtil.getJavaFileWithoutProjectFromLookup(context);
        return fileObject != null;
    }

    final LaunchProcess invokeActionHelper(String command, FileObject fo, ExplicitProcessParameters params) {
        JPDAStart start = "debug.single".equals(command) ? new JPDAStart(fo) : null;
        return new LaunchProcess(fo, start, params);
    }
}

