/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.file.launcher.queries;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.file.launcher.SingleSourceFileUtil;
import org.netbeans.modules.java.file.launcher.queries.Bundle;
import org.netbeans.modules.java.file.launcher.spi.SingleFileOptionsQueryImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class MultiSourceRootProvider
implements ClassPathProvider {
    private static final Logger LOG = Logger.getLogger(MultiSourceRootProvider.class.getName());
    public static boolean DISABLE_MULTI_SOURCE_ROOT = Boolean.getBoolean("java.disable.multi.source.root");
    private Map<FileObject, ClassPath> file2SourceCP = new WeakHashMap<FileObject, ClassPath>();
    private Map<FileObject, ClassPath> root2SourceCP = new WeakHashMap<FileObject, ClassPath>();
    private Map<FileObject, ClassPath> file2AllPath = new WeakHashMap<FileObject, ClassPath>();
    private Map<FileObject, ClassPath> file2ClassPath = new WeakHashMap<FileObject, ClassPath>();
    private Map<FileObject, ClassPath> file2ModulePath = new WeakHashMap<FileObject, ClassPath>();
    private static final Set<JavaTokenId> IGNORED_TOKENS = EnumSet.of(JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.WHITESPACE);
    private static final Set<JavaTokenId> STOP_TOKENS = EnumSet.of(JavaTokenId.IMPORT, new JavaTokenId[]{JavaTokenId.PUBLIC, JavaTokenId.PROTECTED, JavaTokenId.PRIVATE, JavaTokenId.CLASS, JavaTokenId.LBRACE});

    public ClassPath findClassPath(FileObject file, String type) {
        switch (type) {
            case "classpath/source": {
                return this.getSourcePath(file);
            }
            case "classpath/compile": {
                return this.attributeBasedPath(file, this.file2AllPath, "-classpath", "-cp", "--class-path", "--module-path", "-p");
            }
            case "modules/classpath": {
                return this.attributeBasedPath(file, this.file2ClassPath, "-classpath", "-cp", "--class-path");
            }
            case "modules/compile": {
                return this.attributeBasedPath(file, this.file2ModulePath, "--module-path", "-p");
            }
            case "classpath/boot": 
            case "modules/boot": {
                return this.getBootPath(file);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getSourcePath(FileObject file) {
        if (!SingleSourceFileUtil.isSupportedFile(file)) {
            return null;
        }
        MultiSourceRootProvider multiSourceRootProvider = this;
        synchronized (multiSourceRootProvider) {
            if (file.isValid() && file.isData() && "text/x-java".equals(file.getMIMEType())) {
                return this.file2SourceCP.computeIfAbsent(file, f -> {
                    try {
                        String content = new String(file.asBytes(), FileEncodingQuery.getEncoding((FileObject)file));
                        String packName = MultiSourceRootProvider.findPackage(content);
                        FileObject root = file.getParent();
                        if (packName != null) {
                            List<String> packageParts = Arrays.asList(packName.split("\\."));
                            Collections.reverse(packageParts);
                            for (String packagePart : packageParts) {
                                if (!root.getNameExt().equalsIgnoreCase(packagePart)) {
                                    return null;
                                }
                                root = root.getParent();
                            }
                        }
                        return this.root2SourceCP.computeIfAbsent(root, r -> {
                            ClassPath srcCP = ClassPathSupport.createClassPath(Arrays.asList(new RootPathResourceImplementation((FileObject)r)));
                            if (MultiSourceRootProvider.registerRoot(r)) {
                                GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{srcCP});
                            }
                            return srcCP;
                        });
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "Failed to read sourcefile " + file, ex);
                        return null;
                    }
                });
            }
            FileObject folder = file;
            while (!folder.isRoot()) {
                ClassPath cp = this.root2SourceCP.get(folder);
                if (cp != null) {
                    return cp;
                }
                folder = folder.getParent();
            }
            return null;
        }
    }

    private synchronized FileObject getSourceRootImpl(FileObject file) {
        for (FileObject root : this.root2SourceCP.keySet()) {
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return root;
        }
        return null;
    }

    public FileObject getSourceRoot(FileObject file) {
        FileObject root = this.getSourceRootImpl(file);
        if (root == null) {
            this.getSourcePath(file);
            root = this.getSourceRootImpl(file);
        }
        return root;
    }

    public boolean isSourceLauncher(FileObject file) {
        return this.getSourceRoot(file) != null;
    }

    private ClassPath getBootPath(FileObject file) {
        if (this.isSourceLauncher(file)) {
            return JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
        }
        return null;
    }

    static String findPackage(String fileContext) {
        TokenHierarchy th = TokenHierarchy.create((CharSequence)fileContext, (boolean)true, (Language)JavaTokenId.language(), IGNORED_TOKENS, null);
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        ts.moveStart();
        while (ts.moveNext()) {
            if (ts.token().id() == JavaTokenId.PACKAGE) {
                StringBuilder packageName = new StringBuilder();
                while (ts.moveNext() && (ts.token().id() == JavaTokenId.DOT || ts.token().id() == JavaTokenId.IDENTIFIER)) {
                    packageName.append(ts.token().text());
                }
                return packageName.toString();
            }
            if (!STOP_TOKENS.contains(ts.token().id())) continue;
            break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath attributeBasedPath(FileObject file, Map<FileObject, ClassPath> file2ClassPath, String ... optionKeys) {
        if (!this.isSourceLauncher(file)) {
            return null;
        }
        MultiSourceRootProvider multiSourceRootProvider = this;
        synchronized (multiSourceRootProvider) {
            return file2ClassPath.computeIfAbsent(file, f -> {
                SingleFileOptionsQueryImplementation.Result delegate = SingleSourceFileUtil.getOptionsFor(f);
                if (delegate == null) {
                    return null;
                }
                AttributeBasedClassPathImplementation cpi = new AttributeBasedClassPathImplementation(delegate, optionKeys);
                return ClassPathFactory.createClassPath((ClassPathImplementation)cpi);
            });
        }
    }

    private static boolean registerRoot(FileObject root) {
        return "true".equals(Bundle.SETTING_AutoRegisterAsRoot());
    }

    private static final class RootPathResourceImplementation
    implements FilteringPathResourceImplementation {
        private final URL root;
        private final URL[] roots;
        private final AtomicReference<String> lastCheckedAsIncluded = new AtomicReference();

        public RootPathResourceImplementation(FileObject root) {
            this.root = root.toURL();
            this.roots = new URL[]{this.root};
        }

        public boolean includes(URL root, String resource) {
            boolean included;
            int lastSlash;
            if (!resource.endsWith("/") && (lastSlash = resource.lastIndexOf(47)) != -1) {
                resource = resource.substring(0, lastSlash + 1);
            }
            if (resource.equals(this.lastCheckedAsIncluded.get())) {
                return true;
            }
            FileObject fo = URLMapper.findFileObject((URL)root);
            fo = fo != null ? fo.getFileObject(resource) : null;
            boolean bl = included = fo == null || FileOwnerQuery.getOwner((FileObject)fo) == null;
            if (included) {
                this.lastCheckedAsIncluded.set(resource);
            }
            return included;
        }

        public URL[] getRoots() {
            return this.roots;
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    private static final class AttributeBasedClassPathImplementation
    implements ChangeListener,
    ClassPathImplementation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final SingleFileOptionsQueryImplementation.Result delegate;
        private final Set<String> optionKeys;
        private Set<URL> currentURLs;
        private List<? extends PathResourceImplementation> delegates = Collections.emptyList();

        public AttributeBasedClassPathImplementation(SingleFileOptionsQueryImplementation.Result delegate, String ... optionKeys) {
            this.delegate = delegate;
            this.optionKeys = new HashSet<String>(Arrays.asList(optionKeys));
            delegate.addChangeListener(this);
            this.updateDelegates();
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.updateDelegates();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateDelegates() {
            HashSet<URL> newURLs = new HashSet<URL>();
            ArrayList<? extends PathResourceImplementation> newDelegates = new ArrayList<PathResourceImplementation>();
            List<String> parsed = SingleSourceFileUtil.parseLine(this.delegate.getOptions());
            for (int i = 0; i < parsed.size(); ++i) {
                if (!this.optionKeys.contains(parsed.get(i)) || i + 1 >= parsed.size()) continue;
                ClassPathSupport.createClassPath((String)parsed.get(i + 1)).entries().stream().map(e -> e.getURL()).forEach(u -> {
                    newURLs.add((URL)u);
                    newDelegates.add(ClassPathSupport.createResource((URL)u));
                });
            }
            AttributeBasedClassPathImplementation attributeBasedClassPathImplementation = this;
            synchronized (attributeBasedClassPathImplementation) {
                if (Objects.equals(this.currentURLs, newURLs)) {
                    return;
                }
                this.currentURLs = newURLs;
                this.delegates = newDelegates;
            }
            this.pcs.firePropertyChange("resources", null, null);
        }

        public synchronized List<? extends PathResourceImplementation> getResources() {
            return this.delegates;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }
}

