/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import eu.hansolo.jdktools.Architecture;
import eu.hansolo.jdktools.ArchiveType;
import eu.hansolo.jdktools.Latest;
import eu.hansolo.jdktools.LibCType;
import eu.hansolo.jdktools.OperatingSystem;
import eu.hansolo.jdktools.PackageType;
import eu.hansolo.jdktools.TermOfSupport;
import eu.hansolo.jdktools.versioning.VersionNumber;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.Pkg;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.netbeans.modules.java.disco.Bundle;
import org.netbeans.modules.java.disco.Client;
import org.netbeans.modules.java.disco.DistributionListCellRenderer;
import org.netbeans.modules.java.disco.LTSes;
import org.netbeans.modules.java.disco.OS;
import org.netbeans.modules.java.disco.SelectPackagePanel;
import org.netbeans.modules.java.disco.SwingWorker2;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class QuickPanel
extends JPanel {
    private final DefaultComboBoxModel<Distribution> distrosModel = new DefaultComboBoxModel();
    private final SelectPackagePanel parentPanel;
    private Pkg pkg;
    private boolean ignoreChanges;
    private JComboBox<Distribution> distributionComboBox;
    private JLabel pkgInfo;
    private JLabel pkgLabel;
    private JSlider versions;
    private @MonotonicNonNull VersionsModel versionsModel;

    @Deprecated
    public QuickPanel() {
        this((SelectPackagePanel)null);
    }

    QuickPanel(SelectPackagePanel parentPanel) {
        this.parentPanel = parentPanel;
        this.initComponents();
        this.distributionComboBox.setRenderer(new DistributionListCellRenderer());
    }

    private void initComponents() {
        JLabel versionLabel = new JLabel();
        this.versions = new JSlider();
        JLabel distributionLabel = new JLabel();
        this.distributionComboBox = new JComboBox();
        this.pkgLabel = new JLabel();
        this.pkgInfo = new JLabel();
        Mnemonics.setLocalizedText((JLabel)versionLabel, (String)NbBundle.getMessage(QuickPanel.class, (String)"QuickPanel.versionLabel.text"));
        this.versions.setMinorTickSpacing(1);
        this.versions.setPaintLabels(true);
        this.versions.setPaintTicks(true);
        this.versions.setSnapToTicks(true);
        this.versions.setInverted(true);
        this.versions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                QuickPanel.this.versionsStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)distributionLabel, (String)NbBundle.getMessage(QuickPanel.class, (String)"QuickPanel.distributionLabel.text"));
        this.distributionComboBox.setModel(this.createDistrosModel());
        this.distributionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuickPanel.this.distributionComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.pkgLabel, (String)NbBundle.getMessage(QuickPanel.class, (String)"QuickPanel.pkgLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.pkgInfo, (String)"<PKG_INFO>");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versions, -1, 399, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(distributionLabel).addComponent(this.pkgLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pkgInfo).addComponent(this.distributionComboBox, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(versionLabel).addComponent(this.versions, -1, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(distributionLabel).addComponent(this.distributionComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pkgLabel).addComponent(this.pkgInfo)).addContainerGap(102, Short.MAX_VALUE)));
    }

    private void distributionComboBoxActionPerformed(ActionEvent evt) {
        this.updatePackage();
    }

    private void versionsStateChanged(ChangeEvent evt) {
        if (!this.versions.getValueIsAdjusting()) {
            this.updatePackage();
        }
    }

    private ComboBoxModel<Distribution> createDistrosModel() {
        return this.distrosModel;
    }

    public void updateDistributions(List<Distribution> distributions, Distribution defaultDist) {
        this.ignoreChanges = true;
        this.distrosModel.removeAllElements();
        distributions.stream().sorted(Comparator.comparing(Distribution::getUiString)).forEachOrdered(this.distrosModel::addElement);
        this.distributionComboBox.setSelectedItem(defaultDist);
        this.ignoreChanges = false;
    }

    void setVersions(List<Integer> jdks, Map<Integer, TermOfSupport> lts, int current) {
        this.ignoreChanges = true;
        this.versionsModel = new VersionsModel(jdks, lts, current);
        this.versions.setMaximum(this.versionsModel.getMaximum());
        this.versions.setMinimum(this.versionsModel.getMinimum());
        this.versions.setLabelTable(this.versionsModel.createLabels());
        this.versions.setValue(this.versionsModel.getDefaultValue());
        this.ignoreChanges = false;
    }

    void initFocus() {
        this.versions.requestFocusInWindow();
        this.updatePackage();
    }

    void switchFocus(Distribution distribution, Integer version) {
        int versionIdx;
        this.ignoreChanges = true;
        if (distribution != null) {
            this.distributionComboBox.setSelectedItem(distribution);
        }
        if (version != null && (versionIdx = this.versionsModel.indexOf(version)) >= 0) {
            this.versions.setValue(versionIdx);
        }
        this.ignoreChanges = false;
        this.initFocus();
    }

    Distribution getSelectedDistribution() {
        return (Distribution)this.distributionComboBox.getSelectedItem();
    }

    Integer getSelectedVersion() {
        return this.versionsModel.getJDK(this.versions.getValue());
    }

    Pkg getSelectedPackage() {
        return this.pkg;
    }

    private void updatePackage() {
        if (this.ignoreChanges) {
            return;
        }
        this.pkg = null;
        this.parentPanel.fireValidityChange();
        this.pkgInfo.setText(Bundle.QuickPanel_searching());
        Distribution distribution = (Distribution)this.distributionComboBox.getSelectedItem();
        VersionNumber version = new VersionNumber(Integer.valueOf(this.versionsModel.getJDK(this.versions.getValue())));
        OperatingSystem operatingSystem = OS.getOperatingSystem();
        Architecture architecture = OS.getArchitecture();
        SwingWorker2.submit(() -> {
            List<Pkg> pkgs = Client.getInstance().getPkgs(distribution, version, Latest.AVAILABLE, operatingSystem, architecture, ArchiveType.NONE, PackageType.JDK, false, false);
            return pkgs.stream().filter(p -> this.validatePackage(operatingSystem, (Pkg)p)).findFirst();
        }).then(p -> {
            if (p.isPresent()) {
                this.pkg = (Pkg)p.get();
                this.pkgInfo.setText(this.pkg.getFileName());
            } else {
                this.pkg = null;
                this.pkgInfo.setText(Bundle.QuickPanel_error());
            }
            this.parentPanel.fireValidityChange();
        }).handle(ex -> {
            Exceptions.printStackTrace((Throwable)ex);
            this.pkg = null;
            this.pkgInfo.setText(Bundle.QuickPanel_error());
        }).execute();
    }

    private boolean validatePackage(OperatingSystem os, Pkg p) {
        switch (os) {
            case MACOS: {
                return ArchiveType.ZIP == p.getArchiveType() || ArchiveType.TAR_GZ == p.getArchiveType();
            }
            case LINUX: {
                return (ArchiveType.ZIP == p.getArchiveType() || ArchiveType.TAR_GZ == p.getArchiveType()) && LibCType.MUSL != p.getLibCType();
            }
        }
        return ArchiveType.ZIP == p.getArchiveType();
    }

    static class VersionsModel {
        private final List<Integer> versionJDKs;
        private final Map<Integer, TermOfSupport> lts;
        private final int currentJdk;

        private VersionsModel(List<Integer> jdks, Map<Integer, TermOfSupport> lts, int currentJdk) {
            this.versionJDKs = new ArrayList<Integer>(jdks);
            this.versionJDKs.removeIf(v -> !lts.containsKey(v));
            this.versionJDKs.removeIf(v -> v < 8 || v > currentJdk);
            this.lts = lts;
            this.currentJdk = currentJdk;
        }

        public int getMinimum() {
            return 0;
        }

        public int getMaximum() {
            return this.versionJDKs.size() - 1;
        }

        public int getDefaultValue() {
            return this.versionJDKs.indexOf(LTSes.latest(this.lts));
        }

        @UIEffect
        public @NonNull Hashtable<Integer, JLabel> createLabels() {
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            for (Integer v : this.versionJDKs) {
                boolean isLTS = this.lts.get(v) == TermOfSupport.LTS;
                JLabel label = new JLabel();
                StringJoiner info = new StringJoiner(", ", " (", ")");
                info.setEmptyValue("");
                if (v == this.currentJdk) {
                    info.add("latest");
                }
                if (isLTS) {
                    info.add("LTS");
                    Font font = label.getFont();
                    label.setFont(font.deriveFont(font.getStyle() | 1));
                    label.setToolTipText("Long Term Support");
                }
                label.setText(v.toString() + info.toString());
                labels.put(this.versionJDKs.indexOf(v), label);
            }
            return labels;
        }

        private int getJDK(int index) {
            return this.versionJDKs.get(index);
        }

        private int indexOf(int version) {
            return this.versionJDKs.indexOf(version);
        }
    }
}

