/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import io.foojay.api.discoclient.pkg.ArchiveType;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.Latest;
import io.foojay.api.discoclient.pkg.LibCType;
import io.foojay.api.discoclient.pkg.PackageType;
import io.foojay.api.discoclient.pkg.Pkg;
import io.foojay.api.discoclient.pkg.VersionNumber;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.netbeans.modules.java.disco.Client;
import org.netbeans.modules.java.disco.OS;
import org.netbeans.modules.java.disco.PkgSelection;
import org.netbeans.modules.java.disco.QuickPanel;

class QuickPkgSelection
implements PkgSelection {
    private final VersionNumber version;
    private final Predicate<Pkg> filter;
    private @MonotonicNonNull Pkg pkg = null;

    public QuickPkgSelection(QuickPanel.QuickSelection quick) {
        this.version = new VersionNumber(Integer.valueOf(quick.version));
        this.filter = quick.zip ? p -> {
            switch (OS.getOperatingSystem()) {
                case MACOS: {
                    return ArchiveType.ZIP == p.getArchiveType() || ArchiveType.TAR_GZ == p.getArchiveType();
                }
                case LINUX: {
                    return (ArchiveType.ZIP == p.getArchiveType() || ArchiveType.TAR_GZ == p.getArchiveType()) && LibCType.MUSL != p.getLibCType();
                }
            }
            return ArchiveType.ZIP == p.getArchiveType();
        } : p -> {
            switch (OS.getOperatingSystem()) {
                case WINDOWS: {
                    return ArchiveType.MSI == p.getArchiveType() || ArchiveType.EXE == p.getArchiveType();
                }
                case MACOS: {
                    return ArchiveType.DMG == p.getArchiveType() || ArchiveType.PKG == p.getArchiveType();
                }
            }
            return true;
        };
    }

    @Override
    public String getFileName() {
        if (this.pkg == null) {
            return "Java " + this.version.getFeature().getAsInt();
        }
        return this.pkg.getFileName();
    }

    @Override
    public String getJavaPlatformDisplayName() {
        if (this.pkg != null) {
            return this.pkg.getDistribution().getUiString() + " " + this.pkg.getJavaVersion().toString();
        }
        return "Zulu " + this.version.getFeature().getAsInt();
    }

    @Override
    public @Nullable Pkg get(@Nullable Client d) {
        if (this.pkg != null || d == null) {
            return this.pkg;
        }
        List<Pkg> pkgs = d.getPkgs(Distribution.ZULU, this.version, Latest.OVERALL, OS.getOperatingSystem(), OS.getArchitecture(), ArchiveType.NONE, PackageType.JDK, false);
        Optional<Pkg> found = pkgs.stream().filter(this.filter).findAny();
        if (found.isPresent()) {
            this.pkg = found.get();
            return this.pkg;
        }
        throw new IllegalStateException("Could not find package for " + this.version);
    }
}

