/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import io.foojay.api.discoclient.DiscoClient;
import io.foojay.api.discoclient.event.Evt;
import io.foojay.api.discoclient.event.EvtObserver;
import io.foojay.api.discoclient.event.EvtType;
import io.foojay.api.discoclient.pkg.Architecture;
import io.foojay.api.discoclient.pkg.ArchiveType;
import io.foojay.api.discoclient.pkg.Bitness;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.Latest;
import io.foojay.api.discoclient.pkg.LibCType;
import io.foojay.api.discoclient.pkg.MajorVersion;
import io.foojay.api.discoclient.pkg.OperatingSystem;
import io.foojay.api.discoclient.pkg.PackageType;
import io.foojay.api.discoclient.pkg.Pkg;
import io.foojay.api.discoclient.pkg.ReleaseStatus;
import io.foojay.api.discoclient.pkg.Scope;
import io.foojay.api.discoclient.pkg.SemVer;
import io.foojay.api.discoclient.pkg.TermOfSupport;
import io.foojay.api.discoclient.pkg.VersionNumber;
import io.foojay.api.discoclient.util.PkgInfo;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class Client {
    private static final Client INSTANCE = new Client();
    private DiscoClient client = null;

    public static Client getInstance() {
        return INSTANCE;
    }

    private synchronized DiscoClient getDisco() {
        if (this.client == null) {
            this.client = new DiscoClient();
        }
        return this.client;
    }

    private Client() {
    }

    public final synchronized List<MajorVersion> getAllLTSVersions() {
        Queue majorVersions = this.getDisco().getAllMajorVersions(true);
        return majorVersions.stream().filter(majorVersion -> majorVersion.isMaintained()).collect(Collectors.toList());
    }

    public synchronized MajorVersion getLatestLts(boolean b) {
        return this.getDisco().getLatestLts(b);
    }

    public synchronized MajorVersion getLatestSts(boolean b) {
        return this.getDisco().getLatestSts(b);
    }

    public synchronized List<Pkg> getPkgs(Distribution distribution, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, Architecture architecture, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled) {
        return this.getDisco().getPkgs(distribution, versionNumber, latest, operatingSystem, LibCType.NONE, architecture, Bitness.NONE, archiveType, packageType, javafxBundled, Boolean.valueOf(true), ReleaseStatus.NONE, TermOfSupport.NONE, Scope.PUBLIC);
    }

    public synchronized PkgInfo getPkgInfo(String ephemeralId, SemVer javaVersion) {
        return this.getDisco().getPkgInfo(ephemeralId, javaVersion);
    }

    public synchronized Future<?> downloadPkg(PkgInfo pkgInfo, String absolutePath) {
        return this.getDisco().downloadPkg(pkgInfo, absolutePath);
    }

    public synchronized void setOnEvt(EvtType<? extends Evt> type, EvtObserver observer) {
        this.getDisco().setOnEvt(type, observer);
    }
}

