/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.singlesourcefile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.api.common.singlesourcefile.JPDAStart;
import org.netbeans.modules.java.api.common.singlesourcefile.SingleSourceFileUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class LaunchProcess
implements Callable<Process> {
    private final FileObject fileObject;
    private final JPDAStart start;

    LaunchProcess(FileObject fileObject, JPDAStart start) {
        this.fileObject = fileObject;
        this.start = start;
    }

    @Override
    public Process call() throws Exception {
        if (this.start != null) {
            return this.setupProcess(this.start.execute());
        }
        return this.setupProcess(null);
    }

    private Process setupProcess(String port) throws InterruptedException {
        try {
            Process p;
            boolean compile;
            boolean bl = compile = SingleSourceFileUtil.findJavaVersion() < 11 || SingleSourceFileUtil.hasClassSibling(this.fileObject);
            if (compile && (p = SingleSourceFileUtil.compileJavaSource(this.fileObject)).waitFor() != 0) {
                return p;
            }
            ArrayList<String> commandsList = new ArrayList<String>();
            FileObject java = JavaPlatformManager.getDefault().getDefaultPlatform().findTool("java");
            File javaFile = FileUtil.toFile((FileObject)java);
            String javaPath = javaFile.getAbsolutePath();
            Object argumentsObject = this.fileObject.getAttribute("single_file_run_arguments");
            String arguments = argumentsObject != null ? ((String)argumentsObject).trim() : "";
            Object vmOptionsObj = this.fileObject.getAttribute("single_file_vm_options");
            String vmOptions = vmOptionsObj != null ? (String)vmOptionsObj : "";
            commandsList.add(javaPath);
            if (!vmOptions.isEmpty()) {
                commandsList.addAll(Arrays.asList(vmOptions.split(" ")));
            }
            if (port != null) {
                commandsList.add("-agentlib:jdwp=transport=dt_socket,address=" + port + ",server=n");
            }
            if (compile) {
                commandsList.add("-cp");
                commandsList.add(FileUtil.toFile((FileObject)this.fileObject.getParent()).toString());
                commandsList.add(this.fileObject.getName());
            } else {
                commandsList.add(this.fileObject.getNameExt());
            }
            if (!arguments.isEmpty()) {
                commandsList.addAll(Arrays.asList(arguments.split(" ")));
            }
            ProcessBuilder runFileProcessBuilder = new ProcessBuilder(commandsList);
            runFileProcessBuilder.directory(FileUtil.toFile((FileObject)this.fileObject.getParent()));
            runFileProcessBuilder.redirectErrorStream(true);
            runFileProcessBuilder.redirectOutput();
            return runFileProcessBuilder.start();
        }
        catch (IOException ex) {
            SingleSourceFileUtil.LOG.log(Level.WARNING, "Could not get InputStream of Run Process");
            return null;
        }
    }
}

