/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.singlesourcefile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

final class SingleSourceFileUtil {
    static final Logger LOG = Logger.getLogger(SingleSourceFileUtil.class.getPackage().getName());
    public static final String FILE_ARGUMENTS = "single_file_run_arguments";
    public static final String FILE_VM_OPTIONS = "single_file_vm_options";

    SingleSourceFileUtil() {
    }

    static int findJavaVersion() throws NumberFormatException {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2);
        }
        int version = Integer.parseInt(javaVersion);
        return version;
    }

    static FileObject getJavaFileWithoutProjectFromLookup(Lookup lookup) {
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            if (!SingleSourceFileUtil.isSingleSourceFile(fObj)) continue;
            return fObj;
        }
        for (FileObject fObj : lookup.lookupAll(FileObject.class)) {
            if (!SingleSourceFileUtil.isSingleSourceFile(fObj)) continue;
            return fObj;
        }
        return null;
    }

    static boolean isSingleSourceFile(FileObject fObj) {
        Project p = FileOwnerQuery.getOwner((FileObject)fObj);
        return p == null && fObj.getExt().equalsIgnoreCase("java");
    }

    static Process compileJavaSource(FileObject fileObject) {
        String vmOptions;
        FileObject javac = JavaPlatformManager.getDefault().getDefaultPlatform().findTool("javac");
        File javacFile = FileUtil.toFile((FileObject)javac);
        String javacPath = javacFile.getAbsolutePath();
        ArrayList<String> compileCommandList = new ArrayList<String>();
        Object compilerVmOptionsObj = fileObject.getAttribute(FILE_VM_OPTIONS);
        compileCommandList.add(javacPath);
        compileCommandList.add("-g");
        String string = vmOptions = compilerVmOptionsObj != null ? ((String)compilerVmOptionsObj).trim() : "";
        if (!vmOptions.isEmpty()) {
            compileCommandList.addAll(Arrays.asList(vmOptions.split(" ")));
        }
        compileCommandList.add(fileObject.getPath());
        ProcessBuilder compileProcessBuilder = new ProcessBuilder(compileCommandList);
        compileProcessBuilder.directory(new File(fileObject.getParent().getPath()));
        compileProcessBuilder.redirectErrorStream(true);
        compileProcessBuilder.redirectOutput();
        try {
            return compileProcessBuilder.start();
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not get InputStream of Compile Process");
            return null;
        }
    }

    static boolean hasClassSibling(FileObject fo) {
        return fo.getParent().getFileObject(fo.getName(), "class") != null;
    }
}

