/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.singlesourcefile;

import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.modules.java.api.common.singlesourcefile.CompileProcess;
import org.netbeans.modules.java.api.common.singlesourcefile.DebugProcess;
import org.netbeans.modules.java.api.common.singlesourcefile.JPDAStart;
import org.netbeans.modules.java.api.common.singlesourcefile.SingleSourceFileUtil;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class SingleJavaSourceDebugActionProvider
implements ActionProvider {
    private static final Logger LOG = Logger.getLogger(SingleJavaSourceDebugActionProvider.class.getName());
    private static final String CUSTOM_ERR_MSG = "Error on Compilation. Please verify Source code and Compiler VM Options:\n";
    private static final RequestProcessor BACKGROUND = new RequestProcessor(SingleJavaSourceDebugActionProvider.class.getName(), 100, false, false);
    private static final String IONAME = "Debugging Single Java File";

    public String[] getSupportedActions() {
        return new String[]{"debug.single"};
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        final FileObject fileObject = SingleSourceFileUtil.getJavaFileWithoutProjectFromLookup(context);
        if (fileObject == null) {
            return;
        }
        ExecutionDescriptor descriptor = new ExecutionDescriptor().controllable(true).frontWindow(true).preExecution(null).postExecution(null);
        ExecutionService exeService = ExecutionService.newService((Callable)new Callable<Process>(){

            @Override
            public Process call() {
                CompileProcess compileProcess = new CompileProcess();
                InputOutput io = IOProvider.getDefault().getIO(SingleJavaSourceDebugActionProvider.IONAME, false);
                Process compilePreProcess = compileProcess.setupProcess(fileObject);
                try {
                    int processExitCode = compilePreProcess.waitFor();
                    if (processExitCode != 0) {
                        io.getOut().append((CharSequence)SingleJavaSourceDebugActionProvider.CUSTOM_ERR_MSG);
                        return compilePreProcess;
                    }
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                JPDAStart s = new JPDAStart(io, fileObject);
                try {
                    String port = s.execute();
                    DebugProcess debugProcess = new DebugProcess();
                    Process p = debugProcess.setupProcess(fileObject, port);
                    return p;
                }
                catch (Throwable ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return compilePreProcess;
                }
            }
        }, (ExecutionDescriptor)descriptor, (String)IONAME);
        exeService.run();
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        return SingleSourceFileUtil.getJavaFileWithoutProjectFromLookup(context) != null;
    }
}

