/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.singlesourcefile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class DebugProcess {
    private static final Logger LOG = Logger.getLogger(DebugProcess.class.getName());
    private final Pattern JVM_ARGS_PATTERN = Pattern.compile("(.*) (--source[ ]* [0-9]*)(.*)");

    DebugProcess() {
    }

    public Process setupProcess(FileObject fileObject, String port) {
        try {
            ArrayList<String> commandsList = new ArrayList<String>();
            FileObject java = JavaPlatformManager.getDefault().getDefaultPlatform().findTool("java");
            File javaFile = FileUtil.toFile((FileObject)java);
            String javaPath = javaFile.getAbsolutePath();
            Object argumentsObject = fileObject.getAttribute("single_file_run_arguments");
            String arguments = argumentsObject != null ? ((String)argumentsObject).trim() : "";
            Object vmOptionsObj = fileObject.getAttribute("single_file_vm_options");
            String vmOptions = vmOptionsObj != null ? (String)vmOptionsObj : "";
            commandsList.add(javaPath);
            if (!vmOptions.isEmpty()) {
                Matcher m1 = this.JVM_ARGS_PATTERN.matcher(vmOptions);
                while (m1.find()) {
                    String group1 = m1.group(1);
                    String group3 = m1.group(3);
                    vmOptions = group1 + group3;
                }
                commandsList.addAll(Arrays.asList(vmOptions.split(" ")));
            }
            commandsList.add("-Xdebug");
            commandsList.add("-Xrunjdwp:transport=dt_socket,address=" + port + ",server=n");
            commandsList.add("-cp");
            commandsList.add(fileObject.getParent().getPath());
            commandsList.add(fileObject.getName());
            if (!arguments.isEmpty()) {
                commandsList.addAll(Arrays.asList(arguments.split(" ")));
            }
            ProcessBuilder runFileProcessBuilder = new ProcessBuilder(commandsList);
            runFileProcessBuilder.directory(new File(System.getProperty("user.home")));
            runFileProcessBuilder.redirectErrorStream(true);
            runFileProcessBuilder.redirectOutput();
            return runFileProcessBuilder.start();
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not get InputStream of Run Process");
            return null;
        }
    }
}

