/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui.customizer.vmo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.TreeAdaptor;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.JavaVMOption;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.OptionValue;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.UserPropertyNode;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.VMOptionTreeAdaptor;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.gen.CommandLineLexer;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.gen.CommandLineParser;
import org.openide.util.NbBundle;

public class VMOptionsTableModel
extends AbstractTableModel {
    private List<JavaVMOption<?>> rows = new ArrayList();
    private String[] columns = new String[]{"name", "value"};
    private static final UserPropertyNode USER_PROPERTY_NODE = new UserPropertyNode(){

        @Override
        public void setName(String name) {
        }

        @Override
        public void setValue(OptionValue<Map.Entry<String, String>> value) {
        }

        @Override
        public boolean isValid() {
            return false;
        }
    };

    @Override
    public int getRowCount() {
        return this.rows.size() + 1;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int column) {
        if (0 <= column && column < this.columns.length) {
            return NbBundle.getMessage(VMOptionsTableModel.class, (String)("VMOptionTableModel." + this.columns[column] + ".text"));
        }
        throw new IllegalStateException("Column index out of range.");
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.rowOk(rowIndex)) {
            return this.rows.get(rowIndex);
        }
        if (rowIndex == this.rows.size()) {
            return USER_PROPERTY_NODE;
        }
        throw new IllegalArgumentException("Row index out of range.");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setValue(rowIndex, (OptionValue)aValue);
    }

    public <T> void setValue(int row, OptionValue<T> value) {
        if (this.rowOk(row)) {
            JavaVMOption<?> option = this.rows.get(row);
            if (option == null) {
                throw new IllegalStateException("The selected row contains null option  .");
            }
            option.setValue(value);
            this.fireTableRowsUpdated(row, row);
        } else if (row == this.rows.size()) {
            UserPropertyNode upn = new UserPropertyNode();
            upn.setValue(value);
            this.rows.add(upn);
            this.fireTableRowsInserted(this.rows.size() - 2, this.rows.size() - 1);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return true;
        }
        if (rowIndex == this.rows.size()) {
            return true;
        }
        if (this.rowOk(rowIndex)) {
            JavaVMOption<?> option = this.rows.get(rowIndex);
            return option instanceof UserPropertyNode;
        }
        return false;
    }

    private boolean rowOk(int rowIndex) {
        return 0 <= rowIndex && rowIndex < this.rows.size();
    }

    public void fill(String str) throws Exception {
        this.rows.clear();
        CommandLineLexer lexer = new CommandLineLexer((CharStream)new ANTLRStringStream(str));
        CommonTokenStream cts = new CommonTokenStream((TokenSource)lexer);
        CommandLineParser parser = new CommandLineParser((TokenStream)cts);
        parser.setTreeAdaptor((TreeAdaptor)new VMOptionTreeAdaptor());
        this.rows.addAll(parser.parse());
        Collections.sort(this.rows);
        this.fireTableDataChanged();
    }

    public List<JavaVMOption<?>> getValidOptions() {
        LinkedList result = new LinkedList();
        for (JavaVMOption<?> row : this.rows) {
            Object value = row.getValue();
            if (value == null || !((OptionValue)value).isPresent()) continue;
            result.add(row);
        }
        return result;
    }
}

