/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders.multiview.tables;

import java.util.ResourceBundle;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;

public abstract class TableEntry {
    protected final ResourceBundle bundle;
    protected final String resourceBase;
    protected final String parentPropertyName;
    protected final String propertyName;
    protected final String columnName;
    protected final int columnWidth;
    protected final boolean requiredFieldFlag;
    protected final boolean nameFieldFlag;

    public TableEntry(String pn, String c, int w) {
        this(pn, c, w, false);
    }

    public TableEntry(String pn, String c, int w, boolean required) {
        this(null, pn, c, w, required);
    }

    public TableEntry(String ppn, String pn, String c, int w, boolean required) {
        this(ppn, pn, c, w, required, false);
    }

    public TableEntry(String ppn, String pn, String c, int w, boolean required, boolean isName) {
        this.parentPropertyName = ppn;
        this.bundle = null;
        this.resourceBase = null;
        this.propertyName = pn;
        this.columnName = c;
        this.columnWidth = w;
        this.requiredFieldFlag = required;
        this.nameFieldFlag = isName;
    }

    public TableEntry(String ppn, String pn, ResourceBundle resBundle, String base, int w, boolean required, boolean isName) {
        this.parentPropertyName = ppn;
        this.propertyName = pn;
        this.bundle = resBundle;
        this.resourceBase = base;
        this.columnName = this.bundle.getString("LBL_" + this.resourceBase);
        this.columnWidth = w;
        this.requiredFieldFlag = required;
        this.nameFieldFlag = isName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public boolean isRequiredField() {
        return this.requiredFieldFlag;
    }

    public boolean isNameField() {
        return this.nameFieldFlag;
    }

    public String getLabelName() {
        return this.columnName + " :";
    }

    public char getLabelMnemonic() {
        assert (this.bundle != null) : "Coding error: incorrect column definition for " + this.columnName;
        return this.bundle.getString("MNE_" + this.resourceBase).charAt(0);
    }

    public String getAccessibleName() {
        assert (this.bundle != null) : "Coding error: incorrect column definition for " + this.columnName;
        return this.bundle.getString("ACSN_" + this.resourceBase);
    }

    public String getAccessibleDescription() {
        assert (this.bundle != null) : "Coding error: incorrect column definition for " + this.columnName;
        return this.bundle.getString("ACSD_" + this.resourceBase);
    }

    public abstract Object getEntry(CommonDDBean var1);

    public abstract void setEntry(CommonDDBean var1, Object var2);

    public abstract Object getEntry(CommonDDBean var1, int var2);

    public abstract void setEntry(CommonDDBean var1, int var2, Object var3);
}

