/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourcePopulator;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.netbeans.modules.j2ee.persistence.spi.server.ServerStatusProvider2;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.util.SourceLevelChecker;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaFileList;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaManager;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaTableProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaUISupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.EmptyTableProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableSource;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableUISupport;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DatabaseTablesPanel
extends JPanel
implements AncestorListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DBSchemaManager dbschemaManager = new DBSchemaManager();
    private PersistenceGenerator persistenceGen;
    private SchemaElement sourceSchemaElement;
    private DatabaseConnection dbconn;
    private FileObject dbschemaFile;
    private String datasourceName;
    private TableClosure tableClosure;
    private boolean sourceSchemaUpdateEnabled;
    private boolean allowUpdateRecreate = true;
    private ChangeListener changeListener = null;
    private ServerStatusProvider2 serverStatusProvider;
    private DBSchemaFileList dbschemaFileList;
    private TableSource tableSource;
    private FileObject targetFolder;
    private String[] filterComboTxts = new String[]{NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_FILTERCOMBOBOX_ALL"), NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_FILTERCOMBOBOX_NEW"), NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_FILTERCOMBOBOX_UPDATE")};
    private TableUISupport.FilterAvailable filterAvailable = TableUISupport.FilterAvailable.ANY;
    private Project project;
    private JButton addAllButton;
    private JComboBox addAllTypeCombo;
    private JButton addButton;
    private JLabel availableTablesLabel;
    private JList availableTablesList;
    private JScrollPane availableTablesScrollPane;
    private JPanel buttonPanel;
    private JPanel comboPanel;
    private JComboBox datasourceComboBox;
    private JLabel datasourceLabel;
    private JRadioButton datasourceRadioButton;
    private JComboBox dbschemaComboBox;
    private JRadioButton dbschemaRadioButton;
    private JButton removeAllButton;
    private JButton removeButton;
    private ButtonGroup schemaSource;
    private JLabel selectedTablesLabel;
    private JList selectedTablesList;
    private JScrollPane selectedTablesScrollPane;
    private JCheckBox tableClosureCheckBox;
    private JTextPane tableError;
    private JScrollPane tableErrorScroll;
    private JPanel tablesPanel;

    public DatabaseTablesPanel() {
        this.initComponents();
        this.initInitial();
        ListSelectionListener selectionListener = e -> this.updateButtons();
        this.availableTablesList.getSelectionModel().addListSelectionListener(selectionListener);
        this.selectedTablesList.getSelectionModel().addListSelectionListener(selectionListener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void initialize(Project project, DBSchemaFileList dbschemaFileList, PersistenceGenerator persistenceGen, TableSource tableSource, FileObject targetFolder) {
        this.persistenceGen = persistenceGen;
        this.project = project;
        this.dbschemaFileList = dbschemaFileList;
        this.tableSource = tableSource;
        this.targetFolder = targetFolder;
        this.addAncestorListener(this);
    }

    private void initSubComponents() {
        boolean withDatasources;
        this.changeListener = e -> {
            if (this.project != null && ProviderUtil.isValidServerInstanceOrNone(this.project)) {
                this.serverStatusProvider.removeChangeListener(this.changeListener);
                if (!Util.isContainerManaged(this.project)) {
                    this.datasourceComboBox.setModel(new DefaultComboBoxModel());
                    this.initializeWithDbConnections();
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"WRN_Server_Does_Not_Support_DS")));
                } else {
                    this.datasourceComboBox.setModel(new DefaultComboBoxModel());
                    this.initializeWithDatasources();
                }
            }
        };
        if (!ProviderUtil.isValidServerInstanceOrNone(this.project)) {
            this.serverStatusProvider = (ServerStatusProvider2)this.project.getLookup().lookup(ServerStatusProvider2.class);
            if (this.serverStatusProvider != null) {
                this.serverStatusProvider.addChangeListener(this.changeListener);
            }
        }
        boolean serverIsSelected = ProviderUtil.isValidServerInstanceOrNone(this.project);
        boolean canServerBeSelected = ProviderUtil.canServerBeSelected(this.project);
        boolean bl = withDatasources = Util.isContainerManaged(this.project) || Util.isEjb21Module(this.project);
        if (withDatasources && serverIsSelected || canServerBeSelected && !serverIsSelected) {
            this.initializeWithDatasources();
        } else {
            this.initializeWithDbConnections();
        }
        DBSchemaUISupport.connect(this.dbschemaComboBox, this.dbschemaFileList);
        boolean hasDBSchemas = this.dbschemaComboBox.getItemCount() > 0 && this.dbschemaComboBox.getItemAt(0) instanceof FileObject;
        this.dbschemaRadioButton.setEnabled(hasDBSchemas);
        this.dbschemaComboBox.setEnabled(hasDBSchemas);
        this.dbschemaRadioButton.setVisible(hasDBSchemas);
        this.dbschemaComboBox.setVisible(hasDBSchemas);
        this.datasourceLabel.setVisible(!hasDBSchemas);
        this.datasourceRadioButton.setVisible(hasDBSchemas);
        this.selectDefaultTableSource(this.tableSource, withDatasources, this.project, this.targetFolder);
        this.sourceSchemaUpdateEnabled = true;
        SwingUtilities.invokeLater(() -> this.updateSourceSchema());
    }

    private void initInitial() {
        this.dbschemaRadioButton.setEnabled(false);
        this.dbschemaComboBox.setEnabled(false);
        this.dbschemaRadioButton.setVisible(false);
        this.dbschemaComboBox.setVisible(false);
        this.datasourceRadioButton.setVisible(false);
        Mnemonics.setLocalizedText((JLabel)this.datasourceLabel, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_Wait"));
    }

    private void initializeWithDatasources() {
        Mnemonics.setLocalizedText((AbstractButton)this.datasourceRadioButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_Datasource"));
        Mnemonics.setLocalizedText((JLabel)this.datasourceLabel, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_Datasource"));
        JPADataSourcePopulator dsPopulator = (JPADataSourcePopulator)this.project.getLookup().lookup(JPADataSourcePopulator.class);
        dsPopulator.connect(this.datasourceComboBox);
    }

    private void initializeWithDbConnections() {
        Mnemonics.setLocalizedText((AbstractButton)this.datasourceRadioButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_JDBCConnection"));
        Mnemonics.setLocalizedText((JLabel)this.datasourceLabel, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_JDBCConnection"));
        DatabaseExplorerUIs.connect((JComboBox)this.datasourceComboBox, (ConnectionManager)ConnectionManager.getDefault());
    }

    private void selectDefaultTableSource(TableSource tableSource, boolean withDatasources, Project project, FileObject targetFolder) {
        if (tableSource == null) {
            SourceGroup[] sourceGroups;
            SourceGroup targetSourceGroup;
            int dbschemaCount = this.dbschemaComboBox.getItemCount();
            if (targetFolder != null && (targetSourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])(sourceGroups = SourceGroups.getJavaSourceGroups((Project)project)), (FileObject)targetFolder)) != null) {
                for (int i = 0; i < dbschemaCount; ++i) {
                    FileObject parent;
                    Object nextSchema = this.dbschemaComboBox.getItemAt(i);
                    if (!(nextSchema instanceof FileObject) || !(parent = ((FileObject)nextSchema).getParent()).equals(targetFolder)) continue;
                    this.dbschemaComboBox.setSelectedIndex(i);
                    this.dbschemaRadioButton.setSelected(true);
                    return;
                }
            }
            if (dbschemaCount > 0 && this.dbschemaComboBox.getItemAt(0) instanceof FileObject) {
                this.dbschemaComboBox.setSelectedIndex(0);
                this.dbschemaRadioButton.setSelected(true);
                return;
            }
        } else {
            String tableSourceName = tableSource.getName();
            switch (tableSource.getType()) {
                case DATA_SOURCE: {
                    if (!withDatasources || !this.selectDatasource(tableSourceName, false)) break;
                    return;
                }
                case CONNECTION: {
                    if (withDatasources || !this.selectDbConnection(tableSourceName)) break;
                    return;
                }
                case SCHEMA_FILE: {
                    if (!this.selectDBSchemaFile(tableSourceName)) break;
                    return;
                }
            }
        }
        boolean puExists = false;
        try {
            puExists = ProviderUtil.persistenceExists(project, targetFolder);
        }
        catch (RuntimeException | InvalidPersistenceXmlException sourceGroups) {
            // empty catch block
        }
        if (puExists) {
            PersistenceUnit pu;
            PUDataObject pud = null;
            try {
                pud = ProviderUtil.getPUDataObject(project, targetFolder, null);
            }
            catch (InvalidPersistenceXmlException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            PersistenceUnit persistenceUnit = pu = pud != null && pud.getPersistence().getPersistenceUnit().length == 1 ? pud.getPersistence().getPersistenceUnit()[0] : null;
            if (pu != null) {
                if (withDatasources) {
                    boolean jta;
                    String jtaDs = pu.getJtaDataSource();
                    boolean bl = jta = jtaDs != null || Util.isContainerManaged(project) && (pu.getTransactionType() == null || pu.getTransactionType().equals("JTA"));
                    if (jta) {
                        this.selectDatasource(jtaDs, true);
                    } else {
                        String nJtaDs = pu.getNonJtaDataSource();
                        if (nJtaDs != null) {
                            this.selectDatasource(nJtaDs, true);
                        }
                    }
                } else {
                    DatabaseConnection cn = ProviderUtil.getConnection(pu);
                    if (cn != null) {
                        this.datasourceComboBox.setSelectedItem(cn);
                    }
                }
            }
        }
        this.datasourceRadioButton.setSelected(true);
    }

    private static List<DatabaseConnection> findDatabaseConnections(JPADataSource datasource) {
        if (datasource == null) {
            throw new NullPointerException("The datasource parameter cannot be null.");
        }
        String databaseUrl = datasource.getUrl();
        String user = datasource.getUsername();
        if (databaseUrl == null || user == null) {
            return Collections.emptyList();
        }
        ArrayList<DatabaseConnection> result = new ArrayList<DatabaseConnection>();
        for (DatabaseConnection dbconn : ConnectionManager.getDefault().getConnections()) {
            if (!databaseUrl.equals(dbconn.getDatabaseURL()) || !user.equals(dbconn.getUser())) continue;
            result.add(dbconn);
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private boolean selectDatasource(String jndiName, boolean skipChecks) {
        DatabaseConnection dbcon;
        JPADataSourceProvider dsProvider = (JPADataSourceProvider)this.project.getLookup().lookup(JPADataSourceProvider.class);
        if (dsProvider == null) {
            return false;
        }
        if (jndiName == null) {
            jndiName = "java:comp/DefaultDataSource";
        }
        JPADataSource datasource = null;
        for (JPADataSource each : dsProvider.getDataSources()) {
            if (!jndiName.equals(each.getJndiName())) continue;
            datasource = each;
        }
        if (datasource == null) {
            return false;
        }
        List<DatabaseConnection> dbconns = DatabaseTablesPanel.findDatabaseConnections(datasource);
        if (dbconns.isEmpty()) {
            return false;
        }
        if (!skipChecks && (dbcon = dbconns.get(0)).getJDBCConnection() == null) {
            return false;
        }
        boolean selected = false;
        for (int i = 0; i < this.datasourceComboBox.getItemCount(); ++i) {
            Object item = this.datasourceComboBox.getItemAt(i);
            JPADataSource jpaDS = dsProvider.toJPADataSource(item);
            if (jpaDS == null || !datasource.getJndiName().equals(jpaDS.getJndiName()) || !datasource.getUrl().equals(jpaDS.getUrl()) || !datasource.getUsername().equals(jpaDS.getUsername())) continue;
            this.datasourceComboBox.setSelectedIndex(i);
            selected = true;
            break;
        }
        if (!selected) {
            return false;
        }
        this.datasourceRadioButton.setSelected(true);
        return true;
    }

    private boolean selectDbConnection(String name) {
        DatabaseConnection dbcon = ConnectionManager.getDefault().getConnection(name);
        if (dbcon == null || dbcon.getJDBCConnection() == null) {
            return false;
        }
        this.datasourceComboBox.setSelectedItem(dbcon);
        if (!dbcon.equals(this.datasourceComboBox.getSelectedItem())) {
            return false;
        }
        this.datasourceRadioButton.setSelected(true);
        return true;
    }

    private boolean selectDBSchemaFile(String name) {
        FileObject dbschemaFl = FileUtil.toFileObject((File)new File(name));
        if (dbschemaFl == null) {
            return false;
        }
        this.dbschemaComboBox.setSelectedItem(dbschemaFl);
        if (!dbschemaFl.equals(this.dbschemaComboBox.getSelectedItem())) {
            return false;
        }
        this.dbschemaRadioButton.setSelected(true);
        return true;
    }

    public SchemaElement getSourceSchemaElement() {
        return this.sourceSchemaElement;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    public FileObject getDBSchemaFile() {
        return this.dbschemaFile;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public TableClosure getTableClosure() {
        return this.tableClosure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSourceSchema() {
        Object item;
        if (!this.sourceSchemaUpdateEnabled) {
            return;
        }
        this.sourceSchemaElement = null;
        this.datasourceName = null;
        this.dbconn = null;
        this.dbschemaFile = null;
        if (this.datasourceRadioButton.isSelected()) {
            JPADataSource jpaDS;
            item = this.datasourceComboBox.getSelectedItem();
            JPADataSourceProvider dsProvider = (JPADataSourceProvider)this.project.getLookup().lookup(JPADataSourceProvider.class);
            JPADataSource jPADataSource = jpaDS = dsProvider != null ? dsProvider.toJPADataSource(item) : null;
            if (jpaDS != null) {
                List<DatabaseConnection> dbconns = DatabaseTablesPanel.findDatabaseConnections(jpaDS);
                if (!dbconns.isEmpty()) {
                    this.dbconn = dbconns.get(0);
                } else {
                    String drvClass = jpaDS.getDriverClassName();
                    if (drvClass == null) {
                        DatabaseTablesPanel.notify(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_NoDriverClassName"));
                    } else {
                        JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers(drvClass);
                        if (drivers.length == 0) {
                            DatabaseTablesPanel.notify(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_NoDriverError", (Object)drvClass));
                        } else {
                            JDBCDriver driver = JDBCDriverManager.getDefault().getDrivers(drvClass)[0];
                            this.dbconn = ConnectionManager.getDefault().showAddConnectionDialogFromEventThread(driver, jpaDS.getUrl(), jpaDS.getUsername(), jpaDS.getPassword());
                        }
                    }
                }
                if (this.dbconn != null) {
                    try {
                        this.sourceSchemaElement = this.dbschemaManager.getSchemaElement(this.dbconn);
                        this.datasourceName = jpaDS.getJndiName();
                    }
                    catch (SQLException e) {
                        DatabaseTablesPanel.notify(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_DatabaseError"));
                    }
                }
            } else if (item instanceof DatabaseConnection) {
                this.dbconn = (DatabaseConnection)item;
                try {
                    this.sourceSchemaElement = this.dbschemaManager.getSchemaElement(this.dbconn);
                }
                catch (SQLException e) {
                    DatabaseTablesPanel.notify(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_DatabaseError"));
                }
                finally {
                    if (this.sourceSchemaElement == null) {
                        this.datasourceComboBox.setSelectedIndex(-1);
                    }
                }
            }
        } else if (this.dbschemaRadioButton.isSelected() && (item = this.dbschemaComboBox.getSelectedItem()) instanceof FileObject) {
            this.dbschemaFile = (FileObject)item;
            this.sourceSchemaElement = this.dbschemaManager.getSchemaElement(this.dbschemaFile);
        }
        TableProvider tableProvider = null;
        tableProvider = this.sourceSchemaElement != null ? new DBSchemaTableProvider(this.sourceSchemaElement, this.persistenceGen, this.project) : new EmptyTableProvider();
        this.tableClosure = new TableClosure(tableProvider);
        this.tableClosure.setClosureEnabled(this.tableClosureCheckBox.isSelected());
        TableUISupport.connectAvailable(this.availableTablesList, this.tableClosure, this.filterAvailable);
        TableUISupport.connectSelected(this.selectedTablesList, this.tableClosure);
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private static void notify(String message) {
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }

    private void updateSourceSchemaComboBoxes() {
        this.datasourceComboBox.setEnabled(this.datasourceRadioButton.isSelected());
        this.dbschemaComboBox.setEnabled(this.dbschemaRadioButton.isSelected());
    }

    private void updateButtons() {
        Set<Table> addTables = TableUISupport.getSelectedTables(this.availableTablesList, true);
        Set<Table> allSelectedTables = TableUISupport.getSelectedTables(this.availableTablesList, false);
        this.addButton.setEnabled(this.tableClosure.canAddAllTables(addTables));
        this.addAllButton.setEnabled(!TableUISupport.getEnabledTables(this.availableTablesList).isEmpty());
        Set<Table> tables = TableUISupport.getSelectedTables(this.selectedTablesList);
        this.removeButton.setEnabled(this.tableClosure.canRemoveAllTables(tables));
        this.removeAllButton.setEnabled(!this.tableClosure.getSelectedTables().isEmpty());
        String problems = "";
        for (Table t : allSelectedTables) {
            String existingClass;
            if (!t.isDisabled()) continue;
            if (t.getDisabledReason() instanceof Table.ExistingDisabledReason) {
                existingClass = ((Table.ExistingDisabledReason)t.getDisabledReason()).getFQClassName();
                if (this.allowUpdateRecreate) {
                    problems = problems + (problems.length() > 0 ? "\n" : "") + NbBundle.getMessage(DatabaseTablesPanel.class, (String)"MSG_Already_Mapped_UpdateAllowed", (Object[])new Object[]{t.getName(), existingClass});
                    continue;
                }
                problems = problems + (problems.length() > 0 ? "\n" : "") + NbBundle.getMessage(DatabaseTablesPanel.class, (String)"MSG_Already_Mapped_UpdateAllowed", (Object[])new Object[]{t.getName(), existingClass});
                continue;
            }
            if (t.getDisabledReason() instanceof Table.ExistingNotInSourceDisabledReason) {
                existingClass = ((Table.ExistingNotInSourceDisabledReason)t.getDisabledReason()).getFQClassName();
                problems = problems + (problems.length() > 0 ? "\n" : "") + NbBundle.getMessage(DatabaseTablesPanel.class, (String)"MSG_Already_Mapped_NotInSource", (Object[])new Object[]{t.getName(), existingClass});
                continue;
            }
            if (!(t.getDisabledReason() instanceof Table.NoPrimaryKeyDisabledReason)) continue;
            problems = problems + (problems.length() > 0 ? "\n" : "") + NbBundle.getMessage(DatabaseTablesPanel.class, (String)"MSG_No_Primary_Key", (Object[])new Object[]{t.getName()});
        }
        this.tableError.setText(problems);
        this.tableError.setCaretPosition(0);
    }

    private void initComponents() {
        this.schemaSource = new ButtonGroup();
        this.comboPanel = new JPanel();
        this.datasourceLabel = new JLabel();
        this.datasourceRadioButton = new JRadioButton();
        this.datasourceComboBox = new JComboBox();
        this.dbschemaRadioButton = new JRadioButton();
        this.dbschemaComboBox = new JComboBox();
        this.tablesPanel = new TablesPanel();
        this.availableTablesLabel = new JLabel();
        this.availableTablesScrollPane = new JScrollPane();
        this.availableTablesList = TableUISupport.createTableList();
        this.selectedTablesLabel = new JLabel();
        this.selectedTablesScrollPane = new JScrollPane();
        this.selectedTablesList = TableUISupport.createTableList();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addAllButton = new JButton();
        this.removeAllButton = new JButton();
        this.tableClosureCheckBox = new JCheckBox();
        this.addAllTypeCombo = new JComboBox();
        this.tableErrorScroll = new JScrollPane();
        this.tableError = new JTextPane();
        this.setMinimumSize(new Dimension(200, 300));
        this.setName(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_DatabaseTables"));
        this.setPreferredSize(new Dimension(496, 350));
        this.setLayout(new GridBagLayout());
        this.comboPanel.setLayout(new GridBagLayout());
        this.datasourceLabel.setLabelFor(this.datasourceComboBox);
        Mnemonics.setLocalizedText((JLabel)this.datasourceLabel, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_Datasource"));
        this.datasourceLabel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        this.comboPanel.add((Component)this.datasourceLabel, gridBagConstraints);
        this.schemaSource.add(this.datasourceRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.datasourceRadioButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_Datasource"));
        this.datasourceRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DatabaseTablesPanel.this.datasourceRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.comboPanel.add((Component)this.datasourceRadioButton, gridBagConstraints);
        this.datasourceComboBox.setEnabled(false);
        this.datasourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseTablesPanel.this.datasourceComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 2, 0, 0);
        this.comboPanel.add((Component)this.datasourceComboBox, gridBagConstraints);
        this.schemaSource.add(this.dbschemaRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.dbschemaRadioButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_DbSchema"));
        this.dbschemaRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DatabaseTablesPanel.this.dbschemaRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.comboPanel.add((Component)this.dbschemaRadioButton, gridBagConstraints);
        this.dbschemaComboBox.setEnabled(false);
        this.dbschemaComboBox.setNextFocusableComponent(this.availableTablesList);
        this.dbschemaComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseTablesPanel.this.dbschemaComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 0, 0);
        this.comboPanel.add((Component)this.dbschemaComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.comboPanel, gridBagConstraints);
        this.tablesPanel.setPreferredSize(new Dimension(440, 174));
        this.tablesPanel.setLayout(new GridBagLayout());
        this.availableTablesLabel.setLabelFor(this.availableTablesList);
        Mnemonics.setLocalizedText((JLabel)this.availableTablesLabel, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_AvailableTables"));
        this.availableTablesLabel.setToolTipText(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"TXT_AvailableTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.tablesPanel.add((Component)this.availableTablesLabel, gridBagConstraints);
        this.availableTablesScrollPane.setPreferredSize(new Dimension(160, 130));
        this.availableTablesList.setNextFocusableComponent(this.addButton);
        this.availableTablesScrollPane.setViewportView(this.availableTablesList);
        this.availableTablesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ACSN_AvailableTables"));
        this.availableTablesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ACSD_AvailableTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tablesPanel.add((Component)this.availableTablesScrollPane, gridBagConstraints);
        this.selectedTablesLabel.setLabelFor(this.selectedTablesList);
        Mnemonics.setLocalizedText((JLabel)this.selectedTablesLabel, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_SelectedTables"));
        this.selectedTablesLabel.setToolTipText(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"TXT_SelectedTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.tablesPanel.add((Component)this.selectedTablesLabel, gridBagConstraints);
        this.selectedTablesScrollPane.setPreferredSize(new Dimension(160, 130));
        this.selectedTablesScrollPane.setViewportView(this.selectedTablesList);
        this.selectedTablesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ACSN_SelectedTables"));
        this.selectedTablesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ACSD_SelectedTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tablesPanel.add((Component)this.selectedTablesScrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseTablesPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseTablesPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addAllButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_AddAll"));
        this.addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseTablesPanel.this.addAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.buttonPanel.add((Component)this.addAllButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeAllButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_RemoveAll"));
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseTablesPanel.this.removeAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this.tablesPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.tableClosureCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tableClosureCheckBox, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_IncludeRelatedTables"));
        this.tableClosureCheckBox.setToolTipText(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"TXT_IncludeRelatedTables"));
        this.tableClosureCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableClosureCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DatabaseTablesPanel.this.tableClosureCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 4, 0);
        this.tablesPanel.add((Component)this.tableClosureCheckBox, gridBagConstraints);
        this.addAllTypeCombo.setModel(new DefaultComboBoxModel<String>(this.filterComboTxts));
        this.addAllTypeCombo.setRenderer(new ItemListCellRenderer());
        this.addAllTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseTablesPanel.this.addAllTypeComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 4, 0);
        this.tablesPanel.add((Component)this.addAllTypeCombo, gridBagConstraints);
        this.addAllTypeCombo.getAccessibleContext().setAccessibleName("Tables filter");
        this.addAllTypeCombo.getAccessibleContext().setAccessibleDescription("Tables filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 80;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.tablesPanel, gridBagConstraints);
        this.tableErrorScroll.setBorder(null);
        this.tableError.setEditable(false);
        this.tableError.setCursor(new Cursor(0));
        this.tableError.setOpaque(false);
        this.tableErrorScroll.setViewportView(this.tableError);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.tableErrorScroll, gridBagConstraints);
    }

    private void tableClosureCheckBoxItemStateChanged(ItemEvent evt) {
        this.tableClosure.setClosureEnabled(this.tableClosureCheckBox.isSelected());
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        this.tableClosure.removeAllTables();
        this.selectedTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        Set<Table> tables = TableUISupport.getEnabledTables(this.availableTablesList);
        this.tableClosure.addTables(tables);
        this.availableTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Set<Table> tables = TableUISupport.getSelectedTables(this.selectedTablesList);
        this.tableClosure.removeTables(tables);
        this.selectedTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        Set<Table> tables = TableUISupport.getSelectedTables(this.availableTablesList, true);
        this.tableClosure.addTables(tables);
        this.availableTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void dbschemaComboBoxActionPerformed(ActionEvent evt) {
        this.updateSourceSchema();
    }

    private void dbschemaRadioButtonItemStateChanged(ItemEvent evt) {
        this.updateSourceSchemaComboBoxes();
        this.updateSourceSchema();
    }

    private void datasourceComboBoxActionPerformed(ActionEvent evt) {
        this.datasourceComboBox.hidePopup();
        this.updateSourceSchema();
    }

    private void datasourceRadioButtonItemStateChanged(ItemEvent evt) {
        this.updateSourceSchemaComboBoxes();
        this.updateSourceSchema();
    }

    private void addAllTypeComboActionPerformed(ActionEvent evt) {
        this.filterAvailable = this.filterComboTxts[0].equals(this.addAllTypeCombo.getSelectedItem().toString()) ? TableUISupport.FilterAvailable.ANY : (this.filterComboTxts[1].equals(this.addAllTypeCombo.getSelectedItem().toString()) ? TableUISupport.FilterAvailable.NEW : TableUISupport.FilterAvailable.UPDATE);
        TableUISupport.connectAvailable(this.availableTablesList, this.tableClosure, this.filterAvailable);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.initSubComponents();
        this.removeAncestorListener(this);
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    private static class ItemListCellRenderer
    extends DefaultListCellRenderer {
        private ItemListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            JLabel label = (JLabel)component;
            label.setText(value.toString());
            return label;
        }
    }

    public static final class WizardPanel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    ChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private DatabaseTablesPanel component;
        private boolean componentInitialized;
        private WizardDescriptor wizardDescriptor;
        private Project project;
        boolean waitingForScan;
        private String title;

        public WizardPanel(String wizardTitle) {
            this.title = wizardTitle;
        }

        public DatabaseTablesPanel getComponent() {
            if (this.component == null) {
                this.component = new DatabaseTablesPanel();
                this.component.addChangeListener(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(DatabaseTablesPanel.class);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public void readSettings(WizardDescriptor settings) {
            this.wizardDescriptor = settings;
            if (this.title != null) {
                this.wizardDescriptor.putProperty("NewFileWizard_Title", (Object)this.title);
            }
            if (!this.componentInitialized) {
                this.componentInitialized = true;
                this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
                RelatedCMPHelper helper = RelatedCMPWizard.getHelper(this.wizardDescriptor);
                DBSchemaFileList dbschemaFileList = helper.getDBSchemaFileList();
                PersistenceGenerator persistenceGen = helper.getPersistenceGenerator();
                TableSource tableSource = helper.getTableSource();
                FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
                this.getComponent().initialize(this.project, dbschemaFileList, persistenceGen, tableSource, targetFolder);
            }
        }

        public boolean isValid() {
            Sources sources = ProjectUtils.getSources((Project)this.project);
            SourceGroup[] groups = sources.getSourceGroups("java");
            if (groups == null || groups.length == 0) {
                this.setErrorMessage(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_JavaSourceGroup"));
                this.getComponent().datasourceComboBox.setEnabled(false);
                this.getComponent().dbschemaComboBox.setEnabled(false);
                return false;
            }
            if (SourceLevelChecker.isSourceLevel14orLower(this.project)) {
                this.setErrorMessage(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_NeedProperSourceLevel"));
                return false;
            }
            if (this.getComponent().getSourceSchemaElement() == null) {
                this.setErrorMessage(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_SelectTableSource"));
                return false;
            }
            if (this.getComponent().getTableClosure().getSelectedTables().size() <= 0) {
                this.setErrorMessage(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_SelectTables"));
                return false;
            }
            for (Table table : this.getComponent().getTableClosure().getSelectedTables()) {
                if (table.isTable()) continue;
                this.setWarningMessage(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"MSG_ViewSelected"));
                return true;
            }
            this.setErrorMessage(" ");
            if (!ProviderUtil.isValidServerInstanceOrNone(this.project)) {
                this.setWarningMessage(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_MissingServer"));
            }
            return true;
        }

        public void storeSettings(WizardDescriptor settings) {
            RelatedCMPHelper helper = RelatedCMPWizard.getHelper(this.wizardDescriptor);
            SchemaElement sourceSchemaElement = this.getComponent().getSourceSchemaElement();
            DatabaseConnection dbconn = this.getComponent().getDatabaseConnection();
            FileObject dbschemaFile = this.getComponent().getDBSchemaFile();
            String datasourceName = this.getComponent().getDatasourceName();
            if (dbschemaFile != null) {
                helper.setTableSource(sourceSchemaElement, dbschemaFile);
            } else {
                helper.setTableSource(sourceSchemaElement, dbconn, datasourceName);
            }
            if (this.getComponent().getTableClosure() != null) {
                helper.setTableClosure(this.getComponent().getTableClosure());
            }
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            this.changeSupport.fireChange();
        }

        private void setErrorMessage(String errorMessage) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
        }

        private void setWarningMessage(String warningMessage) {
            this.wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)warningMessage);
        }

        private /* synthetic */ void lambda$isValid$0() {
            this.waitingForScan = false;
            this.changeSupport.fireChange();
        }
    }

    private final class TablesPanel
    extends JPanel {
        private TablesPanel() {
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Rectangle availableBounds = DatabaseTablesPanel.this.availableTablesScrollPane.getBounds();
            Rectangle selectedBounds = DatabaseTablesPanel.this.selectedTablesScrollPane.getBounds();
            if (Math.abs(availableBounds.width - selectedBounds.width) > 1) {
                GridBagConstraints buttonPanelConstraints = ((GridBagLayout)this.getLayout()).getConstraints(DatabaseTablesPanel.this.buttonPanel);
                int totalWidth = this.getWidth() - DatabaseTablesPanel.this.buttonPanel.getWidth() - buttonPanelConstraints.insets.left - buttonPanelConstraints.insets.right;
                int equalWidth = totalWidth / 2;
                int xOffset = equalWidth - availableBounds.width;
                availableBounds.width = equalWidth;
                DatabaseTablesPanel.this.availableTablesScrollPane.setBounds(availableBounds);
                Rectangle addAllCmbRec = DatabaseTablesPanel.this.addAllTypeCombo.getBounds();
                if (addAllCmbRec.x + addAllCmbRec.width != availableBounds.x + availableBounds.width) {
                    addAllCmbRec.x = availableBounds.x + availableBounds.width - addAllCmbRec.width;
                    DatabaseTablesPanel.this.addAllTypeCombo.setBounds(addAllCmbRec);
                }
                Rectangle buttonBounds = DatabaseTablesPanel.this.buttonPanel.getBounds();
                buttonBounds.x += xOffset;
                DatabaseTablesPanel.this.buttonPanel.setBounds(buttonBounds);
                Rectangle labelBounds = DatabaseTablesPanel.this.selectedTablesLabel.getBounds();
                labelBounds.x += xOffset;
                DatabaseTablesPanel.this.selectedTablesLabel.setBounds(labelBounds);
                selectedBounds.x += xOffset;
                selectedBounds.width = totalWidth - equalWidth;
                DatabaseTablesPanel.this.selectedTablesScrollPane.setBounds(selectedBounds);
                Rectangle tableClosureBounds = DatabaseTablesPanel.this.tableClosureCheckBox.getBounds();
                tableClosureBounds.x += xOffset;
                tableClosureBounds.width = totalWidth - equalWidth;
                DatabaseTablesPanel.this.tableClosureCheckBox.setBounds(tableClosureBounds);
            }
        }
    }
}

